require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&AWI_SELFTEST_TIMEOUT)) {
    sub AWI_SELFTEST_TIMEOUT () {	5000;}
}
unless(defined(&AWI_CMD_TIMEOUT)) {
    sub AWI_CMD_TIMEOUT () {	2000;}
}
unless(defined(&AWI_LOCKOUT_TIMEOUT)) {
    sub AWI_LOCKOUT_TIMEOUT () {	50;}
}
unless(defined(&AWI_ASCAN_DURATION)) {
    sub AWI_ASCAN_DURATION () {	100;}
}
unless(defined(&AWI_ASCAN_WAIT)) {
    sub AWI_ASCAN_WAIT () {	3000;}
}
unless(defined(&AWI_PSCAN_DURATION)) {
    sub AWI_PSCAN_DURATION () {	200;}
}
unless(defined(&AWI_PSCAN_WAIT)) {
    sub AWI_PSCAN_WAIT () {	5000;}
}
unless(defined(&AWI_TRANS_TIMEOUT)) {
    sub AWI_TRANS_TIMEOUT () {	2000;}
}
unless(defined(&AWI_NTXBUFS)) {
    sub AWI_NTXBUFS () {	4;}
}
unless(defined(&AWI_MAX_KEYLEN)) {
    sub AWI_MAX_KEYLEN () {	16;}
}
eval("sub AWI_ST_INIT () { 0; }") unless defined(&AWI_ST_INIT);
eval("sub AWI_ST_SCAN () { 1; }") unless defined(&AWI_ST_SCAN);
eval("sub AWI_ST_SETSS () { 2; }") unless defined(&AWI_ST_SETSS);
eval("sub AWI_ST_SYNC () { 3; }") unless defined(&AWI_ST_SYNC);
eval("sub AWI_ST_AUTH () { 4; }") unless defined(&AWI_ST_AUTH);
eval("sub AWI_ST_ASSOC () { 5; }") unless defined(&AWI_ST_ASSOC);
eval("sub AWI_ST_RUNNING () { 6; }") unless defined(&AWI_ST_RUNNING);
if(defined(&__NetBSD__)) {
}
if(defined(&__FreeBSD__)) {
    if((defined(&__FreeBSD__) ? &__FreeBSD__ : 0) >= 4) {
    } else {
    }
}
if(defined(&__OpenBSD__)) {
}
unless(defined(&awi_read_1)) {
    sub awi_read_1 {
	my($sc, $off) = @_;
	eval q((($sc)-> ($sc_chip->{sc_ops}->{read_1}))( ($sc->{sc_chip}), $off));
    }
}
unless(defined(&awi_read_2)) {
    sub awi_read_2 {
	my($sc, $off) = @_;
	eval q((($sc)-> ($sc_chip->{sc_ops}->{read_2}))( ($sc->{sc_chip}), $off));
    }
}
unless(defined(&awi_read_4)) {
    sub awi_read_4 {
	my($sc, $off) = @_;
	eval q((($sc)-> ($sc_chip->{sc_ops}->{read_4}))( ($sc->{sc_chip}), $off));
    }
}
unless(defined(&awi_read_bytes)) {
    sub awi_read_bytes {
	my($sc, $off, $ptr, $len) = @_;
	eval q((($sc)-> ($sc_chip->{sc_ops}->{read_bytes}))( ($sc->{sc_chip}), $off, $ptr, $len));
    }
}
unless(defined(&awi_write_1)) {
    sub awi_write_1 {
	my($sc, $off, $val) = @_;
	eval q((($sc)-> ($sc_chip->{sc_ops}->{write_1}))( ($sc->{sc_chip}), $off, $val));
    }
}
unless(defined(&awi_write_2)) {
    sub awi_write_2 {
	my($sc, $off, $val) = @_;
	eval q((($sc)-> ($sc_chip->{sc_ops}->{write_2}))( ($sc->{sc_chip}), $off, $val));
    }
}
unless(defined(&awi_write_4)) {
    sub awi_write_4 {
	my($sc, $off, $val) = @_;
	eval q((($sc)-> ($sc_chip->{sc_ops}->{write_4}))( ($sc->{sc_chip}), $off, $val));
    }
}
unless(defined(&awi_write_bytes)) {
    sub awi_write_bytes {
	my($sc, $off, $ptr, $len) = @_;
	eval q((($sc)-> ($sc_chip->{sc_ops}->{write_bytes}))( ($sc->{sc_chip}), $off, $ptr, $len));
    }
}
unless(defined(&awi_drvstate)) {
    sub awi_drvstate {
	my($sc, $state) = @_;
	eval q( &awi_write_1($sc,  &AWI_DRIVERSTATE, (($state) |  &AWI_DRV_AUTORXLED| &AWI_DRV_AUTOTXLED)));
    }
}
unless(defined(&LE_READ_2)) {
    sub LE_READ_2 {
	my($p) = @_;
	eval q(((( &u_int8_t *)($p))[0] | ((( &u_int8_t *)($p))[1] << 8)));
    }
}
unless(defined(&LE_READ_4)) {
    sub LE_READ_4 {
	my($p) = @_;
	eval q(((( &u_int8_t *)($p))[0] | ((( &u_int8_t *)($p))[1] << 8) | ((( &u_int8_t *)($p))[2] << 16) | ((( &u_int8_t *)($p))[3] << 24)));
    }
}
unless(defined(&LE_WRITE_2)) {
    sub LE_WRITE_2 {
	my($p, $v) = @_;
	eval q((((( &u_int8_t *)($p))[0] = (( &u_int32_t)($v) & 0xff)), ((( &u_int8_t *)($p))[1] = ((( &u_int32_t)($v) >> 8) & 0xff))));
    }
}
unless(defined(&LE_WRITE_4)) {
    sub LE_WRITE_4 {
	my($p, $v) = @_;
	eval q((((( &u_int8_t *)($p))[0] = (( &u_int32_t)($v) & 0xff)), ((( &u_int8_t *)($p))[1] = ((( &u_int32_t)($v) >> 8) & 0xff)), ((( &u_int8_t *)($p))[2] = ((( &u_int32_t)($v) >> 16) & 0xff)), ((( &u_int8_t *)($p))[3] = ((( &u_int32_t)($v) >> 24) & 0xff))));
    }
}
unless(defined(&AWI_80211_RATE)) {
    sub AWI_80211_RATE {
	my($rate) = @_;
	eval q(((($rate) & 0x7f) * 5));
    }
}
unless(defined(&__FreeBSD__)) {
}
if(defined(&__FreeBSD__)) {
    eval 'sub memset {
        my($b,$c,$len) = @_;
	    eval q({  &bzero($b, $len); ($b); });
    }' unless defined(&memset);
}
1;
