require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_SYS_SCHED_H_)) {
    eval 'sub _SYS_SCHED_H_ () {1;}' unless defined(&_SYS_SCHED_H_);
    eval 'sub CP_USER () {0;}' unless defined(&CP_USER);
    eval 'sub CP_NICE () {1;}' unless defined(&CP_NICE);
    eval 'sub CP_SYS () {2;}' unless defined(&CP_SYS);
    eval 'sub CP_INTR () {3;}' unless defined(&CP_INTR);
    eval 'sub CP_IDLE () {4;}' unless defined(&CP_IDLE);
    eval 'sub CPUSTATES () {5;}' unless defined(&CPUSTATES);
    if(defined(&_KERNEL)) {
	eval 'sub SPCF_SEENRR () {0x1;}' unless defined(&SPCF_SEENRR);
	eval 'sub SPCF_SHOULDYIELD () {0x2;}' unless defined(&SPCF_SHOULDYIELD);
	eval 'sub SPCF_SWITCHCLEAR () {( &SPCF_SEENRR| &SPCF_SHOULDYIELD);}' unless defined(&SPCF_SWITCHCLEAR);
	eval 'sub PPQ () {(128/  &NQS);}' unless defined(&PPQ);
	eval 'sub NICE_WEIGHT () {2;}' unless defined(&NICE_WEIGHT);
	eval 'sub ESTCPULIM {
	    my($e) = @_;
    	    eval q( &min(($e),  &NICE_WEIGHT *  &PRIO_MAX -  &PPQ));
	}' unless defined(&ESTCPULIM);
	if(defined(&__HAVE_CPUINFO)) {
	}
	eval 'sub scheduler_fork_hook {
	    my($parent, $child) = @_;
    	    eval q( &do { ($child)-> &p_estcpu = ($parent)-> &p_estcpu; }  &while (0));
	}' unless defined(&scheduler_fork_hook);
	eval 'sub scheduler_wait_hook {
	    my($parent, $child) = @_;
    	    eval q( &do { ($parent)-> &p_estcpu =  &ESTCPULIM(($parent)-> &p_estcpu + ($child)-> &p_estcpu);}  &while (0));
	}' unless defined(&scheduler_wait_hook);
	if(!defined( &__HAVE_CPUINFO)  && !defined( &splsched)) {
	    eval 'sub splsched () {
	        eval q( &splhigh());
	    }' unless defined(&splsched);
	}
	unless(defined(&IPL_SCHED)) {
	    eval 'sub IPL_SCHED () { &IPL_HIGH;}' unless defined(&IPL_SCHED);
	}
	if(defined( &MULTIPROCESSOR) || defined( &LOCKDEBUG)) {
	    require 'sys/lock.ph';
	    if(defined(&notyet)) {
		eval 'sub SCHED_ASSERT_LOCKED () {
		    eval q( &KASSERT( &simple_lock_held( &sched_lock)));
		}' unless defined(&SCHED_ASSERT_LOCKED);
		eval 'sub SCHED_ASSERT_UNLOCKED () {
		    eval q( &KASSERT( &simple_lock_held( &sched_lock) == 0));
		}' unless defined(&SCHED_ASSERT_UNLOCKED);
		eval 'sub SCHED_LOCK {
		    my($s) = @_;
    		    eval q( &do { $s =  &splsched();  &simple_lock( &sched_lock); }  &while ( 0));
		}' unless defined(&SCHED_LOCK);
		eval 'sub SCHED_UNLOCK {
		    my($s) = @_;
    		    eval q( &do {  &simple_unlock( &sched_lock);  &splx($s); }  &while ( 0));
		}' unless defined(&SCHED_UNLOCK);
	    } else {
		eval 'sub SCHED_ASSERT_LOCKED () {
		    eval q( &KASSERT( &__mp_lock_held( &sched_lock)));
		}' unless defined(&SCHED_ASSERT_LOCKED);
		eval 'sub SCHED_ASSERT_UNLOCKED () {
		    eval q( &KASSERT( &__mp_lock_held( &sched_lock) == 0));
		}' unless defined(&SCHED_ASSERT_UNLOCKED);
		eval 'sub SCHED_LOCK {
		    my($s) = @_;
    		    eval q( &do { $s =  &splsched();  &__mp_lock( &sched_lock); }  &while ( 0));
		}' unless defined(&SCHED_LOCK);
		eval 'sub SCHED_UNLOCK {
		    my($s) = @_;
    		    eval q( &do {  &__mp_unlock( &sched_lock);  &splx($s); }  &while ( 0));
		}' unless defined(&SCHED_UNLOCK);
	    }
	} else {
	    eval 'sub SCHED_ASSERT_LOCKED () {
	        eval q( &splassert( &IPL_SCHED););
	    }' unless defined(&SCHED_ASSERT_LOCKED);
	    eval 'sub SCHED_ASSERT_UNLOCKED () {
	        eval q();
	    }' unless defined(&SCHED_ASSERT_UNLOCKED);
	    eval 'sub SCHED_LOCK {
	        my($s) = @_;
    		eval q($s =  &splsched());
	    }' unless defined(&SCHED_LOCK);
	    eval 'sub SCHED_UNLOCK {
	        my($s) = @_;
    		eval q( &splx($s));
	    }' unless defined(&SCHED_UNLOCK);
	}
    }
}
1;
