require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_VAX_DB_MACHDEP_H_)) {
    eval 'sub _VAX_DB_MACHDEP_H_ () {1;}' unless defined(&_VAX_DB_MACHDEP_H_);
    require 'sys/param.ph';
    require 'uvm/uvm_extern.ph';
    require 'machine/trap.ph';
    require 'machine/psl.ph';
    eval 'sub DDB_REGS () {( &ddb_regs);}' unless defined(&DDB_REGS);
    eval 'sub PC_REGS {
        local($regs) = @_;
	    eval q((( &db_addr_t)($regs)-> &pc));
    }' unless defined(&PC_REGS);
    eval 'sub SET_PC_REGS {
        local($regs, $value) = @_;
	    eval q(-> &pc = ($value));
    }' unless defined(&SET_PC_REGS);
    eval 'sub BKPT_INST () {0x3;}' unless defined(&BKPT_INST);
    eval 'sub BKPT_SIZE () {(1);}' unless defined(&BKPT_SIZE);
    eval 'sub BKPT_SET {
        local($inst) = @_;
	    eval q(( &BKPT_INST));
    }' unless defined(&BKPT_SET);
    eval 'sub FIXUP_PC_AFTER_BREAK {
        local($regs) = @_;
	    eval q((($regs)-> &pc -=  &BKPT_SIZE));
    }' unless defined(&FIXUP_PC_AFTER_BREAK);
    eval 'sub db_clear_single_step {
        local($regs) = @_;
	    eval q((($regs)-> &psl &= ~ &PSL_T));
    }' unless defined(&db_clear_single_step);
    eval 'sub db_set_single_step {
        local($regs) = @_;
	    eval q((($regs)-> &psl |=  &PSL_T));
    }' unless defined(&db_set_single_step);
    eval 'sub IS_BREAKPOINT_TRAP {
        local($type, $code) = @_;
	    eval q((($type) ==  &T_BPTFLT));
    }' unless defined(&IS_BREAKPOINT_TRAP);
    eval 'sub IS_WATCHPOINT_TRAP {
        local($type, $code) = @_;
	    eval q((($type) ==  &T_TRCTRAP));
    }' unless defined(&IS_WATCHPOINT_TRAP);
    eval 'sub I_CALL () {0xfb;}' unless defined(&I_CALL);
    eval 'sub I_RET () {0x4;}' unless defined(&I_RET);
    eval 'sub I_IRET () {0x2;}' unless defined(&I_IRET);
    eval 'sub inst_trap_return {
        local($ins) = @_;
	    eval q(((($ins)&0xff) ==  &I_IRET));
    }' unless defined(&inst_trap_return);
    eval 'sub inst_return {
        local($ins) = @_;
	    eval q(((($ins)&0xff) ==  &I_RET));
    }' unless defined(&inst_return);
    eval 'sub inst_call {
        local($ins) = @_;
	    eval q(((($ins)&0xff) ==  &I_CALL));
    }' unless defined(&inst_call);
    eval 'sub inst_load {
        local($ins) = @_;
	    eval q(0);
    }' unless defined(&inst_load);
    eval 'sub inst_store {
        local($ins) = @_;
	    eval q(0);
    }' unless defined(&inst_store);
    eval 'sub DB_AOUT_SYMBOLS () {1;}' unless defined(&DB_AOUT_SYMBOLS);
}
1;
