require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_DEV_PCI_EHCIREG_H_)) {
    eval 'sub _DEV_PCI_EHCIREG_H_ () {1;}' unless defined(&_DEV_PCI_EHCIREG_H_);
    eval 'sub PCI_CBMEM () {0x10;}' unless defined(&PCI_CBMEM);
    eval 'sub PCI_INTERFACE_EHCI () {0x20;}' unless defined(&PCI_INTERFACE_EHCI);
    eval 'sub PCI_USBREV () {0x60;}' unless defined(&PCI_USBREV);
    eval 'sub PCI_USBREV_MASK () {0xff;}' unless defined(&PCI_USBREV_MASK);
    eval 'sub PCI_USBREV_PRE_1_0 () {0x;}' unless defined(&PCI_USBREV_PRE_1_0);
    eval 'sub PCI_USBREV_1_0 () {0x10;}' unless defined(&PCI_USBREV_1_0);
    eval 'sub PCI_USBREV_1_1 () {0x11;}' unless defined(&PCI_USBREV_1_1);
    eval 'sub PCI_USBREV_2_0 () {0x20;}' unless defined(&PCI_USBREV_2_0);
    eval 'sub PCI_EHCI_FLADJ () {0x61;}' unless defined(&PCI_EHCI_FLADJ);
    eval 'sub PCI_EHCI_PORTWAKECAP () {0x62;}' unless defined(&PCI_EHCI_PORTWAKECAP);
    eval 'sub EHCI_EC_LEGSUP () {0x1;}' unless defined(&EHCI_EC_LEGSUP);
    eval 'sub EHCI_EECP_NEXT {
        local($x) = @_;
	    eval q(((($x) >> 8) & 0xff));
    }' unless defined(&EHCI_EECP_NEXT);
    eval 'sub EHCI_EECP_ID {
        local($x) = @_;
	    eval q((($x) & 0xff));
    }' unless defined(&EHCI_EECP_ID);
    eval 'sub EHCI_LEGSUP_LEGSUP () {0x;}' unless defined(&EHCI_LEGSUP_LEGSUP);
    eval 'sub EHCI_LEGSUP_OSOWNED () {0x1000000;}' unless defined(&EHCI_LEGSUP_OSOWNED);
    eval 'sub EHCI_LEGSUP_BIOSOWNED () {0x10000;}' unless defined(&EHCI_LEGSUP_BIOSOWNED);
    eval 'sub PCI_LEGSUP_USBLEGCTLSTS () {0x4;}' unless defined(&PCI_LEGSUP_USBLEGCTLSTS);
    eval 'sub EHCI_CAPLENGTH () {0x;}' unless defined(&EHCI_CAPLENGTH);
    eval 'sub EHCI_HCIVERSION () {0x2;}' unless defined(&EHCI_HCIVERSION);
    eval 'sub EHCI_HCSPARAMS () {0x4;}' unless defined(&EHCI_HCSPARAMS);
    eval 'sub EHCI_HCS_DEBUGPORT {
        local($x) = @_;
	    eval q(((($x) >> 20) & 0xf));
    }' unless defined(&EHCI_HCS_DEBUGPORT);
    eval 'sub EHCI_HCS_P_INDICATOR {
        local($x) = @_;
	    eval q((($x) & 0x10000));
    }' unless defined(&EHCI_HCS_P_INDICATOR);
    eval 'sub EHCI_HCS_N_CC {
        local($x) = @_;
	    eval q(((($x) >> 12) & 0xf));
    }' unless defined(&EHCI_HCS_N_CC);
    eval 'sub EHCI_HCS_N_PCC {
        local($x) = @_;
	    eval q(((($x) >> 8) & 0xf));
    }' unless defined(&EHCI_HCS_N_PCC);
    eval 'sub EHCI_HCS_PRR {
        local($x) = @_;
	    eval q((($x) & 0x80));
    }' unless defined(&EHCI_HCS_PRR);
    eval 'sub EHCI_HCS_PPC {
        local($x) = @_;
	    eval q((($x) & 0x10));
    }' unless defined(&EHCI_HCS_PPC);
    eval 'sub EHCI_HCS_N_PORTS {
        local($x) = @_;
	    eval q((($x) & 0xf));
    }' unless defined(&EHCI_HCS_N_PORTS);
    eval 'sub EHCI_HCCPARAMS () {0x8;}' unless defined(&EHCI_HCCPARAMS);
    eval 'sub EHCI_HCC_EECP {
        local($x) = @_;
	    eval q(((($x) >> 8) & 0xff));
    }' unless defined(&EHCI_HCC_EECP);
    eval 'sub EHCI_HCC_IST {
        local($x) = @_;
	    eval q(((($x) >> 4) & 0xf));
    }' unless defined(&EHCI_HCC_IST);
    eval 'sub EHCI_HCC_ASPC {
        local($x) = @_;
	    eval q((($x) & 0x4));
    }' unless defined(&EHCI_HCC_ASPC);
    eval 'sub EHCI_HCC_PFLF {
        local($x) = @_;
	    eval q((($x) & 0x2));
    }' unless defined(&EHCI_HCC_PFLF);
    eval 'sub EHCI_HCC_64BIT {
        local($x) = @_;
	    eval q((($x) & 0x1));
    }' unless defined(&EHCI_HCC_64BIT);
    eval 'sub EHCI_HCSP_PORTROUTE () {0xc;}' unless defined(&EHCI_HCSP_PORTROUTE);
    eval 'sub EHCI_USBCMD () {0x;}' unless defined(&EHCI_USBCMD);
    eval 'sub EHCI_CMD_ITC_M () {0xff0000;}' unless defined(&EHCI_CMD_ITC_M);
    eval 'sub EHCI_CMD_ITC_1 () {0x10000;}' unless defined(&EHCI_CMD_ITC_1);
    eval 'sub EHCI_CMD_ITC_2 () {0x20000;}' unless defined(&EHCI_CMD_ITC_2);
    eval 'sub EHCI_CMD_ITC_4 () {0x40000;}' unless defined(&EHCI_CMD_ITC_4);
    eval 'sub EHCI_CMD_ITC_8 () {0x80000;}' unless defined(&EHCI_CMD_ITC_8);
    eval 'sub EHCI_CMD_ITC_16 () {0x100000;}' unless defined(&EHCI_CMD_ITC_16);
    eval 'sub EHCI_CMD_ITC_32 () {0x200000;}' unless defined(&EHCI_CMD_ITC_32);
    eval 'sub EHCI_CMD_ITC_64 () {0x400000;}' unless defined(&EHCI_CMD_ITC_64);
    eval 'sub EHCI_CMD_ASPME () {0x800;}' unless defined(&EHCI_CMD_ASPME);
    eval 'sub EHCI_CMD_ASPMC () {0x300;}' unless defined(&EHCI_CMD_ASPMC);
    eval 'sub EHCI_CMD_LHCR () {0x80;}' unless defined(&EHCI_CMD_LHCR);
    eval 'sub EHCI_CMD_IAAD () {0x40;}' unless defined(&EHCI_CMD_IAAD);
    eval 'sub EHCI_CMD_ASE () {0x20;}' unless defined(&EHCI_CMD_ASE);
    eval 'sub EHCI_CMD_PSE () {0x10;}' unless defined(&EHCI_CMD_PSE);
    eval 'sub EHCI_CMD_FLS_M () {0xc;}' unless defined(&EHCI_CMD_FLS_M);
    eval 'sub EHCI_CMD_FLS {
        local($x) = @_;
	    eval q(((($x) >> 2) & 3));
    }' unless defined(&EHCI_CMD_FLS);
    eval 'sub EHCI_CMD_HCRESET () {0x2;}' unless defined(&EHCI_CMD_HCRESET);
    eval 'sub EHCI_CMD_RS () {0x1;}' unless defined(&EHCI_CMD_RS);
    eval 'sub EHCI_USBSTS () {0x4;}' unless defined(&EHCI_USBSTS);
    eval 'sub EHCI_STS_ASS () {0x8000;}' unless defined(&EHCI_STS_ASS);
    eval 'sub EHCI_STS_PSS () {0x4000;}' unless defined(&EHCI_STS_PSS);
    eval 'sub EHCI_STS_REC () {0x2000;}' unless defined(&EHCI_STS_REC);
    eval 'sub EHCI_STS_HCH () {0x1000;}' unless defined(&EHCI_STS_HCH);
    eval 'sub EHCI_STS_IAA () {0x20;}' unless defined(&EHCI_STS_IAA);
    eval 'sub EHCI_STS_HSE () {0x10;}' unless defined(&EHCI_STS_HSE);
    eval 'sub EHCI_STS_FLR () {0x8;}' unless defined(&EHCI_STS_FLR);
    eval 'sub EHCI_STS_PCD () {0x4;}' unless defined(&EHCI_STS_PCD);
    eval 'sub EHCI_STS_ERRINT () {0x2;}' unless defined(&EHCI_STS_ERRINT);
    eval 'sub EHCI_STS_INT () {0x1;}' unless defined(&EHCI_STS_INT);
    eval 'sub EHCI_STS_INTRS {
        local($x) = @_;
	    eval q((($x) & 0x3f));
    }' unless defined(&EHCI_STS_INTRS);
    eval 'sub EHCI_NORMAL_INTRS () {( &EHCI_STS_IAA |  &EHCI_STS_HSE |  &EHCI_STS_PCD |  &EHCI_STS_ERRINT |  &EHCI_STS_INT);}' unless defined(&EHCI_NORMAL_INTRS);
    eval 'sub EHCI_USBINTR () {0x8;}' unless defined(&EHCI_USBINTR);
    eval 'sub EHCI_INTR_IAAE () {0x20;}' unless defined(&EHCI_INTR_IAAE);
    eval 'sub EHCI_INTR_HSEE () {0x10;}' unless defined(&EHCI_INTR_HSEE);
    eval 'sub EHCI_INTR_FLRE () {0x8;}' unless defined(&EHCI_INTR_FLRE);
    eval 'sub EHCI_INTR_PCIE () {0x4;}' unless defined(&EHCI_INTR_PCIE);
    eval 'sub EHCI_INTR_UEIE () {0x2;}' unless defined(&EHCI_INTR_UEIE);
    eval 'sub EHCI_INTR_UIE () {0x1;}' unless defined(&EHCI_INTR_UIE);
    eval 'sub EHCI_FRINDEX () {0xc;}' unless defined(&EHCI_FRINDEX);
    eval 'sub EHCI_CTRLDSSEGMENT () {0x10;}' unless defined(&EHCI_CTRLDSSEGMENT);
    eval 'sub EHCI_PERIODICLISTBASE () {0x14;}' unless defined(&EHCI_PERIODICLISTBASE);
    eval 'sub EHCI_ASYNCLISTADDR () {0x18;}' unless defined(&EHCI_ASYNCLISTADDR);
    eval 'sub EHCI_CONFIGFLAG () {0x40;}' unless defined(&EHCI_CONFIGFLAG);
    eval 'sub EHCI_CONF_CF () {0x1;}' unless defined(&EHCI_CONF_CF);
    eval 'sub EHCI_PORTSC {
        local($n) = @_;
	    eval q((0x40+4*($n)));
    }' unless defined(&EHCI_PORTSC);
    eval 'sub EHCI_PS_WKOC_E () {0x400000;}' unless defined(&EHCI_PS_WKOC_E);
    eval 'sub EHCI_PS_WKDSCNNT_E () {0x200000;}' unless defined(&EHCI_PS_WKDSCNNT_E);
    eval 'sub EHCI_PS_WKCNNT_E () {0x100000;}' unless defined(&EHCI_PS_WKCNNT_E);
    eval 'sub EHCI_PS_PTC () {0xf0000;}' unless defined(&EHCI_PS_PTC);
    eval 'sub EHCI_PS_PIC () {0xc000;}' unless defined(&EHCI_PS_PIC);
    eval 'sub EHCI_PS_PO () {0x2000;}' unless defined(&EHCI_PS_PO);
    eval 'sub EHCI_PS_PP () {0x1000;}' unless defined(&EHCI_PS_PP);
    eval 'sub EHCI_PS_LS () {0xc00;}' unless defined(&EHCI_PS_LS);
    eval 'sub EHCI_PS_IS_LOWSPEED {
        local($x) = @_;
	    eval q(((($x) &  &EHCI_PS_LS) == 0x400));
    }' unless defined(&EHCI_PS_IS_LOWSPEED);
    eval 'sub EHCI_PS_PR () {0x100;}' unless defined(&EHCI_PS_PR);
    eval 'sub EHCI_PS_SUSP () {0x80;}' unless defined(&EHCI_PS_SUSP);
    eval 'sub EHCI_PS_FPR () {0x40;}' unless defined(&EHCI_PS_FPR);
    eval 'sub EHCI_PS_OCC () {0x20;}' unless defined(&EHCI_PS_OCC);
    eval 'sub EHCI_PS_OCA () {0x10;}' unless defined(&EHCI_PS_OCA);
    eval 'sub EHCI_PS_PEC () {0x8;}' unless defined(&EHCI_PS_PEC);
    eval 'sub EHCI_PS_PE () {0x4;}' unless defined(&EHCI_PS_PE);
    eval 'sub EHCI_PS_CSC () {0x2;}' unless defined(&EHCI_PS_CSC);
    eval 'sub EHCI_PS_CS () {0x1;}' unless defined(&EHCI_PS_CS);
    eval 'sub EHCI_PS_CLEAR () {( &EHCI_PS_OCC| &EHCI_PS_PEC| &EHCI_PS_CSC);}' unless defined(&EHCI_PS_CLEAR);
    eval 'sub EHCI_PORT_RESET_COMPLETE () {2;}' unless defined(&EHCI_PORT_RESET_COMPLETE);
    eval 'sub EHCI_FLALIGN_ALIGN () {0x1000;}' unless defined(&EHCI_FLALIGN_ALIGN);
    eval 'sub EHCI_PAGE_SIZE () {0x1000;}' unless defined(&EHCI_PAGE_SIZE);
    eval 'sub EHCI_PAGE {
        local($x) = @_;
	    eval q((($x) &~ 0xfff));
    }' unless defined(&EHCI_PAGE);
    eval 'sub EHCI_PAGE_OFFSET {
        local($x) = @_;
	    eval q((($x) & 0xfff));
    }' unless defined(&EHCI_PAGE_OFFSET);
    eval 'sub EHCI_LINK_TERMINATE () {0x1;}' unless defined(&EHCI_LINK_TERMINATE);
    eval 'sub EHCI_LINK_TYPE {
        local($x) = @_;
	    eval q((($x) & 0x6));
    }' unless defined(&EHCI_LINK_TYPE);
    eval 'sub EHCI_LINK_ITD () {0x;}' unless defined(&EHCI_LINK_ITD);
    eval 'sub EHCI_LINK_QH () {0x2;}' unless defined(&EHCI_LINK_QH);
    eval 'sub EHCI_LINK_SITD () {0x4;}' unless defined(&EHCI_LINK_SITD);
    eval 'sub EHCI_LINK_FSTN () {0x6;}' unless defined(&EHCI_LINK_FSTN);
    eval 'sub EHCI_LINK_ADDR {
        local($x) = @_;
	    eval q((($x) &~ 0x1f));
    }' unless defined(&EHCI_LINK_ADDR);
    eval 'sub EHCI_BUFPTR_MASK () {0xfffff000;}' unless defined(&EHCI_BUFPTR_MASK);
    eval 'sub EHCI_ITD_NTRANS () {8;}' unless defined(&EHCI_ITD_NTRANS);
    eval 'sub EHCI_ITD_NBUFFERS () {7;}' unless defined(&EHCI_ITD_NBUFFERS);
    eval 'sub EHCI_ITD_GET_OFFSET {
        local($x) = @_;
	    eval q(((($x) >> 0) & 0xfff));
    }' unless defined(&EHCI_ITD_GET_OFFSET);
    eval 'sub EHCI_ITD_SET_OFFSET {
        local($x) = @_;
	    eval q(($x));
    }' unless defined(&EHCI_ITD_SET_OFFSET);
    eval 'sub EHCI_ITD_GET_PG {
        local($x) = @_;
	    eval q(((($x) >> 12) & 0x7));
    }' unless defined(&EHCI_ITD_GET_PG);
    eval 'sub EHCI_ITD_SET_PG {
        local($x) = @_;
	    eval q((($x) << 12));
    }' unless defined(&EHCI_ITD_SET_PG);
    eval 'sub EHCI_ITD_GET_IOC {
        local($x) = @_;
	    eval q(((($x) >> 15) & 0x1));
    }' unless defined(&EHCI_ITD_GET_IOC);
    eval 'sub EHCI_ITD_IOC () {0x8000;}' unless defined(&EHCI_ITD_IOC);
    eval 'sub EHCI_ITD_GET_XLEN {
        local($x) = @_;
	    eval q(((($x) >> 16) & 0xfff));
    }' unless defined(&EHCI_ITD_GET_XLEN);
    eval 'sub EHCI_ITD_SET_XLEN {
        local($x) = @_;
	    eval q((($x) << 12));
    }' unless defined(&EHCI_ITD_SET_XLEN);
    eval 'sub EHCI_ITD_GET_STATUS {
        local($x) = @_;
	    eval q(((($x) >> 28) & 0xf));
    }' unless defined(&EHCI_ITD_GET_STATUS);
    eval 'sub EHCI_ITD_SET_STATUS {
        local($x) = @_;
	    eval q((($x) << 28));
    }' unless defined(&EHCI_ITD_SET_STATUS);
    eval 'sub EHCI_ITD_ACTIVE () {0x8;}' unless defined(&EHCI_ITD_ACTIVE);
    eval 'sub EHCI_ITD_BUFERR () {0x4;}' unless defined(&EHCI_ITD_BUFERR);
    eval 'sub EHCI_ITD_BABBLE () {0x2;}' unless defined(&EHCI_ITD_BABBLE);
    eval 'sub EHCI_ITD_XACTERR () {0x1;}' unless defined(&EHCI_ITD_XACTERR);
    eval 'sub EHCI_ITD_GET_ADDR {
        local($x) = @_;
	    eval q(((($x) >> 0) & 0x7f));
    }' unless defined(&EHCI_ITD_GET_ADDR);
    eval 'sub EHCI_ITD_SET_ADDR {
        local($x) = @_;
	    eval q(($x));
    }' unless defined(&EHCI_ITD_SET_ADDR);
    eval 'sub EHCI_ITD_GET_ENDPT {
        local($x) = @_;
	    eval q(((($x) >> 8) & 0xf));
    }' unless defined(&EHCI_ITD_GET_ENDPT);
    eval 'sub EHCI_ITD_SET_ENDPT {
        local($x) = @_;
	    eval q((($x) << 8));
    }' unless defined(&EHCI_ITD_SET_ENDPT);
    eval 'sub EHCI_ITD_GET_MPS {
        local($x) = @_;
	    eval q(((($x) >> 0) & 0x7ff));
    }' unless defined(&EHCI_ITD_GET_MPS);
    eval 'sub EHCI_ITD_SET_MPS {
        local($x) = @_;
	    eval q(($x));
    }' unless defined(&EHCI_ITD_SET_MPS);
    eval 'sub EHCI_ITD_DIRECTION () {0x800;}' unless defined(&EHCI_ITD_DIRECTION);
    eval 'sub EHCI_ITD_GET_MULTI {
        local($x) = @_;
	    eval q(((($x) >> 0) & 0x3));
    }' unless defined(&EHCI_ITD_GET_MULTI);
    eval 'sub EHCI_ITD_SET_MULTI {
        local($x) = @_;
	    eval q(($x));
    }' unless defined(&EHCI_ITD_SET_MULTI);
    eval 'sub EHCI_ITD_ALIGN () {32;}' unless defined(&EHCI_ITD_ALIGN);
    eval 'sub EHCI_SITD_NBUFFERS () {2;}' unless defined(&EHCI_SITD_NBUFFERS);
    eval 'sub EHCI_SITD_GET_ADDR {
        local($x) = @_;
	    eval q(((($x) >> 0) & 0x7f));
    }' unless defined(&EHCI_SITD_GET_ADDR);
    eval 'sub EHCI_SITD_SET_ADDR {
        local($x) = @_;
	    eval q(($x));
    }' unless defined(&EHCI_SITD_SET_ADDR);
    eval 'sub EHCI_SITD_GET_ENDPT {
        local($x) = @_;
	    eval q(((($x) >> 8) & 0xf));
    }' unless defined(&EHCI_SITD_GET_ENDPT);
    eval 'sub EHCI_SITD_SET_ENDPT {
        local($x) = @_;
	    eval q((($x) << 8));
    }' unless defined(&EHCI_SITD_SET_ENDPT);
    eval 'sub EHCI_SITD_GET_HUBA {
        local($x) = @_;
	    eval q(((($x) >> 16) & 0x7f));
    }' unless defined(&EHCI_SITD_GET_HUBA);
    eval 'sub EHCI_SITD_SET_HUBA {
        local($x) = @_;
	    eval q((($x) << 16));
    }' unless defined(&EHCI_SITD_SET_HUBA);
    eval 'sub EHCI_SITD_GET_PORT {
        local($x) = @_;
	    eval q(((($x) >> 23) & 0x7f));
    }' unless defined(&EHCI_SITD_GET_PORT);
    eval 'sub EHCI_SITD_SET_PORT {
        local($x) = @_;
	    eval q((($x) << 23));
    }' unless defined(&EHCI_SITD_SET_PORT);
    eval 'sub EHCI_QH_GET_SMASK {
        local($x) = @_;
	    eval q(((($x) >> 0) & 0xff));
    }' unless defined(&EHCI_QH_GET_SMASK);
    eval 'sub EHCI_QH_SET_SMASK {
        local($x) = @_;
	    eval q((($x) << 0));
    }' unless defined(&EHCI_QH_SET_SMASK);
    eval 'sub EHCI_QH_GET_CMASK {
        local($x) = @_;
	    eval q(((($x) >> 8) & 0xff));
    }' unless defined(&EHCI_QH_GET_CMASK);
    eval 'sub EHCI_QH_SET_CMASK {
        local($x) = @_;
	    eval q((($x) << 8));
    }' unless defined(&EHCI_QH_SET_CMASK);
    eval 'sub EHCI_SITD_GET_STATUS {
        local($x) = @_;
	    eval q(((($x) >> 0) & 0xff));
    }' unless defined(&EHCI_SITD_GET_STATUS);
    eval 'sub EHCI_SITD_ACTIVE () {0x80;}' unless defined(&EHCI_SITD_ACTIVE);
    eval 'sub EHCI_SITD_ERR () {0x40;}' unless defined(&EHCI_SITD_ERR);
    eval 'sub EHCI_SITD_BUFERR () {0x20;}' unless defined(&EHCI_SITD_BUFERR);
    eval 'sub EHCI_SITD_BABBLE () {0x10;}' unless defined(&EHCI_SITD_BABBLE);
    eval 'sub EHCI_SITD_XACTERR () {0x8;}' unless defined(&EHCI_SITD_XACTERR);
    eval 'sub EHCI_SITD_MISSEDMICRO () {0x4;}' unless defined(&EHCI_SITD_MISSEDMICRO);
    eval 'sub EHCI_SITD_SPLITXSTATE () {0x2;}' unless defined(&EHCI_SITD_SPLITXSTATE);
    eval 'sub EHCI_SITD_GET_CPROG {
        local($x) = @_;
	    eval q(((($x) >> 8) & 0xff));
    }' unless defined(&EHCI_SITD_GET_CPROG);
    eval 'sub EHCI_SITD_SET_CPROG {
        local($x) = @_;
	    eval q(((($x) >> 8) & 0xff));
    }' unless defined(&EHCI_SITD_SET_CPROG);
    eval 'sub EHCI_SITD_GET_BYTES {
        local($x) = @_;
	    eval q(((($x) >> 16) & 0x7ff));
    }' unless defined(&EHCI_SITD_GET_BYTES);
    eval 'sub EHCI_SITD_SET_BYTES {
        local($x) = @_;
	    eval q((($x) << 16));
    }' unless defined(&EHCI_SITD_SET_BYTES);
    eval 'sub EHCI_SITD_GET_PG {
        local($x) = @_;
	    eval q(((($x) >> 30) & 0x1));
    }' unless defined(&EHCI_SITD_GET_PG);
    eval 'sub EHCI_SITD_SET_PG {
        local($x) = @_;
	    eval q((($x) << 30));
    }' unless defined(&EHCI_SITD_SET_PG);
    eval 'sub EHCI_SITD_IOC () {0x80000000;}' unless defined(&EHCI_SITD_IOC);
    eval 'sub EHCI_SITD_GET_OFFSET {
        local($x) = @_;
	    eval q(((($x) >> 0) & 0xfff));
    }' unless defined(&EHCI_SITD_GET_OFFSET);
    eval 'sub EHCI_SITD_GET_TCOUNT {
        local($x) = @_;
	    eval q(((($x) >> 0) & 0x3));
    }' unless defined(&EHCI_SITD_GET_TCOUNT);
    eval 'sub EHCI_SITD_GET_TP {
        local($x) = @_;
	    eval q(((($x) >> 3) & 0x3));
    }' unless defined(&EHCI_SITD_GET_TP);
    eval 'sub EHCI_SITD_SET_TP {
        local($x) = @_;
	    eval q((($x) << 3));
    }' unless defined(&EHCI_SITD_SET_TP);
    eval 'sub EHCI_SITD_TP_ALL () {0x;}' unless defined(&EHCI_SITD_TP_ALL);
    eval 'sub EHCI_SITD_TP_BEGIN () {0x1;}' unless defined(&EHCI_SITD_TP_BEGIN);
    eval 'sub EHCI_SITD_TP_MIDDLE () {0x2;}' unless defined(&EHCI_SITD_TP_MIDDLE);
    eval 'sub EHCI_SITD_TP_END () {0x3;}' unless defined(&EHCI_SITD_TP_END);
    eval 'sub EHCI_SITD_ALIGN () {32;}' unless defined(&EHCI_SITD_ALIGN);
    eval 'sub EHCI_QTD_NBUFFERS () {5;}' unless defined(&EHCI_QTD_NBUFFERS);
    eval 'sub EHCI_QTD_GET_STATUS {
        local($x) = @_;
	    eval q(((($x) >> 0) & 0xff));
    }' unless defined(&EHCI_QTD_GET_STATUS);
    eval 'sub EHCI_QTD_SET_STATUS {
        local($x) = @_;
	    eval q((($x) << 0));
    }' unless defined(&EHCI_QTD_SET_STATUS);
    eval 'sub EHCI_QTD_ACTIVE () {0x80;}' unless defined(&EHCI_QTD_ACTIVE);
    eval 'sub EHCI_QTD_HALTED () {0x40;}' unless defined(&EHCI_QTD_HALTED);
    eval 'sub EHCI_QTD_BUFERR () {0x20;}' unless defined(&EHCI_QTD_BUFERR);
    eval 'sub EHCI_QTD_BABBLE () {0x10;}' unless defined(&EHCI_QTD_BABBLE);
    eval 'sub EHCI_QTD_XACTERR () {0x8;}' unless defined(&EHCI_QTD_XACTERR);
    eval 'sub EHCI_QTD_MISSEDMICRO () {0x4;}' unless defined(&EHCI_QTD_MISSEDMICRO);
    eval 'sub EHCI_QTD_SPLITXSTATE () {0x2;}' unless defined(&EHCI_QTD_SPLITXSTATE);
    eval 'sub EHCI_QTD_PINGSTATE () {0x1;}' unless defined(&EHCI_QTD_PINGSTATE);
    eval 'sub EHCI_QTD_STATERRS () {0x7c;}' unless defined(&EHCI_QTD_STATERRS);
    eval 'sub EHCI_QTD_GET_PID {
        local($x) = @_;
	    eval q(((($x) >> 8) & 0x3));
    }' unless defined(&EHCI_QTD_GET_PID);
    eval 'sub EHCI_QTD_SET_PID {
        local($x) = @_;
	    eval q((($x) << 8));
    }' unless defined(&EHCI_QTD_SET_PID);
    eval 'sub EHCI_QTD_PID_OUT () {0x;}' unless defined(&EHCI_QTD_PID_OUT);
    eval 'sub EHCI_QTD_PID_IN () {0x1;}' unless defined(&EHCI_QTD_PID_IN);
    eval 'sub EHCI_QTD_PID_SETUP () {0x2;}' unless defined(&EHCI_QTD_PID_SETUP);
    eval 'sub EHCI_QTD_GET_CERR {
        local($x) = @_;
	    eval q(((($x) >> 10) & 0x3));
    }' unless defined(&EHCI_QTD_GET_CERR);
    eval 'sub EHCI_QTD_SET_CERR {
        local($x) = @_;
	    eval q((($x) << 10));
    }' unless defined(&EHCI_QTD_SET_CERR);
    eval 'sub EHCI_QTD_GET_C_PAGE {
        local($x) = @_;
	    eval q(((($x) >> 12) & 0x7));
    }' unless defined(&EHCI_QTD_GET_C_PAGE);
    eval 'sub EHCI_QTD_SET_C_PAGE {
        local($x) = @_;
	    eval q((($x) << 12));
    }' unless defined(&EHCI_QTD_SET_C_PAGE);
    eval 'sub EHCI_QTD_GET_IOC {
        local($x) = @_;
	    eval q(((($x) >> 15) & 0x1));
    }' unless defined(&EHCI_QTD_GET_IOC);
    eval 'sub EHCI_QTD_IOC () {0x8000;}' unless defined(&EHCI_QTD_IOC);
    eval 'sub EHCI_QTD_GET_BYTES {
        local($x) = @_;
	    eval q(((($x) >> 16) & 0x7fff));
    }' unless defined(&EHCI_QTD_GET_BYTES);
    eval 'sub EHCI_QTD_SET_BYTES {
        local($x) = @_;
	    eval q((($x) << 16));
    }' unless defined(&EHCI_QTD_SET_BYTES);
    eval 'sub EHCI_QTD_GET_TOGGLE {
        local($x) = @_;
	    eval q(((($x) >> 31) & 0x1));
    }' unless defined(&EHCI_QTD_GET_TOGGLE);
    eval 'sub EHCI_QTD_SET_TOGGLE {
        local($x) = @_;
	    eval q((($x) << 31));
    }' unless defined(&EHCI_QTD_SET_TOGGLE);
    eval 'sub EHCI_QTD_TOGGLE_MASK () {0x80000000;}' unless defined(&EHCI_QTD_TOGGLE_MASK);
    eval 'sub EHCI_QTD_ALIGN () {32;}' unless defined(&EHCI_QTD_ALIGN);
    eval 'sub EHCI_QH_GET_ADDR {
        local($x) = @_;
	    eval q(((($x) >> 0) & 0x7f));
    }' unless defined(&EHCI_QH_GET_ADDR);
    eval 'sub EHCI_QH_SET_ADDR {
        local($x) = @_;
	    eval q(($x));
    }' unless defined(&EHCI_QH_SET_ADDR);
    eval 'sub EHCI_QH_ADDRMASK () {0x7f;}' unless defined(&EHCI_QH_ADDRMASK);
    eval 'sub EHCI_QH_GET_INACT {
        local($x) = @_;
	    eval q(((($x) >> 7) & 0x1));
    }' unless defined(&EHCI_QH_GET_INACT);
    eval 'sub EHCI_QH_INACT () {0x80;}' unless defined(&EHCI_QH_INACT);
    eval 'sub EHCI_QH_GET_ENDPT {
        local($x) = @_;
	    eval q(((($x) >> 8) & 0xf));
    }' unless defined(&EHCI_QH_GET_ENDPT);
    eval 'sub EHCI_QH_SET_ENDPT {
        local($x) = @_;
	    eval q((($x) << 8));
    }' unless defined(&EHCI_QH_SET_ENDPT);
    eval 'sub EHCI_QH_GET_EPS {
        local($x) = @_;
	    eval q(((($x) >> 12) & 0x3));
    }' unless defined(&EHCI_QH_GET_EPS);
    eval 'sub EHCI_QH_SET_EPS {
        local($x) = @_;
	    eval q((($x) << 12));
    }' unless defined(&EHCI_QH_SET_EPS);
    eval 'sub EHCI_QH_SPEED_FULL () {0x;}' unless defined(&EHCI_QH_SPEED_FULL);
    eval 'sub EHCI_QH_SPEED_LOW () {0x1;}' unless defined(&EHCI_QH_SPEED_LOW);
    eval 'sub EHCI_QH_SPEED_HIGH () {0x2;}' unless defined(&EHCI_QH_SPEED_HIGH);
    eval 'sub EHCI_QH_GET_DTC {
        local($x) = @_;
	    eval q(((($x) >> 14) & 0x1));
    }' unless defined(&EHCI_QH_GET_DTC);
    eval 'sub EHCI_QH_DTC () {0x4000;}' unless defined(&EHCI_QH_DTC);
    eval 'sub EHCI_QH_GET_HRECL {
        local($x) = @_;
	    eval q(((($x) >> 15) & 0x1));
    }' unless defined(&EHCI_QH_GET_HRECL);
    eval 'sub EHCI_QH_HRECL () {0x8000;}' unless defined(&EHCI_QH_HRECL);
    eval 'sub EHCI_QH_GET_MPL {
        local($x) = @_;
	    eval q(((($x) >> 16) & 0x7ff));
    }' unless defined(&EHCI_QH_GET_MPL);
    eval 'sub EHCI_QH_SET_MPL {
        local($x) = @_;
	    eval q((($x) << 16));
    }' unless defined(&EHCI_QH_SET_MPL);
    eval 'sub EHCI_QH_MPLMASK () {0x7ff0000;}' unless defined(&EHCI_QH_MPLMASK);
    eval 'sub EHCI_QH_GET_CTL {
        local($x) = @_;
	    eval q(((($x) >> 27) & 0x1));
    }' unless defined(&EHCI_QH_GET_CTL);
    eval 'sub EHCI_QH_CTL () {0x8000000;}' unless defined(&EHCI_QH_CTL);
    eval 'sub EHCI_QH_GET_NRL {
        local($x) = @_;
	    eval q(((($x) >> 28) & 0xf));
    }' unless defined(&EHCI_QH_GET_NRL);
    eval 'sub EHCI_QH_SET_NRL {
        local($x) = @_;
	    eval q((($x) << 28));
    }' unless defined(&EHCI_QH_SET_NRL);
    eval 'sub EHCI_QH_GET_SMASK {
        local($x) = @_;
	    eval q(((($x) >> 0) & 0xff));
    }' unless defined(&EHCI_QH_GET_SMASK);
    eval 'sub EHCI_QH_SET_SMASK {
        local($x) = @_;
	    eval q((($x) << 0));
    }' unless defined(&EHCI_QH_SET_SMASK);
    eval 'sub EHCI_QH_GET_CMASK {
        local($x) = @_;
	    eval q(((($x) >> 8) & 0xff));
    }' unless defined(&EHCI_QH_GET_CMASK);
    eval 'sub EHCI_QH_SET_CMASK {
        local($x) = @_;
	    eval q((($x) << 8));
    }' unless defined(&EHCI_QH_SET_CMASK);
    eval 'sub EHCI_QH_GET_HUBA {
        local($x) = @_;
	    eval q(((($x) >> 16) & 0x7f));
    }' unless defined(&EHCI_QH_GET_HUBA);
    eval 'sub EHCI_QH_SET_HUBA {
        local($x) = @_;
	    eval q((($x) << 16));
    }' unless defined(&EHCI_QH_SET_HUBA);
    eval 'sub EHCI_QH_GET_PORT {
        local($x) = @_;
	    eval q(((($x) >> 23) & 0x7f));
    }' unless defined(&EHCI_QH_GET_PORT);
    eval 'sub EHCI_QH_SET_PORT {
        local($x) = @_;
	    eval q((($x) << 23));
    }' unless defined(&EHCI_QH_SET_PORT);
    eval 'sub EHCI_QH_GET_MULT {
        local($x) = @_;
	    eval q(((($x) >> 30) & 0x3));
    }' unless defined(&EHCI_QH_GET_MULT);
    eval 'sub EHCI_QH_SET_MULT {
        local($x) = @_;
	    eval q((($x) << 30));
    }' unless defined(&EHCI_QH_SET_MULT);
    eval 'sub EHCI_QH_ALIGN () {32;}' unless defined(&EHCI_QH_ALIGN);
    eval 'sub EHCI_FSTN_ALIGN () {32;}' unless defined(&EHCI_FSTN_ALIGN);
}
1;
