require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_DEV_PCI_PLX9060REG_H_)) {
    eval 'sub _DEV_PCI_PLX9060REG_H_ () {1;}' unless defined(&_DEV_PCI_PLX9060REG_H_);
    eval 'sub PLX_PCI_RUNTIME_MEMADDR () {0x10;}' unless defined(&PLX_PCI_RUNTIME_MEMADDR);
    eval 'sub PLX_PCI_RUNTIME_IOADDR () {0x14;}' unless defined(&PLX_PCI_RUNTIME_IOADDR);
    eval 'sub PLX_PCI_LOCAL_ADDR0 () {0x18;}' unless defined(&PLX_PCI_LOCAL_ADDR0);
    eval 'sub PLX_LAS0RR () {0x;}' unless defined(&PLX_LAS0RR);
    eval 'sub LASRR_IO () {0x1;}' unless defined(&LASRR_IO);
    eval 'sub LASRR_MEM_1M () {0x2;}' unless defined(&LASRR_MEM_1M);
    eval 'sub LASRR_MEM_64BIT () {0x4;}' unless defined(&LASRR_MEM_64BIT);
    eval 'sub LASRR_MEM_PREFETCH () {0x8;}' unless defined(&LASRR_MEM_PREFETCH);
    eval 'sub LASRR_MEM_MASK () {0xfffffff0;}' unless defined(&LASRR_MEM_MASK);
    eval 'sub LASRR_IO_MASK () {0xfffffffc;}' unless defined(&LASRR_IO_MASK);
    eval 'sub PLX_LAS0BA () {0x4;}' unless defined(&PLX_LAS0BA);
    eval 'sub LASBA_ENABLE () {0x1;}' unless defined(&LASBA_ENABLE);
    eval 'sub LASBA_MEM_MASK () {0xfffffff0;}' unless defined(&LASBA_MEM_MASK);
    eval 'sub LASBA_IO_MASK () {0xfffffffc;}' unless defined(&LASBA_IO_MASK);
    eval 'sub PLX_LAR () {0x8;}' unless defined(&PLX_LAR);
    eval 'sub LAR_LATTMR () {0xff;}' unless defined(&LAR_LATTMR);
    eval 'sub LAR_PAUSETMR () {0xff00;}' unless defined(&LAR_PAUSETMR);
    eval 'sub LAR_LATTMR_EN () {0x10000;}' unless defined(&LAR_LATTMR_EN);
    eval 'sub LAR_BREQ_EN () {0x40000;}' unless defined(&LAR_BREQ_EN);
    eval 'sub LAR_DSGIVEUP () {0x200000;}' unless defined(&LAR_DSGIVEUP);
    eval 'sub LAR_DSLOCK_EN () {0x400000;}' unless defined(&LAR_DSLOCK_EN);
    eval 'sub LAR_PCI21_MODE () {0x1000000;}' unless defined(&LAR_PCI21_MODE);
    eval 'sub PLX_ENDIAN () {0xc;}' unless defined(&PLX_ENDIAN);
    eval 'sub ENDIAN_CRBE () {0x1;}' unless defined(&ENDIAN_CRBE);
    eval 'sub ENDIAN_DMBE () {0x2;}' unless defined(&ENDIAN_DMBE);
    eval 'sub ENDIAN_DSAS0BE () {0x4;}' unless defined(&ENDIAN_DSAS0BE);
    eval 'sub ENDIAN_DSAERBE () {0x8;}' unless defined(&ENDIAN_DSAERBE);
    eval 'sub ENDIAN_BEBL () {0x10;}' unless defined(&ENDIAN_BEBL);
    eval 'sub PLX_EROMRR () {0x10;}' unless defined(&PLX_EROMRR);
    eval 'sub EROMRR_MASK () {0xffffffc0;}' unless defined(&EROMRR_MASK);
    eval 'sub PLX_EROMBA () {0x14;}' unless defined(&PLX_EROMBA);
    eval 'sub EROMBA_BREQ_DC () {0xf;}' unless defined(&EROMBA_BREQ_DC);
    eval 'sub EROMBA_BREQ_EN () {0x10;}' unless defined(&EROMBA_BREQ_EN);
    eval 'sub EROMBA_MASK () {0xffffffc0;}' unless defined(&EROMBA_MASK);
    eval 'sub PLX_LBRD () {0x18;}' unless defined(&PLX_LBRD);
    eval 'sub PLX_DMRR () {0x1c;}' unless defined(&PLX_DMRR);
    eval 'sub PLX_DMLBAM () {0x20;}' unless defined(&PLX_DMLBAM);
    eval 'sub PLX_DMLBAI () {0x24;}' unless defined(&PLX_DMLBAI);
    eval 'sub PLX_DMBPAM () {0x28;}' unless defined(&PLX_DMBPAM);
    eval 'sub PLX_DMPBAI () {0x2c;}' unless defined(&PLX_DMPBAI);
    eval 'sub PLX_MAILBOX0 () {0x40;}' unless defined(&PLX_MAILBOX0);
    eval 'sub PLX_MAILBOX1 () {0x44;}' unless defined(&PLX_MAILBOX1);
    eval 'sub PLX_MAILBOX2 () {0x48;}' unless defined(&PLX_MAILBOX2);
    eval 'sub PLX_MAILBOX3 () {0x4c;}' unless defined(&PLX_MAILBOX3);
    eval 'sub PLX_MAILBOX4 () {0x50;}' unless defined(&PLX_MAILBOX4);
    eval 'sub PLX_MAILBOX5 () {0x54;}' unless defined(&PLX_MAILBOX5);
    eval 'sub PLX_MAILBOX6 () {0x58;}' unless defined(&PLX_MAILBOX6);
    eval 'sub PLX_MAILBOX7 () {0x5c;}' unless defined(&PLX_MAILBOX7);
    eval 'sub PLX_PCI_LOCAL_DOORBELL () {0x60;}' unless defined(&PLX_PCI_LOCAL_DOORBELL);
    eval 'sub PLX_LOCAL_PCI_DOORBELL () {0x64;}' unless defined(&PLX_LOCAL_PCI_DOORBELL);
    eval 'sub PLX_INTCSR () {0x68;}' unless defined(&PLX_INTCSR);
    eval 'sub INTCSR_LSERR_TAMA () {0x1;}' unless defined(&INTCSR_LSERR_TAMA);
    eval 'sub INTCSR_LSERR_PA () {0x2;}' unless defined(&INTCSR_LSERR_PA);
    eval 'sub INTCSR_SERR () {0x4;}' unless defined(&INTCSR_SERR);
    eval 'sub INTCSR_PCI_EN () {0x100;}' unless defined(&INTCSR_PCI_EN);
    eval 'sub INTCSR_PCIDB_EN () {0x200;}' unless defined(&INTCSR_PCIDB_EN);
    eval 'sub INTCSR_PCIAB_EN () {0x400;}' unless defined(&INTCSR_PCIAB_EN);
    eval 'sub INTCSR_PCILOC_EN () {0x800;}' unless defined(&INTCSR_PCILOC_EN);
    eval 'sub INTCSR_RETRYAB_EN () {0x1000;}' unless defined(&INTCSR_RETRYAB_EN);
    eval 'sub INTCSR_PCIDB_INT () {0x2000;}' unless defined(&INTCSR_PCIDB_INT);
    eval 'sub INTCSR_PCIAB_INT () {0x4000;}' unless defined(&INTCSR_PCIAB_INT);
    eval 'sub INTCSR_PCILOC_INT () {0x8000;}' unless defined(&INTCSR_PCILOC_INT);
    eval 'sub INTCSR_LOCOE_EN () {0x10000;}' unless defined(&INTCSR_LOCOE_EN);
    eval 'sub INTCSR_LOCDB_EN () {0x20000;}' unless defined(&INTCSR_LOCDB_EN);
    eval 'sub INTCSR_LOCDB_INT () {0x100000;}' unless defined(&INTCSR_LOCDB_INT);
    eval 'sub INTCSR_BIST_INT () {0x800000;}' unless defined(&INTCSR_BIST_INT);
    eval 'sub INTCSR_DMAB_INT () {0x1000000;}' unless defined(&INTCSR_DMAB_INT);
    eval 'sub INTCSR_RETRYAB_INT () {0x8000000;}' unless defined(&INTCSR_RETRYAB_INT);
    eval 'sub PLX_CONTROL () {0x6c;}' unless defined(&PLX_CONTROL);
    eval 'sub CONTROL_PCIMRC () {0xf00;}' unless defined(&CONTROL_PCIMRC);
    eval 'sub CONTROL_PCIMRC_SHIFT () {8;}' unless defined(&CONTROL_PCIMRC_SHIFT);
    eval 'sub CONTROL_PCIMWC () {0xf000;}' unless defined(&CONTROL_PCIMWC);
    eval 'sub CONTROL_PCIMWC_SHIFT () {12;}' unless defined(&CONTROL_PCIMWC_SHIFT);
    eval 'sub CONTROL_GPO () {0x10000;}' unless defined(&CONTROL_GPO);
    eval 'sub CONTROL_GPI () {0x20000;}' unless defined(&CONTROL_GPI);
    eval 'sub CONTROL_EESK () {0x1000000;}' unless defined(&CONTROL_EESK);
    eval 'sub CONTROL_EECS () {0x2000000;}' unless defined(&CONTROL_EECS);
    eval 'sub CONTROL_EEDO () {0x4000000;}' unless defined(&CONTROL_EEDO);
    eval 'sub CONTROL_EEDI () {0x8000000;}' unless defined(&CONTROL_EEDI);
    eval 'sub CONTROL_EEPRESENT () {0x10000000;}' unless defined(&CONTROL_EEPRESENT);
    eval 'sub CONTROL_RELOADCFG () {0x20000000;}' unless defined(&CONTROL_RELOADCFG);
    eval 'sub CONTROL_SWR () {0x40000000;}' unless defined(&CONTROL_SWR);
    eval 'sub CONTROL_LOCALINIT () {0x80000000;}' unless defined(&CONTROL_LOCALINIT);
    eval 'sub PLX_EEPROM_OPC_READ {
        local($x) = @_;
	    eval q((0x80 | (($x) & 0x3f)));
    }' unless defined(&PLX_EEPROM_OPC_READ);
    eval 'sub PLX_EEPROM_OPC_WRITE {
        local($x) = @_;
	    eval q((0x40 | (($x) & 0x3f)));
    }' unless defined(&PLX_EEPROM_OPC_WRITE);
    eval 'sub PLX_EEPROM_OPC_WREN () {0x30;}' unless defined(&PLX_EEPROM_OPC_WREN);
    eval 'sub PLX_EEPROM_OPC_WRPR () {0x;}' unless defined(&PLX_EEPROM_OPC_WRPR);
    eval 'sub PLX_EEPROM_COMMAND {
        local($y) = @_;
	    eval q(((($y) & 0xff) | 0x100));
    }' unless defined(&PLX_EEPROM_COMMAND);
    eval 'sub PLX_IDREG () {0x70;}' unless defined(&PLX_IDREG);
}
1;
