require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_EM_OPENBSD_OS_H_)) {
    eval 'sub _EM_OPENBSD_OS_H_ () {1;}' unless defined(&_EM_OPENBSD_OS_H_);
    eval 'sub ASSERT {
        local($x) = @_;
	    eval q( &if(!($x))  &panic(\\"EM: x\\"));
    }' unless defined(&ASSERT);
    eval 'sub usec_delay {
        local($x) = @_;
	    eval q( &DELAY($x));
    }' unless defined(&usec_delay);
    eval 'sub msec_delay {
        local($x) = @_;
	    eval q( &DELAY(1000*($x)));
    }' unless defined(&msec_delay);
    eval 'sub msec_delay_irq {
        local($x) = @_;
	    eval q( &DELAY(1000*($x)));
    }' unless defined(&msec_delay_irq);
    eval 'sub MSGOUT {
        local($S, $A, $B) = @_;
	    eval q( &printf($S \\"\\\\n\\", $A, $B));
    }' unless defined(&MSGOUT);
    eval 'sub DEBUGFUNC {
        local($F) = @_;
	    eval q( &DEBUGOUT($F););
    }' unless defined(&DEBUGFUNC);
    if((defined(&DBG) ? &DBG : 0)) {
	eval 'sub DEBUGOUT {
	    local($S) = @_;
    	    eval q( &printf($S \\"\\\\n\\"));
	}' unless defined(&DEBUGOUT);
	eval 'sub DEBUGOUT1 {
	    local($S,$A) = @_;
    	    eval q( &printf($S \\"\\\\n\\",$A));
	}' unless defined(&DEBUGOUT1);
	eval 'sub DEBUGOUT2 {
	    local($S,$A,$B) = @_;
    	    eval q( &printf($S \\"\\\\n\\",$A,$B));
	}' unless defined(&DEBUGOUT2);
	eval 'sub DEBUGOUT3 {
	    local($S,$A,$B,$C) = @_;
    	    eval q( &printf($S \\"\\\\n\\",$A,$B,$C));
	}' unless defined(&DEBUGOUT3);
	eval 'sub DEBUGOUT7 {
	    local($S,$A,$B,$C,$D,$E,$F,$G) = @_;
    	    eval q( &printf($S \\"\\\\n\\",$A,$B,$C,$D,$E,$F,$G));
	}' unless defined(&DEBUGOUT7);
    } else {
	eval 'sub DEBUGOUT {
	    local($S) = @_;
    	    eval q();
	}' unless defined(&DEBUGOUT);
	eval 'sub DEBUGOUT1 {
	    local($S,$A) = @_;
    	    eval q();
	}' unless defined(&DEBUGOUT1);
	eval 'sub DEBUGOUT2 {
	    local($S,$A,$B) = @_;
    	    eval q();
	}' unless defined(&DEBUGOUT2);
	eval 'sub DEBUGOUT3 {
	    local($S,$A,$B,$C) = @_;
    	    eval q();
	}' unless defined(&DEBUGOUT3);
	eval 'sub DEBUGOUT7 {
	    local($S,$A,$B,$C,$D,$E,$F,$G) = @_;
    	    eval q();
	}' unless defined(&DEBUGOUT7);
    }
    eval 'sub FALSE () {0;}' unless defined(&FALSE);
    eval 'sub TRUE () {1;}' unless defined(&TRUE);
    eval 'sub CMD_MEM_WRT_INVALIDATE () {0x10;}' unless defined(&CMD_MEM_WRT_INVALIDATE);
    eval 'sub PCI_COMMAND_REGISTER () { &PCI_COMMAND_STATUS_REG;}' unless defined(&PCI_COMMAND_REGISTER);
    eval 'sub E1000_WRITE_FLUSH {
        local($hw) = @_;
	    eval q( &E1000_READ_REG($hw,  &STATUS));
    }' unless defined(&E1000_WRITE_FLUSH);
    eval 'sub E1000_READ_OFFSET {
        local($hw, $offset) = @_;
	    eval q( &bus_space_read_4( (($hw)-> &back)-> &mem_bus_space_tag, (($hw)-> &back)-> &mem_bus_space_handle, $offset));
    }' unless defined(&E1000_READ_OFFSET);
    eval 'sub E1000_WRITE_OFFSET {
        local($hw, $offset, $value) = @_;
	    eval q( &bus_space_write_4( (($hw)-> &back)-> &mem_bus_space_tag, (($hw)-> &back)-> &mem_bus_space_handle, $offset, $value));
    }' unless defined(&E1000_WRITE_OFFSET);
    eval 'sub E1000_REG_OFFSET {
        local($hw, $reg) = @_;
	    eval q((($hw)-> &mac_type >=  &em_82543 ?  &E1000_$reg :  &E1000_82542_$reg));
    }' unless defined(&E1000_REG_OFFSET);
    eval 'sub E1000_READ_REG {
        local($hw, $reg) = @_;
	    eval q( &E1000_READ_OFFSET($hw,  &E1000_REG_OFFSET($hw, $reg)));
    }' unless defined(&E1000_READ_REG);
    eval 'sub E1000_WRITE_REG {
        local($hw, $reg, $value) = @_;
	    eval q( &E1000_WRITE_OFFSET($hw,  &E1000_REG_OFFSET($hw, $reg), $value));
    }' unless defined(&E1000_WRITE_REG);
    eval 'sub E1000_READ_REG_ARRAY {
        local($hw, $reg, $index) = @_;
	    eval q( &E1000_READ_OFFSET($hw,  &E1000_REG_OFFSET($hw, $reg) + (($index) << 2)));
    }' unless defined(&E1000_READ_REG_ARRAY);
    eval 'sub E1000_READ_REG_ARRAY_DWORD () { &E1000_READ_REG_ARRAY;}' unless defined(&E1000_READ_REG_ARRAY_DWORD);
    eval 'sub E1000_WRITE_REG_ARRAY {
        local($hw, $reg, $index, $value) = @_;
	    eval q( &E1000_WRITE_OFFSET($hw,  &E1000_REG_OFFSET($hw, $reg) + (($index) << 2), $value));
    }' unless defined(&E1000_WRITE_REG_ARRAY);
    eval 'sub E1000_WRITE_REG_ARRAY_BYTE {
        local($hw, $reg, $index, $value) = @_;
	    eval q( &bus_space_write_1( (($hw)-> &back)-> &mem_bus_space_tag, (($hw)-> &back)-> &mem_bus_space_handle,  &E1000_REG_OFFSET($hw, $reg) + ($index), $value));
    }' unless defined(&E1000_WRITE_REG_ARRAY_BYTE);
    eval 'sub E1000_WRITE_REG_ARRAY_WORD {
        local($hw, $reg, $index, $value) = @_;
	    eval q( &bus_space_write_2( (($hw)-> &back)-> &mem_bus_space_tag, (($hw)-> &back)-> &mem_bus_space_handle,  &E1000_REG_OFFSET($hw, $reg) + ($index), $value));
    }' unless defined(&E1000_WRITE_REG_ARRAY_WORD);
    eval 'sub E1000_WRITE_REG_ARRAY_DWORD {
        local($hw, $reg, $index, $value) = @_;
	    eval q( &E1000_WRITE_OFFSET($hw,  &E1000_REG_OFFSET($hw, $reg) + (($index) << 2), $value));
    }' unless defined(&E1000_WRITE_REG_ARRAY_DWORD);
    eval 'sub em_io_read {
        local($hw, $port) = @_;
	    eval q( &bus_space_read_4((($hw)-> &back)-> &em_iobtag, (($hw)-> &back)-> &em_iobhandle, ($port)));
    }' unless defined(&em_io_read);
    eval 'sub em_io_write {
        local($hw, $port, $value) = @_;
	    eval q( &bus_space_write_4((($hw)-> &back)-> &em_iobtag, (($hw)-> &back)-> &em_iobhandle, ($port), ($value)));
    }' unless defined(&em_io_write);
    if(defined(&DEBUG)) {
	eval 'sub EM_KASSERT {
	    local($exp,$msg) = @_;
    	    eval q( &do {  &if (!($exp))  &panic $msg; }  &while (0));
	}' unless defined(&EM_KASSERT);
    } else {
	eval 'sub EM_KASSERT {
	    local($exp,$msg) = @_;
    	    eval q();
	}' unless defined(&EM_KASSERT);
    }
}
1;
