require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_SYS_AGPIO_H_)) {
    eval 'sub _SYS_AGPIO_H_ () {1;}' unless defined(&_SYS_AGPIO_H_);
    eval 'sub AGP_DEVICE () {"/dev/ttyC0";}' unless defined(&AGP_DEVICE);
    eval 'sub AGP_PAGE_SIZE () {4096;}' unless defined(&AGP_PAGE_SIZE);
    eval 'sub AGP_PAGE_SHIFT () {12;}' unless defined(&AGP_PAGE_SHIFT);
    eval 'sub AGP_MODE_GET_RQ {
        local($x) = @_;
	    eval q(((($x) & 0xff000000) >> 24));
    }' unless defined(&AGP_MODE_GET_RQ);
    eval 'sub AGP_MODE_GET_SBA {
        local($x) = @_;
	    eval q(((($x) & 0x200) >> 9));
    }' unless defined(&AGP_MODE_GET_SBA);
    eval 'sub AGP_MODE_GET_AGP {
        local($x) = @_;
	    eval q(((($x) & 0x100) >> 8));
    }' unless defined(&AGP_MODE_GET_AGP);
    eval 'sub AGP_MODE_GET_4G {
        local($x) = @_;
	    eval q(((($x) & 0x20) >> 5));
    }' unless defined(&AGP_MODE_GET_4G);
    eval 'sub AGP_MODE_GET_FW {
        local($x) = @_;
	    eval q(((($x) & 0x10) >> 4));
    }' unless defined(&AGP_MODE_GET_FW);
    eval 'sub AGP_MODE_GET_RATE {
        local($x) = @_;
	    eval q((($x) & 0x3));
    }' unless defined(&AGP_MODE_GET_RATE);
    eval 'sub AGP_MODE_SET_RQ {
        local($x,$v) = @_;
	    eval q(((($x) & ~0xff000000) | (($v) << 24)));
    }' unless defined(&AGP_MODE_SET_RQ);
    eval 'sub AGP_MODE_SET_SBA {
        local($x,$v) = @_;
	    eval q(((($x) & ~0x200) | (($v) << 9)));
    }' unless defined(&AGP_MODE_SET_SBA);
    eval 'sub AGP_MODE_SET_AGP {
        local($x,$v) = @_;
	    eval q(((($x) & ~0x100) | (($v) << 8)));
    }' unless defined(&AGP_MODE_SET_AGP);
    eval 'sub AGP_MODE_SET_4G {
        local($x,$v) = @_;
	    eval q(((($x) & ~0x20) | (($v) << 5)));
    }' unless defined(&AGP_MODE_SET_4G);
    eval 'sub AGP_MODE_SET_FW {
        local($x,$v) = @_;
	    eval q(((($x) & ~0x10) | (($v) << 4)));
    }' unless defined(&AGP_MODE_SET_FW);
    eval 'sub AGP_MODE_SET_RATE {
        local($x,$v) = @_;
	    eval q(((($x) & ~0x3) | ($v)));
    }' unless defined(&AGP_MODE_SET_RATE);
    eval 'sub AGP_MODE_RATE_1x () {0x1;}' unless defined(&AGP_MODE_RATE_1x);
    eval 'sub AGP_MODE_RATE_2x () {0x2;}' unless defined(&AGP_MODE_RATE_2x);
    eval 'sub AGP_MODE_RATE_4x () {0x4;}' unless defined(&AGP_MODE_RATE_4x);
    eval 'sub AGPIOC_BASE () {ord(\'A\');}' unless defined(&AGPIOC_BASE);
    eval 'sub AGPIOC_INFO () { &_IOR ( &AGPIOC_BASE, 0,  &agp_info);}' unless defined(&AGPIOC_INFO);
    eval 'sub AGPIOC_ACQUIRE () { &_IO ( &AGPIOC_BASE, 1);}' unless defined(&AGPIOC_ACQUIRE);
    eval 'sub AGPIOC_RELEASE () { &_IO ( &AGPIOC_BASE, 2);}' unless defined(&AGPIOC_RELEASE);
    eval 'sub AGPIOC_SETUP () { &_IOW ( &AGPIOC_BASE, 3,  &agp_setup);}' unless defined(&AGPIOC_SETUP);
    if(0) {
	eval 'sub AGPIOC_RESERVE () { &_IOW ( &AGPIOC_BASE, 4,  &agp_region);}' unless defined(&AGPIOC_RESERVE);
	eval 'sub AGPIOC_PROTECT () { &_IOW ( &AGPIOC_BASE, 5,  &agp_region);}' unless defined(&AGPIOC_PROTECT);
    }
    eval 'sub AGPIOC_ALLOCATE () { &_IOWR( &AGPIOC_BASE, 6,  &agp_allocate);}' unless defined(&AGPIOC_ALLOCATE);
    eval 'sub AGPIOC_DEALLOCATE () { &_IOW ( &AGPIOC_BASE, 7, \'int\');}' unless defined(&AGPIOC_DEALLOCATE);
    eval 'sub AGPIOC_BIND () { &_IOW ( &AGPIOC_BASE, 8,  &agp_bind);}' unless defined(&AGPIOC_BIND);
    eval 'sub AGPIOC_UNBIND () { &_IOW ( &AGPIOC_BASE, 9,  &agp_unbind);}' unless defined(&AGPIOC_UNBIND);
    if(0) {
    }
}
1;
