require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&TXP_PCI_LOMEM)) {
    sub TXP_PCI_LOMEM () {	0x14;}
}
unless(defined(&TXP_PCI_LOIO)) {
    sub TXP_PCI_LOIO () {	0x10;}
}
unless(defined(&TXP_SRR)) {
    sub TXP_SRR () {	0x;}
}
unless(defined(&TXP_ISR)) {
    sub TXP_ISR () {	0x4;}
}
unless(defined(&TXP_IER)) {
    sub TXP_IER () {	0x8;}
}
unless(defined(&TXP_IMR)) {
    sub TXP_IMR () {	0xc;}
}
unless(defined(&TXP_SIR)) {
    sub TXP_SIR () {	0x10;}
}
unless(defined(&TXP_H2A_7)) {
    sub TXP_H2A_7 () {	0x14;}
}
unless(defined(&TXP_H2A_6)) {
    sub TXP_H2A_6 () {	0x18;}
}
unless(defined(&TXP_H2A_5)) {
    sub TXP_H2A_5 () {	0x1c;}
}
unless(defined(&TXP_H2A_4)) {
    sub TXP_H2A_4 () {	0x20;}
}
unless(defined(&TXP_H2A_3)) {
    sub TXP_H2A_3 () {	0x24;}
}
unless(defined(&TXP_H2A_2)) {
    sub TXP_H2A_2 () {	0x28;}
}
unless(defined(&TXP_H2A_1)) {
    sub TXP_H2A_1 () {	0x2c;}
}
unless(defined(&TXP_H2A_0)) {
    sub TXP_H2A_0 () {	0x30;}
}
unless(defined(&TXP_A2H_3)) {
    sub TXP_A2H_3 () {	0x34;}
}
unless(defined(&TXP_A2H_2)) {
    sub TXP_A2H_2 () {	0x38;}
}
unless(defined(&TXP_A2H_1)) {
    sub TXP_A2H_1 () {	0x3c;}
}
unless(defined(&TXP_A2H_0)) {
    sub TXP_A2H_0 () {	0x40;}
}
unless(defined(&TXP_INT_RESERVED)) {
    sub TXP_INT_RESERVED () {	0xffff0000;}
}
unless(defined(&TXP_INT_A2H_7)) {
    sub TXP_INT_A2H_7 () {	0x8000;}
}
unless(defined(&TXP_INT_A2H_6)) {
    sub TXP_INT_A2H_6 () {	0x4000;}
}
unless(defined(&TXP_INT_A2H_5)) {
    sub TXP_INT_A2H_5 () {	0x2000;}
}
unless(defined(&TXP_INT_A2H_4)) {
    sub TXP_INT_A2H_4 () {	0x1000;}
}
unless(defined(&TXP_INT_SELF)) {
    sub TXP_INT_SELF () {	0x800;}
}
unless(defined(&TXP_INT_PCI_TABORT)) {
    sub TXP_INT_PCI_TABORT () {	0x400;}
}
unless(defined(&TXP_INT_PCI_MABORT)) {
    sub TXP_INT_PCI_MABORT () {	0x200;}
}
unless(defined(&TXP_INT_DMA3)) {
    sub TXP_INT_DMA3 () {	0x100;}
}
unless(defined(&TXP_INT_DMA2)) {
    sub TXP_INT_DMA2 () {	0x80;}
}
unless(defined(&TXP_INT_DMA1)) {
    sub TXP_INT_DMA1 () {	0x40;}
}
unless(defined(&TXP_INT_DMA0)) {
    sub TXP_INT_DMA0 () {	0x20;}
}
unless(defined(&TXP_INT_A2H_3)) {
    sub TXP_INT_A2H_3 () {	0x10;}
}
unless(defined(&TXP_INT_A2H_2)) {
    sub TXP_INT_A2H_2 () {	0x8;}
}
unless(defined(&TXP_INT_A2H_1)) {
    sub TXP_INT_A2H_1 () {	0x4;}
}
unless(defined(&TXP_INT_A2H_0)) {
    sub TXP_INT_A2H_0 () {	0x2;}
}
unless(defined(&TXP_INT_LATCH)) {
    sub TXP_INT_LATCH () {	0x1;}
}
unless(defined(&TXP_SRR_ALL)) {
    sub TXP_SRR_ALL () {	0x7f;}
}
unless(defined(&TXP_BOOTCMD_NULL)) {
    sub TXP_BOOTCMD_NULL () {	0x;}
}
unless(defined(&TXP_BOOTCMD_DOWNLOAD_COMPLETE)) {
    sub TXP_BOOTCMD_DOWNLOAD_COMPLETE () {	0xfb;}
}
unless(defined(&TXP_BOOTCMD_SEGMENT_AVAILABLE)) {
    sub TXP_BOOTCMD_SEGMENT_AVAILABLE () {	0xfc;}
}
unless(defined(&TXP_BOOTCMD_RUNTIME_IMAGE)) {
    sub TXP_BOOTCMD_RUNTIME_IMAGE () {	0xfd;}
}
unless(defined(&TXP_BOOTCMD_REGISTER_BOOT_RECORD)) {
    sub TXP_BOOTCMD_REGISTER_BOOT_RECORD () {	0xff;}
}
unless(defined(&TXP_CMD_GLOBAL_RESET)) {
    sub TXP_CMD_GLOBAL_RESET () {	0x;}
}
unless(defined(&TXP_CMD_TX_ENABLE)) {
    sub TXP_CMD_TX_ENABLE () {	0x1;}
}
unless(defined(&TXP_CMD_TX_DISABLE)) {
    sub TXP_CMD_TX_DISABLE () {	0x2;}
}
unless(defined(&TXP_CMD_RX_ENABLE)) {
    sub TXP_CMD_RX_ENABLE () {	0x3;}
}
unless(defined(&TXP_CMD_RX_DISABLE)) {
    sub TXP_CMD_RX_DISABLE () {	0x4;}
}
unless(defined(&TXP_CMD_RX_FILTER_WRITE)) {
    sub TXP_CMD_RX_FILTER_WRITE () {	0x5;}
}
unless(defined(&TXP_CMD_RX_FILTER_READ)) {
    sub TXP_CMD_RX_FILTER_READ () {	0x6;}
}
unless(defined(&TXP_CMD_READ_STATISTICS)) {
    sub TXP_CMD_READ_STATISTICS () {	0x7;}
}
unless(defined(&TXP_CMD_CYCLE_STATISTICS)) {
    sub TXP_CMD_CYCLE_STATISTICS () {	0x8;}
}
unless(defined(&TXP_CMD_CLEAR_STATISTICS)) {
    sub TXP_CMD_CLEAR_STATISTICS () {	0x9;}
}
unless(defined(&TXP_CMD_MEMORY_READ)) {
    sub TXP_CMD_MEMORY_READ () {	0xa;}
}
unless(defined(&TXP_CMD_MEMORY_WRITE_SINGLE)) {
    sub TXP_CMD_MEMORY_WRITE_SINGLE () {	0xb;}
}
unless(defined(&TXP_CMD_VARIABLE_SECTION_READ)) {
    sub TXP_CMD_VARIABLE_SECTION_READ () {	0xc;}
}
unless(defined(&TXP_CMD_VARIABLE_SECTION_WRITE)) {
    sub TXP_CMD_VARIABLE_SECTION_WRITE () {	0xd;}
}
unless(defined(&TXP_CMD_STATIC_SECTION_READ)) {
    sub TXP_CMD_STATIC_SECTION_READ () {	0xe;}
}
unless(defined(&TXP_CMD_STATIC_SECTION_WRITE)) {
    sub TXP_CMD_STATIC_SECTION_WRITE () {	0xf;}
}
unless(defined(&TXP_CMD_IMAGE_SECTION_PROGRAM)) {
    sub TXP_CMD_IMAGE_SECTION_PROGRAM () {	0x10;}
}
unless(defined(&TXP_CMD_NVRAM_PAGE_READ)) {
    sub TXP_CMD_NVRAM_PAGE_READ () {	0x11;}
}
unless(defined(&TXP_CMD_NVRAM_PAGE_WRITE)) {
    sub TXP_CMD_NVRAM_PAGE_WRITE () {	0x12;}
}
unless(defined(&TXP_CMD_XCVR_SELECT)) {
    sub TXP_CMD_XCVR_SELECT () {	0x13;}
}
unless(defined(&TXP_CMD_TEST_MUX)) {
    sub TXP_CMD_TEST_MUX () {	0x14;}
}
unless(defined(&TXP_CMD_PHYLOOPBACK_ENABLE)) {
    sub TXP_CMD_PHYLOOPBACK_ENABLE () {	0x15;}
}
unless(defined(&TXP_CMD_PHYLOOPBACK_DISABLE)) {
    sub TXP_CMD_PHYLOOPBACK_DISABLE () {	0x16;}
}
unless(defined(&TXP_CMD_MAC_CONTROL_READ)) {
    sub TXP_CMD_MAC_CONTROL_READ () {	0x17;}
}
unless(defined(&TXP_CMD_MAC_CONTROL_WRITE)) {
    sub TXP_CMD_MAC_CONTROL_WRITE () {	0x18;}
}
unless(defined(&TXP_CMD_MAX_PKT_SIZE_READ)) {
    sub TXP_CMD_MAX_PKT_SIZE_READ () {	0x19;}
}
unless(defined(&TXP_CMD_MAX_PKT_SIZE_WRITE)) {
    sub TXP_CMD_MAX_PKT_SIZE_WRITE () {	0x1a;}
}
unless(defined(&TXP_CMD_MEDIA_STATUS_READ)) {
    sub TXP_CMD_MEDIA_STATUS_READ () {	0x1b;}
}
unless(defined(&TXP_CMD_MEDIA_STATUS_WRITE)) {
    sub TXP_CMD_MEDIA_STATUS_WRITE () {	0x1c;}
}
unless(defined(&TXP_CMD_NETWORK_DIAGS_READ)) {
    sub TXP_CMD_NETWORK_DIAGS_READ () {	0x1d;}
}
unless(defined(&TXP_CMD_NETWORK_DIAGS_WRITE)) {
    sub TXP_CMD_NETWORK_DIAGS_WRITE () {	0x1e;}
}
unless(defined(&TXP_CMD_PHY_MGMT_READ)) {
    sub TXP_CMD_PHY_MGMT_READ () {	0x1f;}
}
unless(defined(&TXP_CMD_PHY_MGMT_WRITE)) {
    sub TXP_CMD_PHY_MGMT_WRITE () {	0x20;}
}
unless(defined(&TXP_CMD_VARIABLE_PARAMETER_READ)) {
    sub TXP_CMD_VARIABLE_PARAMETER_READ () {	0x21;}
}
unless(defined(&TXP_CMD_VARIABLE_PARAMETER_WRITE)) {
    sub TXP_CMD_VARIABLE_PARAMETER_WRITE () {	0x22;}
}
unless(defined(&TXP_CMD_GOTO_SLEEP)) {
    sub TXP_CMD_GOTO_SLEEP () {	0x23;}
}
unless(defined(&TXP_CMD_FIREWALL_CONTROL)) {
    sub TXP_CMD_FIREWALL_CONTROL () {	0x24;}
}
unless(defined(&TXP_CMD_MCAST_HASH_MASK_WRITE)) {
    sub TXP_CMD_MCAST_HASH_MASK_WRITE () {	0x25;}
}
unless(defined(&TXP_CMD_STATION_ADDRESS_WRITE)) {
    sub TXP_CMD_STATION_ADDRESS_WRITE () {	0x26;}
}
unless(defined(&TXP_CMD_STATION_ADDRESS_READ)) {
    sub TXP_CMD_STATION_ADDRESS_READ () {	0x27;}
}
unless(defined(&TXP_CMD_STATION_MASK_WRITE)) {
    sub TXP_CMD_STATION_MASK_WRITE () {	0x28;}
}
unless(defined(&TXP_CMD_STATION_MASK_READ)) {
    sub TXP_CMD_STATION_MASK_READ () {	0x29;}
}
unless(defined(&TXP_CMD_VLAN_ETHER_TYPE_READ)) {
    sub TXP_CMD_VLAN_ETHER_TYPE_READ () {	0x2a;}
}
unless(defined(&TXP_CMD_VLAN_ETHER_TYPE_WRITE)) {
    sub TXP_CMD_VLAN_ETHER_TYPE_WRITE () {	0x2b;}
}
unless(defined(&TXP_CMD_VLAN_MASK_READ)) {
    sub TXP_CMD_VLAN_MASK_READ () {	0x2c;}
}
unless(defined(&TXP_CMD_VLAN_MASK_WRITE)) {
    sub TXP_CMD_VLAN_MASK_WRITE () {	0x2d;}
}
unless(defined(&TXP_CMD_BCAST_THROTTLE_WRITE)) {
    sub TXP_CMD_BCAST_THROTTLE_WRITE () {	0x2e;}
}
unless(defined(&TXP_CMD_BCAST_THROTTLE_READ)) {
    sub TXP_CMD_BCAST_THROTTLE_READ () {	0x2f;}
}
unless(defined(&TXP_CMD_DHCP_PREVENT_WRITE)) {
    sub TXP_CMD_DHCP_PREVENT_WRITE () {	0x30;}
}
unless(defined(&TXP_CMD_DHCP_PREVENT_READ)) {
    sub TXP_CMD_DHCP_PREVENT_READ () {	0x31;}
}
unless(defined(&TXP_CMD_RECV_BUFFER_CONTROL)) {
    sub TXP_CMD_RECV_BUFFER_CONTROL () {	0x32;}
}
unless(defined(&TXP_CMD_SOFTWARE_RESET)) {
    sub TXP_CMD_SOFTWARE_RESET () {	0x33;}
}
unless(defined(&TXP_CMD_CREATE_SA)) {
    sub TXP_CMD_CREATE_SA () {	0x34;}
}
unless(defined(&TXP_CMD_DELETE_SA)) {
    sub TXP_CMD_DELETE_SA () {	0x35;}
}
unless(defined(&TXP_CMD_ENABLE_RX_IP_OPTION)) {
    sub TXP_CMD_ENABLE_RX_IP_OPTION () {	0x36;}
}
unless(defined(&TXP_CMD_RANDOM_NUMBER_CONTROL)) {
    sub TXP_CMD_RANDOM_NUMBER_CONTROL () {	0x37;}
}
unless(defined(&TXP_CMD_RANDOM_NUMBER_READ)) {
    sub TXP_CMD_RANDOM_NUMBER_READ () {	0x38;}
}
unless(defined(&TXP_CMD_MATRIX_TABLE_MODE_WRITE)) {
    sub TXP_CMD_MATRIX_TABLE_MODE_WRITE () {	0x39;}
}
unless(defined(&TXP_CMD_MATRIX_DETAIL_READ)) {
    sub TXP_CMD_MATRIX_DETAIL_READ () {	0x3a;}
}
unless(defined(&TXP_CMD_FILTER_ARRAY_READ)) {
    sub TXP_CMD_FILTER_ARRAY_READ () {	0x3b;}
}
unless(defined(&TXP_CMD_FILTER_DETAIL_READ)) {
    sub TXP_CMD_FILTER_DETAIL_READ () {	0x3c;}
}
unless(defined(&TXP_CMD_FILTER_TABLE_MODE_WRITE)) {
    sub TXP_CMD_FILTER_TABLE_MODE_WRITE () {	0x3d;}
}
unless(defined(&TXP_CMD_FILTER_TCL_WRITE)) {
    sub TXP_CMD_FILTER_TCL_WRITE () {	0x3e;}
}
unless(defined(&TXP_CMD_FILTER_TBL_READ)) {
    sub TXP_CMD_FILTER_TBL_READ () {	0x3f;}
}
unless(defined(&TXP_CMD_VERSIONS_READ)) {
    sub TXP_CMD_VERSIONS_READ () {	0x43;}
}
unless(defined(&TXP_CMD_FILTER_DEFINE)) {
    sub TXP_CMD_FILTER_DEFINE () {	0x45;}
}
unless(defined(&TXP_CMD_ADD_WAKEUP_PKT)) {
    sub TXP_CMD_ADD_WAKEUP_PKT () {	0x46;}
}
unless(defined(&TXP_CMD_ADD_SLEEP_PKT)) {
    sub TXP_CMD_ADD_SLEEP_PKT () {	0x47;}
}
unless(defined(&TXP_CMD_ENABLE_SLEEP_EVENTS)) {
    sub TXP_CMD_ENABLE_SLEEP_EVENTS () {	0x48;}
}
unless(defined(&TXP_CMD_ENABLE_WAKEUP_EVENTS)) {
    sub TXP_CMD_ENABLE_WAKEUP_EVENTS () {	0x49;}
}
unless(defined(&TXP_CMD_GET_IP_ADDRESS)) {
    sub TXP_CMD_GET_IP_ADDRESS () {	0x4a;}
}
unless(defined(&TXP_CMD_READ_PCI_REG)) {
    sub TXP_CMD_READ_PCI_REG () {	0x4c;}
}
unless(defined(&TXP_CMD_WRITE_PCI_REG)) {
    sub TXP_CMD_WRITE_PCI_REG () {	0x4d;}
}
unless(defined(&TXP_CMD_OFFLOAD_READ)) {
    sub TXP_CMD_OFFLOAD_READ () {	0x4e;}
}
unless(defined(&TXP_CMD_OFFLOAD_WRITE)) {
    sub TXP_CMD_OFFLOAD_WRITE () {	0x4f;}
}
unless(defined(&TXP_CMD_HELLO_RESPONSE)) {
    sub TXP_CMD_HELLO_RESPONSE () {	0x57;}
}
unless(defined(&TXP_CMD_ENABLE_RX_FILTER)) {
    sub TXP_CMD_ENABLE_RX_FILTER () {	0x58;}
}
unless(defined(&TXP_CMD_RX_FILTER_CAPABILITY)) {
    sub TXP_CMD_RX_FILTER_CAPABILITY () {	0x59;}
}
unless(defined(&TXP_CMD_HALT)) {
    sub TXP_CMD_HALT () {	0x5d;}
}
unless(defined(&TXP_CMD_READ_IPSEC_INFO)) {
    sub TXP_CMD_READ_IPSEC_INFO () {	0x54;}
}
unless(defined(&TXP_CMD_GET_IPSEC_ENABLE)) {
    sub TXP_CMD_GET_IPSEC_ENABLE () {	0x67;}
}
unless(defined(&TXP_CMD_INVALID)) {
    sub TXP_CMD_INVALID () {	0xffff;}
}
unless(defined(&TXP_FRAGMENT)) {
    sub TXP_FRAGMENT () {	0x;}
}
unless(defined(&TXP_TXFRAME)) {
    sub TXP_TXFRAME () {	0x1;}
}
unless(defined(&TXP_COMMAND)) {
    sub TXP_COMMAND () {	0x2;}
}
unless(defined(&TXP_OPTION)) {
    sub TXP_OPTION () {	0x3;}
}
unless(defined(&TXP_RECEIVE)) {
    sub TXP_RECEIVE () {	0x4;}
}
unless(defined(&TXP_RESPONSE)) {
    sub TXP_RESPONSE () {	0x5;}
}
unless(defined(&TXP_TYPE_IPSEC)) {
    sub TXP_TYPE_IPSEC () {	0x;}
}
unless(defined(&TXP_TYPE_TCPSEGMENT)) {
    sub TXP_TYPE_TCPSEGMENT () {	0x1;}
}
unless(defined(&TXP_PFLAG_NOCRC)) {
    sub TXP_PFLAG_NOCRC () {	0x1;}
}
unless(defined(&TXP_PFLAG_IPCKSUM)) {
    sub TXP_PFLAG_IPCKSUM () {	0x2;}
}
unless(defined(&TXP_PFLAG_TCPCKSUM)) {
    sub TXP_PFLAG_TCPCKSUM () {	0x4;}
}
unless(defined(&TXP_PFLAG_TCPSEGMENT)) {
    sub TXP_PFLAG_TCPSEGMENT () {	0x8;}
}
unless(defined(&TXP_PFLAG_INSERTVLAN)) {
    sub TXP_PFLAG_INSERTVLAN () {	0x10;}
}
unless(defined(&TXP_PFLAG_IPSEC)) {
    sub TXP_PFLAG_IPSEC () {	0x20;}
}
unless(defined(&TXP_PFLAG_PRIORITY)) {
    sub TXP_PFLAG_PRIORITY () {	0x40;}
}
unless(defined(&TXP_PFLAG_UDPCKSUM)) {
    sub TXP_PFLAG_UDPCKSUM () {	0x80;}
}
unless(defined(&TXP_PFLAG_PADFRAME)) {
    sub TXP_PFLAG_PADFRAME () {	0x100;}
}
unless(defined(&TXP_MISC_FIRSTDESC)) {
    sub TXP_MISC_FIRSTDESC () {	0x;}
}
unless(defined(&TXP_MISC_LASTDESC)) {
    sub TXP_MISC_LASTDESC () {	0x1;}
}
unless(defined(&TXP_ERR_INTERNAL)) {
    sub TXP_ERR_INTERNAL () {	0x;}
}
unless(defined(&TXP_ERR_FIFOUNDERRUN)) {
    sub TXP_ERR_FIFOUNDERRUN () {	0x1;}
}
unless(defined(&TXP_ERR_BADSSD)) {
    sub TXP_ERR_BADSSD () {	0x2;}
}
unless(defined(&TXP_ERR_RUNT)) {
    sub TXP_ERR_RUNT () {	0x3;}
}
unless(defined(&TXP_ERR_CRC)) {
    sub TXP_ERR_CRC () {	0x4;}
}
unless(defined(&TXP_ERR_OVERSIZE)) {
    sub TXP_ERR_OVERSIZE () {	0x5;}
}
unless(defined(&TXP_ERR_ALIGNMENT)) {
    sub TXP_ERR_ALIGNMENT () {	0x6;}
}
unless(defined(&TXP_ERR_DRIBBLEBIT)) {
    sub TXP_ERR_DRIBBLEBIT () {	0x7;}
}
unless(defined(&TXP_PROTO_UNKNOWN)) {
    sub TXP_PROTO_UNKNOWN () {	0x;}
}
unless(defined(&TXP_PROTO_IP)) {
    sub TXP_PROTO_IP () {	0x1;}
}
unless(defined(&TXP_PROTO_IPX)) {
    sub TXP_PROTO_IPX () {	0x2;}
}
unless(defined(&TXP_PROTO_RESERVED)) {
    sub TXP_PROTO_RESERVED () {	0x3;}
}
unless(defined(&TXP_STAT_PROTO)) {
    sub TXP_STAT_PROTO () {	0x1;}
}
unless(defined(&TXP_STAT_VLAN)) {
    sub TXP_STAT_VLAN () {	0x2;}
}
unless(defined(&TXP_STAT_IPFRAGMENT)) {
    sub TXP_STAT_IPFRAGMENT () {	0x4;}
}
unless(defined(&TXP_STAT_IPSEC)) {
    sub TXP_STAT_IPSEC () {	0x8;}
}
unless(defined(&TXP_STAT_IPCKSUMBAD)) {
    sub TXP_STAT_IPCKSUMBAD () {	0x10;}
}
unless(defined(&TXP_STAT_TCPCKSUMBAD)) {
    sub TXP_STAT_TCPCKSUMBAD () {	0x20;}
}
unless(defined(&TXP_STAT_UDPCKSUMBAD)) {
    sub TXP_STAT_UDPCKSUMBAD () {	0x40;}
}
unless(defined(&TXP_STAT_IPCKSUMGOOD)) {
    sub TXP_STAT_IPCKSUMGOOD () {	0x80;}
}
unless(defined(&TXP_STAT_TCPCKSUMGOOD)) {
    sub TXP_STAT_TCPCKSUMGOOD () {	0x100;}
}
unless(defined(&TXP_STAT_UDPCKSUMGOOD)) {
    sub TXP_STAT_UDPCKSUMGOOD () {	0x200;}
}
unless(defined(&TX_FLAGS_TYPE_M)) {
    sub TX_FLAGS_TYPE_M () {	0x7;}
}
unless(defined(&TX_FLAGS_TYPE_FRAG)) {
    sub TX_FLAGS_TYPE_FRAG () {	0x;}
}
unless(defined(&TX_FLAGS_TYPE_DATA)) {
    sub TX_FLAGS_TYPE_DATA () {	0x1;}
}
unless(defined(&TX_FLAGS_TYPE_CMD)) {
    sub TX_FLAGS_TYPE_CMD () {	0x2;}
}
unless(defined(&TX_FLAGS_TYPE_OPT)) {
    sub TX_FLAGS_TYPE_OPT () {	0x3;}
}
unless(defined(&TX_FLAGS_TYPE_RX)) {
    sub TX_FLAGS_TYPE_RX () {	0x4;}
}
unless(defined(&TX_FLAGS_TYPE_RESP)) {
    sub TX_FLAGS_TYPE_RESP () {	0x5;}
}
unless(defined(&TX_FLAGS_RESP)) {
    sub TX_FLAGS_RESP () {	0x40;}
}
unless(defined(&TX_FLAGS_VALID)) {
    sub TX_FLAGS_VALID () {	0x80;}
}
unless(defined(&TX_PFLAGS_DNAC)) {
    sub TX_PFLAGS_DNAC () {	0x1;}
}
unless(defined(&TX_PFLAGS_IPCKSUM)) {
    sub TX_PFLAGS_IPCKSUM () {	0x2;}
}
unless(defined(&TX_PFLAGS_TCPCKSUM)) {
    sub TX_PFLAGS_TCPCKSUM () {	0x4;}
}
unless(defined(&TX_PFLAGS_TCPSEG)) {
    sub TX_PFLAGS_TCPSEG () {	0x8;}
}
unless(defined(&TX_PFLAGS_VLAN)) {
    sub TX_PFLAGS_VLAN () {	0x10;}
}
unless(defined(&TX_PFLAGS_IPSEC)) {
    sub TX_PFLAGS_IPSEC () {	0x20;}
}
unless(defined(&TX_PFLAGS_PRIO)) {
    sub TX_PFLAGS_PRIO () {	0x40;}
}
unless(defined(&TX_PFLAGS_UDPCKSUM)) {
    sub TX_PFLAGS_UDPCKSUM () {	0x80;}
}
unless(defined(&TX_PFLAGS_PADFRAME)) {
    sub TX_PFLAGS_PADFRAME () {	0x100;}
}
unless(defined(&TX_PFLAGS_VLANTAG_M)) {
    sub TX_PFLAGS_VLANTAG_M () {	0xffff000;}
}
unless(defined(&TX_PFLAGS_VLANPRI_M)) {
    sub TX_PFLAGS_VLANPRI_M () {	0x700000;}
}
unless(defined(&TX_PFLAGS_VLANTAG_S)) {
    sub TX_PFLAGS_VLANTAG_S () {	12;}
}
unless(defined(&RX_FLAGS_TYPE_M)) {
    sub RX_FLAGS_TYPE_M () {	0x7;}
}
unless(defined(&RX_FLAGS_TYPE_FRAG)) {
    sub RX_FLAGS_TYPE_FRAG () {	0x;}
}
unless(defined(&RX_FLAGS_TYPE_DATA)) {
    sub RX_FLAGS_TYPE_DATA () {	0x1;}
}
unless(defined(&RX_FLAGS_TYPE_CMD)) {
    sub RX_FLAGS_TYPE_CMD () {	0x2;}
}
unless(defined(&RX_FLAGS_TYPE_OPT)) {
    sub RX_FLAGS_TYPE_OPT () {	0x3;}
}
unless(defined(&RX_FLAGS_TYPE_RX)) {
    sub RX_FLAGS_TYPE_RX () {	0x4;}
}
unless(defined(&RX_FLAGS_TYPE_RESP)) {
    sub RX_FLAGS_TYPE_RESP () {	0x5;}
}
unless(defined(&RX_FLAGS_RCV_TYPE_M)) {
    sub RX_FLAGS_RCV_TYPE_M () {	0x18;}
}
unless(defined(&RX_FLAGS_RCV_TYPE_RX)) {
    sub RX_FLAGS_RCV_TYPE_RX () {	0x;}
}
unless(defined(&RX_FLAGS_RCV_TYPE_RSP)) {
    sub RX_FLAGS_RCV_TYPE_RSP () {	0x8;}
}
unless(defined(&RX_FLAGS_ERROR)) {
    sub RX_FLAGS_ERROR () {	0x40;}
}
unless(defined(&RX_ERROR_ADAPTER)) {
    sub RX_ERROR_ADAPTER () {	0x;}
}
unless(defined(&RX_ERROR_FIFO)) {
    sub RX_ERROR_FIFO () {	0x1;}
}
unless(defined(&RX_ERROR_BADSSD)) {
    sub RX_ERROR_BADSSD () {	0x2;}
}
unless(defined(&RX_ERROR_RUNT)) {
    sub RX_ERROR_RUNT () {	0x3;}
}
unless(defined(&RX_ERROR_CRC)) {
    sub RX_ERROR_CRC () {	0x4;}
}
unless(defined(&RX_ERROR_OVERSIZE)) {
    sub RX_ERROR_OVERSIZE () {	0x5;}
}
unless(defined(&RX_ERROR_ALIGN)) {
    sub RX_ERROR_ALIGN () {	0x6;}
}
unless(defined(&RX_ERROR_DRIBBLE)) {
    sub RX_ERROR_DRIBBLE () {	0x7;}
}
unless(defined(&RX_STAT_PROTO_M)) {
    sub RX_STAT_PROTO_M () {	0x3;}
}
unless(defined(&RX_STAT_PROTO_UK)) {
    sub RX_STAT_PROTO_UK () {	0x;}
}
unless(defined(&RX_STAT_PROTO_IPX)) {
    sub RX_STAT_PROTO_IPX () {	0x1;}
}
unless(defined(&RX_STAT_PROTO_IP)) {
    sub RX_STAT_PROTO_IP () {	0x2;}
}
unless(defined(&RX_STAT_PROTO_RSV)) {
    sub RX_STAT_PROTO_RSV () {	0x3;}
}
unless(defined(&RX_STAT_VLAN)) {
    sub RX_STAT_VLAN () {	0x4;}
}
unless(defined(&RX_STAT_IPFRAG)) {
    sub RX_STAT_IPFRAG () {	0x8;}
}
unless(defined(&RX_STAT_IPSEC)) {
    sub RX_STAT_IPSEC () {	0x10;}
}
unless(defined(&RX_STAT_IPCKSUMBAD)) {
    sub RX_STAT_IPCKSUMBAD () {	0x20;}
}
unless(defined(&RX_STAT_UDPCKSUMBAD)) {
    sub RX_STAT_UDPCKSUMBAD () {	0x40;}
}
unless(defined(&RX_STAT_TCPCKSUMBAD)) {
    sub RX_STAT_TCPCKSUMBAD () {	0x80;}
}
unless(defined(&RX_STAT_IPCKSUMGOOD)) {
    sub RX_STAT_IPCKSUMGOOD () {	0x100;}
}
unless(defined(&RX_STAT_UDPCKSUMGOOD)) {
    sub RX_STAT_UDPCKSUMGOOD () {	0x200;}
}
unless(defined(&RX_STAT_TCPCKSUMGOOD)) {
    sub RX_STAT_TCPCKSUMGOOD () {	0x400;}
}
unless(defined(&CMD_FLAGS_TYPE_M)) {
    sub CMD_FLAGS_TYPE_M () {	0x7;}
}
unless(defined(&CMD_FLAGS_TYPE_FRAG)) {
    sub CMD_FLAGS_TYPE_FRAG () {	0x;}
}
unless(defined(&CMD_FLAGS_TYPE_DATA)) {
    sub CMD_FLAGS_TYPE_DATA () {	0x1;}
}
unless(defined(&CMD_FLAGS_TYPE_CMD)) {
    sub CMD_FLAGS_TYPE_CMD () {	0x2;}
}
unless(defined(&CMD_FLAGS_TYPE_OPT)) {
    sub CMD_FLAGS_TYPE_OPT () {	0x3;}
}
unless(defined(&CMD_FLAGS_TYPE_RX)) {
    sub CMD_FLAGS_TYPE_RX () {	0x4;}
}
unless(defined(&CMD_FLAGS_TYPE_RESP)) {
    sub CMD_FLAGS_TYPE_RESP () {	0x5;}
}
unless(defined(&CMD_FLAGS_RESP)) {
    sub CMD_FLAGS_RESP () {	0x40;}
}
unless(defined(&CMD_FLAGS_VALID)) {
    sub CMD_FLAGS_VALID () {	0x80;}
}
unless(defined(&RSP_FLAGS_TYPE_M)) {
    sub RSP_FLAGS_TYPE_M () {	0x7;}
}
unless(defined(&RSP_FLAGS_TYPE_FRAG)) {
    sub RSP_FLAGS_TYPE_FRAG () {	0x;}
}
unless(defined(&RSP_FLAGS_TYPE_DATA)) {
    sub RSP_FLAGS_TYPE_DATA () {	0x1;}
}
unless(defined(&RSP_FLAGS_TYPE_CMD)) {
    sub RSP_FLAGS_TYPE_CMD () {	0x2;}
}
unless(defined(&RSP_FLAGS_TYPE_OPT)) {
    sub RSP_FLAGS_TYPE_OPT () {	0x3;}
}
unless(defined(&RSP_FLAGS_TYPE_RX)) {
    sub RSP_FLAGS_TYPE_RX () {	0x4;}
}
unless(defined(&RSP_FLAGS_TYPE_RESP)) {
    sub RSP_FLAGS_TYPE_RESP () {	0x5;}
}
unless(defined(&RSP_FLAGS_ERROR)) {
    sub RSP_FLAGS_ERROR () {	0x40;}
}
unless(defined(&FRAG_FLAGS_TYPE_M)) {
    sub FRAG_FLAGS_TYPE_M () {	0x7;}
}
unless(defined(&FRAG_FLAGS_TYPE_FRAG)) {
    sub FRAG_FLAGS_TYPE_FRAG () {	0x;}
}
unless(defined(&FRAG_FLAGS_TYPE_DATA)) {
    sub FRAG_FLAGS_TYPE_DATA () {	0x1;}
}
unless(defined(&FRAG_FLAGS_TYPE_CMD)) {
    sub FRAG_FLAGS_TYPE_CMD () {	0x2;}
}
unless(defined(&FRAG_FLAGS_TYPE_OPT)) {
    sub FRAG_FLAGS_TYPE_OPT () {	0x3;}
}
unless(defined(&FRAG_FLAGS_TYPE_RX)) {
    sub FRAG_FLAGS_TYPE_RX () {	0x4;}
}
unless(defined(&FRAG_FLAGS_TYPE_RESP)) {
    sub FRAG_FLAGS_TYPE_RESP () {	0x5;}
}
unless(defined(&FRAG_FLAGS_VALID)) {
    sub FRAG_FLAGS_VALID () {	0x80;}
}
unless(defined(&TXP_XCVR_10_HDX)) {
    sub TXP_XCVR_10_HDX () {	0;}
}
unless(defined(&TXP_XCVR_10_FDX)) {
    sub TXP_XCVR_10_FDX () {	1;}
}
unless(defined(&TXP_XCVR_100_HDX)) {
    sub TXP_XCVR_100_HDX () {	2;}
}
unless(defined(&TXP_XCVR_100_FDX)) {
    sub TXP_XCVR_100_FDX () {	3;}
}
unless(defined(&TXP_XCVR_AUTO)) {
    sub TXP_XCVR_AUTO () {	4;}
}
unless(defined(&TXP_MEDIA_CRC)) {
    sub TXP_MEDIA_CRC () {	0x4;}
}
unless(defined(&TXP_MEDIA_CD)) {
    sub TXP_MEDIA_CD () {	0x10;}
}
unless(defined(&TXP_MEDIA_CS)) {
    sub TXP_MEDIA_CS () {	0x20;}
}
unless(defined(&TXP_MEDIA_POL)) {
    sub TXP_MEDIA_POL () {	0x400;}
}
unless(defined(&TXP_MEDIA_NOLINK)) {
    sub TXP_MEDIA_NOLINK () {	0x800;}
}
unless(defined(&TXP_RXFILT_DIRECT)) {
    sub TXP_RXFILT_DIRECT () {	0x1;}
}
unless(defined(&TXP_RXFILT_ALLMULTI)) {
    sub TXP_RXFILT_ALLMULTI () {	0x2;}
}
unless(defined(&TXP_RXFILT_BROADCAST)) {
    sub TXP_RXFILT_BROADCAST () {	0x4;}
}
unless(defined(&TXP_RXFILT_PROMISC)) {
    sub TXP_RXFILT_PROMISC () {	0x8;}
}
unless(defined(&TXP_RXFILT_HASHMULTI)) {
    sub TXP_RXFILT_HASHMULTI () {	0x10;}
}
unless(defined(&STAT_ROM_CODE)) {
    sub STAT_ROM_CODE () {	0x1;}
}
unless(defined(&STAT_ROM_EEPROM_LOAD)) {
    sub STAT_ROM_EEPROM_LOAD () {	0x2;}
}
unless(defined(&STAT_WAITING_FOR_BOOT)) {
    sub STAT_WAITING_FOR_BOOT () {	0x7;}
}
unless(defined(&STAT_RUNNING)) {
    sub STAT_RUNNING () {	0x9;}
}
unless(defined(&STAT_WAITING_FOR_HOST_REQUEST)) {
    sub STAT_WAITING_FOR_HOST_REQUEST () {	0xd;}
}
unless(defined(&STAT_WAITING_FOR_SEGMENT)) {
    sub STAT_WAITING_FOR_SEGMENT () {	0x10;}
}
unless(defined(&STAT_SLEEPING)) {
    sub STAT_SLEEPING () {	0x11;}
}
unless(defined(&STAT_HALTED)) {
    sub STAT_HALTED () {	0x14;}
}
unless(defined(&TX_ENTRIES)) {
    sub TX_ENTRIES () {	256;}
}
unless(defined(&RX_ENTRIES)) {
    sub RX_ENTRIES () {	128;}
}
unless(defined(&RXBUF_ENTRIES)) {
    sub RXBUF_ENTRIES () {	256;}
}
unless(defined(&CMD_ENTRIES)) {
    sub CMD_ENTRIES () {	32;}
}
unless(defined(&RSP_ENTRIES)) {
    sub RSP_ENTRIES () {	32;}
}
unless(defined(&OFFLOAD_TCPCKSUM)) {
    sub OFFLOAD_TCPCKSUM () {	0x2;}
}
unless(defined(&OFFLOAD_UDPCKSUM)) {
    sub OFFLOAD_UDPCKSUM () {	0x4;}
}
unless(defined(&OFFLOAD_IPCKSUM)) {
    sub OFFLOAD_IPCKSUM () {	0x8;}
}
unless(defined(&OFFLOAD_IPSEC)) {
    sub OFFLOAD_IPSEC () {	0x10;}
}
unless(defined(&OFFLOAD_BCAST)) {
    sub OFFLOAD_BCAST () {	0x20;}
}
unless(defined(&OFFLOAD_DHCP)) {
    sub OFFLOAD_DHCP () {	0x40;}
}
unless(defined(&OFFLOAD_VLAN)) {
    sub OFFLOAD_VLAN () {	0x80;}
}
unless(defined(&OFFLOAD_FILTER)) {
    sub OFFLOAD_FILTER () {	0x100;}
}
unless(defined(&OFFLOAD_TCPSEG)) {
    sub OFFLOAD_TCPSEG () {	0x200;}
}
unless(defined(&OFFLOAD_MASK)) {
    sub OFFLOAD_MASK () {	0xfffffffe;}
}
unless(defined(&TXP_IDX2OFFSET)) {
    sub TXP_IDX2OFFSET {
	local($idx) = @_;
	eval q((($idx) << 4));
    }
}
unless(defined(&TXP_OFFSET2IDX)) {
    sub TXP_OFFSET2IDX {
	local($off) = @_;
	eval q((($off) >> 4));
    }
}
unless(defined(&TXP_DEVNAME)) {
    sub TXP_DEVNAME {
	local($sc) = @_;
	eval q((($sc)-> &sc_cold ? \"\" : ($sc)-> ($sc_dev->{dv_xname})));
    }
}
unless(defined(&TXP_MAX_SEGLEN)) {
    sub TXP_MAX_SEGLEN () {	0xffff;}
}
unless(defined(&TXP_MAX_PKTLEN)) {
    sub TXP_MAX_PKTLEN () {	0x800;}
}
unless(defined(&WRITE_REG)) {
    sub WRITE_REG {
	local($sc,$reg,$val) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_bt, ($sc)-> &sc_bh, $reg, $val));
    }
}
unless(defined(&READ_REG)) {
    sub READ_REG {
	local($sc,$reg) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_bt, ($sc)-> &sc_bh, $reg));
    }
}
1;
