"""
$RCSfile: ICacheManager.py,v $

ZopeXMLMethods provides filters to apply to Zope objects for XML/XSLT
processing.  XSLTMethod associates XSLT transformers with XML
documents.  ZopeXMLMethods includes XML Method Cache Manager that is
specialized to notice changes to the XML source files and to store
cached contents in files in the filesystem, rather than the Zope
object database.

ICacheManager is the Interface implemented by CacheManager.

Author: Craeg Strong <cstrong@arielpartners.com>
Modified by Philipp von Weitershausen <philikon@philikon.de>

$Id: ICacheManager.py,v 1.10 2003/03/30 03:45:47 cstrong Exp $
"""

__cvstag__  = '$Name:  $'[6:-2]
__date__    = '$Date: 2003/03/30 03:45:47 $'[6:-2]
__version__ = '$Revision: 1.10 $'[10:-2]

# Zope Base Classes
from Interface import Base

################################################################
# ICacheManager interface
################################################################

class ICacheManager(Base):
    """
    XML Method Cache Manager public interface
    """

    def batchSetCachingOn():
        """
        Turns caching on for all instances of all types of XML filters
        within the scope of this cache manager.
        """

    def batchSetCachingOff():
        """
        Turns caching off for all instances of all types of XML
        filters within the scope of this cache manager.

        """

    def cacheFileTimeStamp(url):
        """
        Return the last modified time of the cache file for the passed in
        URL 'url', or 0 if the cache file does not exist
        """

    def valueFromCache(url):
        """
        Retrieve the output from the cache for the passed in
        URL 'url', or None if the cache file does not exist.
        """

    def saveToCache(url, contents):
        """
        Save some contents 'contents' to the cache for the passed in
        URL 'url'.  It will overwrite the previous contents of the cache
        file, or create a new cache file if it does not yet exist.
        """

    def clearCache():
        """
        Clear the cache.  This involves removing every cache file from
        the file system.
        """

    def listCacheFiles():
        """
        Return the list of files in the cache
        """

    ################################################################
    # Below is a section of methods we would like to support
    # but can't yet figure out exactly *how*
    # Suggestions appreciated @@ CKS 3/2/2003
    ################################################################    

#     def regenerateAll():
#         """
#         Forces all usages of all XML filters within the scope of this
#         cache manager to regenerate (transform) their contents.  They
#         may or may not cache the result, depending on their cache
#         settings.
#         """

#     def regenerateIfNeeded():
#         """
#         For all usages of all XML filters within the scope of this
#         cache manager that have caching on, check to see if the cached
#         version of their contents is up to date.  If not, regenerate
#         it and cache it.  This method does not affect those instances
#         of XML filters for which caching is set to off.
#         """

#     def listUpToDate():
#         """
#         List all users of all XML filter instances within the
#         scope of this Cache Manager that are up to date with respect
#         to this cache.
#         """

#     def listOutOfDate():
#         """
#         List all users of all XML filter instances within the scope
#         of this Cache Manager that are out to date with respect to
#         this cache.
#         """
