/*

Copyright (C) 2000 - 2004 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_clipboard_h
#define __nd_clipboard_h

/**
 * nd_clipboard_init - initializes clipboard.
 *
 * Netdude provides a clipboard mechanism to temporarily store packets.
 * This function initializes the necessary data structures.
 */
void  nd_clipboard_init(void);


/**
 * nd_clipboard_cut - cuts current selection into clipboard.
 *
 * This function cuts the currently selected packets out of a trace
 * and places them in the clipboard.
 */
void  nd_clipboard_cut(void);


/**
 * nd_clipboard_copy - copies current selection into clipboard.
 *
 * This function copies the currently selected packets from a trace
 * into the clipboard.
 */
void  nd_clipboard_copy(void);


/**
 * nd_clipboard_past - pastes the current clipboard contents.
 *
 * The function pastes the contents of the clipboard into the
 * currently edited trace.
 */
void  nd_clipboard_paste(void);


/**
 * nd_clipboard_occupied - predicate that tests emptyness of clipboard.
 *
 * The function checks whether the clipboard contains any data
 * and returns the outcome of the test.
 *
 * Returns: %TRUE when the clipboard contains data, %FALSE otherwise.
 */
int   nd_clipboard_occupied(void);

#endif
