//
//  The Worldforge Project
//  Copyright (C) 1998,1999  The Worldforge Project
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License as 
//  published by the Free Software Foundation; either version 2.1 of the
//  License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, SA.
//
//  For information about Worldforge and its authors, please contact
//  the Worldforge Web Site at http://www.worldforge.org.
//


// usefull debugging stuff             Karsten Laux, 12/1998

#ifndef _DEBUG_H_
#define _DEBUG_H_

namespace uta {

#ifdef DEBUG

extern unsigned long debug_mask;

#define DEBUG_INIT(mask) \
{ uta::debug_mask = mask; if(mask){cerr<<"debugging enabled.("<<mask<<")"<<endl;}  }
#define DEBUG_ADD_CHANNEL(n) { uta::debug_mask |= (1 << n); }
#define debug(prg) { if(uta::debug_mask) { prg }  }
#define debugN(n, prg) { if(uta::debug_mask & (1<<n)) { prg } }

#else

#define DEBUG_ADD_CHANNEL(n)
#define DEBUG_INIT(mask) 
#define debug(prg)
#define debugN(n, prg)

#endif


#ifdef DEBUG
///for constuctors
#define C(CLASS) \
	cerr << "constructing " << #CLASS  << "  (ctor def: " \
	     << __FILE__ << ", at line " << __LINE__ << ")" << endl;
/// for destruktors
#define D(CLASS) \
	cerr << "destroying " << #CLASS  << "  (dtor def: " \
	     << __FILE__ << ", at line " << __LINE__ << ")" << endl;
/// copy construct
#define CC(CLASS) \
	cerr << "copy constructing " << #CLASS  << "  (copy ctor def: " \
	     << __FILE__ << ", at line " << __LINE__ << ")" << endl;
/// asignment
#define A(CLASS) \
	cerr << "assigning " << #CLASS  << "  (ass op def: " \
	     << __FILE__ << ", at line " << __LINE__ << ")" << endl;

/// marking lines
#ifdef _WIN32_
	/// visual c++ doesn't know __PRETTY_FUNCTION__
#define MARK \
	cerr << "*** " << __FILE__ << ":" << __LINE__ << " *** " << endl;
#else
#define MARK \
	cerr << "*** " << __FILE__ << ":" << __LINE__ << " *** " \
	     << __PRETTY_FUNCTION__ << " ***" << endl;
#endif

#else
#define C(CLASS)
#define D(CLASS)
#define CC(CLASS)
#define A(CLASS)
#define MARK
#endif

}

#endif
