/*
 * Decompiled with CFR 0.152.
 */
package org.kde.kjas.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.URL;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import org.kde.kjas.server.Main;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class KIOConnection {
    static final int NOT_CONNECTED = 0;
    static final int CONNECT_WAIT = 1;
    static final int CONNECTED = 2;
    static final int DATA = 0;
    static final int FINISHED = 1;
    static final int ERRORCODE = 2;
    static final int CONNECT = 6;
    static final int REQUESTDATA = 7;
    static final int STOP = 0;
    static final int HOLD = 1;
    static final int RESUME = 2;
    protected static int id = 0;
    static Hashtable jobs = new Hashtable();
    private static final int LOW_BUFFER_LIMIT = 5;
    private static final int HIGH_BUFFER_LIMIT = 10;
    protected URL url;
    protected int connect_status;
    protected String jobid;
    protected LinkedList data;
    protected int errorcode;
    protected boolean finished;
    protected boolean onhold;
    protected boolean request_data;
    private KJASOutputStream out;
    private KJASInputStream in;
    private byte[] in_buf;
    private int in_bufpos;
    private boolean in_eof;

    static void setData(String string, int n, byte[] byArray) {
        KIOConnection kIOConnection = (KIOConnection)jobs.get(string);
        if (kIOConnection == null || !kIOConnection.setData(n, byArray)) {
            Main.info("KIO KJASHttpURLConnection gone (timedout/closed)");
        } else {
            Thread.yield();
        }
    }

    protected void checkConnected() throws IOException {
        if (this.connect_status != 2) {
            throw new IOException("not connected");
        }
    }

    protected boolean haveError() {
        boolean bl = false;
        if (this.errorcode != 0) {
            bl = true;
        }
        return bl;
    }

    protected synchronized boolean setData(int n, byte[] byArray) {
        if (jobs.get(this.jobid) == null) {
            return false;
        }
        if (this.connect_status == 1) {
            this.connect_status = 2;
        }
        switch (n) {
            case 1: {
                if (byArray != null && byArray.length > 0) {
                    this.data.addLast(byArray);
                }
                this.finished = true;
                this.onhold = false;
                jobs.remove(this.jobid);
                Main.debug("KIO FINISHED (" + this.jobid + ") " + this.data.size());
                break;
            }
            case 0: {
                if (byArray.length > 0) {
                    this.data.addLast(byArray);
                }
                if (this.onhold || this.data.size() <= 10) break;
                Main.protocol.sendDataCmd(this.jobid, 1);
                this.onhold = true;
                break;
            }
            case 2: {
                String string = new String(byArray);
                this.errorcode = Integer.parseInt(string);
                Main.debug("KIO ERRORECODE(" + this.jobid + ") " + this.errorcode);
                break;
            }
            case 6: {
                Main.debug("KIO CONNECT(" + this.jobid + ") ");
                this.request_data = true;
                this.errorcode = 0;
                break;
            }
            case 7: {
                Main.debug("KIO REQUESTDATA(" + this.jobid + ") ");
                this.request_data = true;
                break;
            }
        }
        this.notifyAll();
        return true;
    }

    private final synchronized boolean getData(boolean bl) throws IOException {
        if (this.haveError()) {
            this.in_eof = true;
        }
        if (this.in_eof) {
            return false;
        }
        this.checkConnected();
        if (this.in_buf != null && this.in_bufpos < this.in_buf.length) {
            return true;
        }
        int n = this.data.size();
        if (n > 0) {
            this.in_buf = (byte[])this.data.removeFirst();
            this.in_bufpos = 0;
        }
        if (this.onhold && n < 5) {
            Main.protocol.sendDataCmd(this.jobid, 2);
            this.onhold = false;
        }
        if (n > 0) {
            return true;
        }
        if (this.finished) {
            this.in_eof = true;
            return false;
        }
        if (!bl) {
            return false;
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return this.getData(false);
    }

    private final synchronized int inAvailable() throws IOException {
        if (this.in_eof) {
            return 0;
        }
        this.checkConnected();
        if (!this.getData(false)) {
            return 0;
        }
        int n = this.in_buf.length - this.in_bufpos;
        ListIterator listIterator = this.data.listIterator(0);
        while (listIterator.hasNext()) {
            n += ((byte[])listIterator.next()).length;
        }
        return n;
    }

    private final synchronized void sendData(byte[] byArray, boolean bl) throws IOException {
        Main.debug("KIO sendData(" + this.jobid + ") force:" + bl + " request_data:" + this.request_data);
        if (byArray != null) {
            this.data.addLast(byArray);
        }
        if (!this.request_data && !bl) {
            return;
        }
        if (this.data.size() == 0) {
            return;
        }
        if (bl && !this.request_data) {
            try {
                this.wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            if (!this.request_data) {
                Main.debug("KIO sendData(" + this.jobid + ") timeout");
                this.data.clear();
                this.disconnect();
                throw new IOException("timeout");
            }
        }
        int n = 0;
        ListIterator listIterator = this.data.listIterator(0);
        while (listIterator.hasNext()) {
            n += ((byte[])listIterator.next()).length;
        }
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        listIterator = this.data.listIterator(0);
        while (listIterator.hasNext()) {
            byte[] byArray3 = (byte[])listIterator.next();
            System.arraycopy(byArray3, 0, byArray2, n2, byArray3.length);
            n2 += byArray3.length;
        }
        this.data.clear();
        this.request_data = false;
        Main.protocol.sendPutData(this.jobid, byArray2, 0, n);
    }

    synchronized void connect(boolean bl) throws IOException {
        boolean bl2;
        if (this.connect_status == 2) {
            return;
        }
        Main.debug("KIO connect " + this.url);
        this.errorcode = 0;
        this.in_eof = false;
        this.finished = false;
        this.jobid = String.valueOf(id++);
        jobs.put(this.jobid, this);
        if (bl) {
            Main.protocol.sendGetURLDataCmd(this.jobid, this.url.toExternalForm());
        } else {
            Main.protocol.sendPutURLDataCmd(this.jobid, this.url.toExternalForm());
        }
        this.connect_status = 1;
        try {
            this.wait(20000L);
        }
        catch (InterruptedException interruptedException) {
            this.errorcode = -1;
        }
        boolean bl3 = false;
        if (this.connect_status == 2) {
            bl3 = true;
        }
        if ((bl2 = bl3) && !this.haveError()) {
            if (bl) {
                this.in = new KJASInputStream();
            } else {
                this.out = new KJASOutputStream();
            }
            Main.debug("KIO connect(" + this.jobid + ") " + this.url);
            return;
        }
        this.connect_status = 0;
        jobs.remove(this.jobid);
        if (bl2) {
            if (!this.finished) {
                Main.protocol.sendDataCmd(this.jobid, 0);
            }
            Main.debug("KIO connect error " + this.url);
            throw new ConnectException("connection failed (not found)");
        }
        Main.debug("KIO connect timeout " + this.url);
        throw new IOException("connection failed (timeout)");
    }

    synchronized void disconnect() {
        if (this.connect_status == 0) {
            return;
        }
        Main.debug("KIO disconnect " + this.jobid);
        if (this.out != null) {
            try {
                this.out.flush();
            }
            catch (IOException iOException) {}
        }
        this.connect_status = 0;
        this.out = null;
        this.in = null;
        if (!this.finished) {
            Main.protocol.sendDataCmd(this.jobid, 0);
            jobs.remove(this.jobid);
        }
        this.notifyAll();
    }

    InputStream getInputStream() throws IOException {
        Main.debug("KIO getInputStream(" + this.jobid + ") " + this.url);
        return this.in;
    }

    OutputStream getOutputStream() throws IOException {
        Main.debug("KIO getOutputStream(" + this.jobid + ") " + this.url);
        return this.out;
    }

    private final /* synthetic */ void this() {
        this.connect_status = 0;
        this.jobid = null;
        this.data = new LinkedList();
        this.errorcode = 0;
        this.finished = false;
        this.onhold = false;
        this.request_data = false;
        this.out = null;
        this.in = null;
        this.in_buf = null;
        this.in_bufpos = 0;
        this.in_eof = false;
    }

    protected KIOConnection(URL uRL) {
        this.this();
        this.url = uRL;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class KJASInputStream
    extends InputStream {
        public int read() throws IOException {
            if (KIOConnection.this.getData(true)) {
                byte[] byArray = KIOConnection.this.in_buf;
                KIOConnection kIOConnection = KIOConnection.this;
                int n = kIOConnection.in_bufpos;
                kIOConnection.in_bufpos = n + 1;
                return 0xFF & byArray[n];
            }
            return -1;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (KIOConnection.this.getData(true)) {
                int n4 = KIOConnection.this.in_buf.length - KIOConnection.this.in_bufpos;
                if (n4 > n2) {
                    n4 = n2;
                }
                System.arraycopy(KIOConnection.this.in_buf, KIOConnection.this.in_bufpos, byArray, n, n4);
                n3 += n4;
                n += n4;
                KIOConnection kIOConnection = KIOConnection.this;
                kIOConnection.in_bufpos = kIOConnection.in_bufpos + n4;
                if ((n2 -= n4) > 0) continue;
            }
            return n3 > 0 ? n3 : -1;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int available() throws IOException {
            return KIOConnection.this.inAvailable();
        }

        public boolean markSupported() {
            return false;
        }

        public void close() throws IOException {
            KIOConnection.this.disconnect();
        }

        KJASInputStream() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class KJASOutputStream
    extends OutputStream {
        public void write(int n) throws IOException {
            byte[] byArray = new byte[]{(byte)n};
            this.write(byArray);
        }

        public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            KIOConnection.this.sendData(byArray2, false);
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void close() throws IOException {
            KIOConnection.this.disconnect();
        }

        public void flush() throws IOException {
            KIOConnection.this.checkConnected();
            KIOConnection.this.sendData(null, true);
        }

        KJASOutputStream() {
        }
    }
}

