/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.xsd2ecore.presentation;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.MissingResourceException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.mapping.xsd2ecore.XSD2EcoreFactory;
import org.eclipse.emf.mapping.xsd2ecore.XSD2EcorePackage;
import org.eclipse.emf.mapping.xsd2ecore.XSD2EcorePlugin;
import org.eclipse.emf.mapping.xsd2ecore.presentation.XSD2EcoreEditorPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class XSD2EcoreModelWizard
extends Wizard
implements INewWizard {
    protected XSD2EcorePackage xsD2EcorePackage = XSD2EcorePackage.eINSTANCE;
    protected XSD2EcoreFactory xsD2EcoreFactory = this.xsD2EcorePackage.getXSD2EcoreFactory();
    protected XSD2EcoreModelWizardNewFileCreationPage newFileCreationPage;
    protected XSD2EcoreModelWizardInitialObjectCreationPage initialObjectCreationPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(XSD2EcoreEditorPlugin.INSTANCE.getImage("full/wizban/NewXSD2Ecore")));
    }

    EObject createInitialModel() {
        EClass eClass = (EClass)this.xsD2EcorePackage.getEClassifier(this.initialObjectCreationPage.getInitialEClassName());
        EObject rootObject = this.xsD2EcoreFactory.create(eClass);
        return rootObject;
    }

    public boolean performFinish() {
        try {
            final IFile modelFile = this.getModelFile();
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        try {
                            ResourceSetImpl resourceSet = new ResourceSetImpl();
                            URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString());
                            Resource resource = resourceSet.createResource(fileURI);
                            EObject rootObject = XSD2EcoreModelWizard.this.createInitialModel();
                            if (rootObject != null) {
                                resource.getContents().add((Object)rootObject);
                            }
                            resource.save(Collections.EMPTY_MAP);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        progressMonitor.done();
                        throw throwable;
                    }
                    {
                        Object var6_9 = null;
                    }
                    progressMonitor.done();
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
            }
            catch (PartInitException exception) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)XSD2EcoreEditorPlugin.INSTANCE.getString("_UI_OpenEditorError_label"), (String)exception.getMessage());
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void addPages() {
        Object selectedElement;
        this.newFileCreationPage = new XSD2EcoreModelWizardNewFileCreationPage("Whatever", this.selection);
        this.newFileCreationPage.setTitle(XSD2EcoreEditorPlugin.INSTANCE.getString("_UI_XSD2EcoreModelWizard_label"));
        this.newFileCreationPage.setDescription(XSD2EcoreEditorPlugin.INSTANCE.getString("_UI_XSD2EcoreModelWizard_description"));
        this.newFileCreationPage.setFileName(String.valueOf(XSD2EcoreEditorPlugin.INSTANCE.getString("_UI_XSD2EcoreEditorFilenameDefaultBase")) + "." + XSD2EcoreEditorPlugin.INSTANCE.getString("_UI_XSD2EcoreEditorFilenameExtension"));
        this.addPage((IWizardPage)this.newFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());
                String defaultModelBaseFilename = XSD2EcoreEditorPlugin.INSTANCE.getString("_UI_XSD2EcoreEditorFilenameDefaultBase");
                String defaultModelFilenameExtension = XSD2EcoreEditorPlugin.INSTANCE.getString("_UI_XSD2EcoreEditorFilenameExtension");
                String modelFilename = String.valueOf(defaultModelBaseFilename) + "." + defaultModelFilenameExtension;
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = String.valueOf(defaultModelBaseFilename) + i + "." + defaultModelFilenameExtension;
                    ++i;
                }
                this.newFileCreationPage.setFileName(modelFilename);
            }
        }
        this.initialObjectCreationPage = new XSD2EcoreModelWizardInitialObjectCreationPage("Whatever2");
        this.initialObjectCreationPage.setTitle(XSD2EcoreEditorPlugin.INSTANCE.getString("_UI_XSD2EcoreModelWizard_label"));
        this.initialObjectCreationPage.setDescription(XSD2EcoreEditorPlugin.INSTANCE.getString("_UI_Wizard_initial_object_description"));
        this.addPage((IWizardPage)this.initialObjectCreationPage);
    }

    public IFile getModelFile() {
        return this.newFileCreationPage.getModelFile();
    }

    public class XSD2EcoreModelWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        protected IFile modelFile;

        public XSD2EcoreModelWizardNewFileCreationPage(String pageId, IStructuredSelection selection) {
            super(pageId, selection);
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String requiredExt = XSD2EcoreEditorPlugin.INSTANCE.getString("_UI_XSD2EcoreEditorFilenameExtension");
                String enteredExt = new Path(this.getFileName()).getFileExtension();
                if (enteredExt == null || !enteredExt.equals(requiredExt)) {
                    this.setErrorMessage(XSD2EcoreEditorPlugin.INSTANCE.getString("_WARN_FilenameExtension", new Object[]{requiredExt}));
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean performFinish() {
            this.modelFile = this.getModelFile();
            return true;
        }

        public IFile getModelFile() {
            return this.modelFile == null ? ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName())) : this.modelFile;
        }
    }

    public class XSD2EcoreModelWizardInitialObjectCreationPage
    extends WizardPage {
        protected String initialEClassName;
        protected CCombo initialObjectField;

        public XSD2EcoreModelWizardInitialObjectCreationPage(String pageId) {
            super(pageId);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label containerLabel = new Label(composite, 16384);
            containerLabel.setText(XSD2EcoreEditorPlugin.INSTANCE.getString("_UI_ModelObject"));
            data = new GridData();
            data.horizontalAlignment = 4;
            containerLabel.setLayoutData((Object)data);
            this.initialObjectField = new CCombo(composite, 2048);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.initialObjectField.setLayoutData((Object)data);
            ArrayList<String> eClasses = new ArrayList<String>();
            Iterator classifier = XSD2EcoreModelWizard.this.xsD2EcorePackage.getEClassifiers().iterator();
            while (classifier.hasNext()) {
                EClass eClass;
                EClassifier eClassifier = (EClassifier)classifier.next();
                if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract()) continue;
                eClasses.add(this.getLabel(eClass));
            }
            Collections.sort(eClasses, Collator.getInstance());
            Iterator i = eClasses.iterator();
            while (i.hasNext()) {
                String eClassName = (String)i.next();
                this.initialObjectField.add(eClassName);
            }
            this.initialObjectField.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ XSD2EcoreModelWizardInitialObjectCreationPage this$1;
                {
                    this.this$1 = xSD2EcoreModelWizardInitialObjectCreationPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.setPageComplete(this.this$1.isPageComplete());
                }
            });
            this.setControl((Control)composite);
        }

        public boolean isPageComplete() {
            if (super.isPageComplete()) {
                return this.initialObjectField.getSelectionIndex() != -1;
            }
            return false;
        }

        public boolean performFinish() {
            this.initialEClassName = this.getInitialEClassName();
            return true;
        }

        public String getInitialEClassName() {
            if (this.initialEClassName != null) {
                return this.initialEClassName;
            }
            String label = this.initialObjectField.getText();
            Iterator classifier = XSD2EcoreModelWizard.this.xsD2EcorePackage.getEClassifiers().iterator();
            while (classifier.hasNext()) {
                EClass eClass;
                EClassifier eClassifier = (EClassifier)classifier.next();
                if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract() || !this.getLabel(eClass).equals(label)) continue;
                return eClass.getName();
            }
            return label;
        }

        protected String getLabel(EClass eClass) {
            String name = eClass.getName();
            try {
                return XSD2EcorePlugin.INSTANCE.getString("_UI_" + name + "_type");
            }
            catch (MissingResourceException missingResourceException) {
                return name;
            }
        }
    }
}

