/***************************************************************************
                         ccallback.h  -  description
                             -------------------
    begin                : Thu Aug 1 2002
    copyright            : (C) 2002-2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CCALLBACK_H
#define CCALLBACK_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>
#include <dclib/core/cobject.h>
#include <dclib/core/clist.h>

class  DLL_EXPORT _CCallback : public CObject
{
public:
	/** */
	_CCallback() {};
	/** */
	virtual ~_CCallback() {};

	/** */
	virtual int notify( CObject * Sender, CObject * Object ) = 0;
};

template<class T> class DLL_EXPORT CCallback : public _CCallback {
public:
	/** */
	CCallback(T* object, int (T::*method)( CObject * Sender, CObject * Object ))
		: myObject(object),
		  myMethod(method)
	{}
	/** */
	virtual ~CCallback() {};

	/** */
	virtual int notify( CObject * Sender, CObject * Object )
	{
		return (myObject->*myMethod)( Sender, Object );
	}

	/** */
	T* myObject;
	/** */
	int (T::*myMethod)( CObject * Sender, CObject * Object );
};

#ifdef WIN32
template class DLL_EXPORT CList<_CCallback>;
template class DLL_EXPORT CThreadList<_CCallback>;
#endif

class DLL_EXPORT CCallbackList : public CObject
{
public:
	/** */
	CCallbackList();
	/** */
	virtual ~CCallbackList();

	/** */
	void AddCallback( _CCallback * callback );
	/** */
	void DelCallback( _CCallback * callback );
	/** */
	int notify( CObject * sender, CObject * object );

private:
	/** */
	CThreadList<_CCallback> * m_pCallbackList;
};

#endif
