/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import jde.debugger.Etc;
import jde.debugger.JDEException;
import jde.debugger.LispForm;
import jde.debugger.Rep;
import jde.debugger.command.DebugProcessCommand;

public class GetLocals
extends DebugProcessCommand {
    public void doCommand() throws JDEException {
        boolean weSuspendedThread = false;
        ThreadReference tRef = null;
        if (this.args.size() != 2) {
            throw new JDEException("Insufficient arguments");
        }
        try {
            Long uniqueID = Etc.safeGetLong(this.args.remove(0), "thread ID");
            int frameIndex = Etc.safeGetint(this.args.remove(0), "frame index");
            ObjectReference oRef = this.proc.getStore().get(uniqueID);
            if (oRef == null) {
                throw new JDEException("No such thread exists");
            }
            if (!(oRef instanceof ThreadReference)) {
                throw new JDEException("Object is not a thread");
            }
            tRef = (ThreadReference)oRef;
            if (!tRef.isSuspended()) {
                tRef.suspend();
                weSuspendedThread = true;
            }
            StackFrame frame = null;
            try {
                frame = tRef.frame(frameIndex);
            }
            catch (IncompatibleThreadStateException ex) {
                throw new JDEException("Thread is not suspended");
            }
            catch (IndexOutOfBoundsException ex) {
                throw new JDEException("Invalid frame");
            }
            catch (ObjectCollectedException ex) {
                throw new JDEException("The frame has already been garbage collected");
            }
            if (frame == null) {
                throw new JDEException("Error ascertaining frame");
            }
            LispForm localVariableValues = null;
            try {
                localVariableValues = Rep.getLocalVariableValueMapRep(frame.getValues(frame.visibleVariables()), this.proc.getStore());
            }
            catch (AbsentInformationException ex) {
                throw new JDEException("Local variable information not available: compile with -g");
            }
            catch (NativeMethodException ex) {
                throw new JDEException("Can't access local variables in native methods");
            }
            this.jde.signalCommandResult(this.procID, this.cmdID, localVariableValues);
            Object var11_13 = null;
            if (weSuspendedThread && tRef != null) {
                tRef.resume();
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (weSuspendedThread && tRef != null) {
                tRef.resume();
            }
            throw throwable;
        }
    }

    public Object clone() {
        return new GetLocals();
    }
}

