#ifdef __cplusplus
extern "C" {
#endif

/*
    This software may only be used by you under license from AT&T Corp.
    ("AT&T").  A copy of AT&T's Source Code Agreement is available at
    AT&T's Internet website having the URL:
    <http://www.research.att.com/sw/tools/graphviz/license/source.html>
    If you received this software without first entering into a license
    with AT&T, you have an infringing copy of this software and cannot use
    it without violating AT&T's intellectual property rights.
*/


#ifndef EMBED_GRAPH_H_
#define EMBED_GRAPH_H_

#ifdef __cplusplus

void embed_graph(vtx_data * graph, int n, int dim, DistType ** (&coords), int);
void center_coordinate(DistType ** coords, int n, int dim);
void PCA(DistType ** coords, int dim, int n, double ** (&new_coords), int new_dim);
void PCA(DistType ** coords, int dim, int n, double ** (&new_coords), int dim1, int dim2, bool recompute);
void PCA_orthog(DistType ** coords, int dim, int n, double ** (&new_coords), int new_dim, double * orthog);
void iterativePCA(DistType ** coords, int dim, int n, double ** (&new_coords));

#else
#include <defs.h>

extern void embed_graph(vtx_data * graph, int n, int dim, DistType ***, int);
extern void center_coordinate(DistType **, int, int);

#endif

#endif

#ifdef __cplusplus
}
#endif
