"""
$RCSfile: __init__.py,v $

The ZopeXMLMethods package is a Zope product.  

Author: Chip Morris <cmorris@arielpartners.com>
Modified by Philipp von Weitershausen <philikon@philikon.de>

$Id: __init__.py,v 1.15 2003/03/30 03:45:47 cstrong Exp $
"""

__cvstag__  = '$Name:  $'[6:-2]
__date__    = '$Date: 2003/03/30 03:45:47 $'[6:-2]
__version__ = '$Revision: 1.15 $'[10:-2]

import XSLTMethod
import CacheManager

from XSLTMethod import manage_addXSLTMethod, \
     manage_addXSLTMethodForm, addXSLTMethod
from CacheManager import manage_addXMLMethodCacheManagerForm, \
     manage_addXMLMethodCacheManager, addXMLMethodCacheManager

methods = { "availableProcessors": XSLTMethod.XSLTMethod.availableProcessors,
            "behaveLikeList":      XSLTMethod.XSLTMethod.behaveLikeList,
            "findCacheManager":    XSLTMethod.findCacheManager }

def initialize(context):
    """
    Initialize the ZopeXMLMethods product.  This makes the object appear
    in the Zope product list menu. initialize() is called by Zope when
    starting a Zope server.
    """
    try:
        context.registerClass( XSLTMethod.XSLTMethod,
                               constructors = ( manage_addXSLTMethodForm,
                                                manage_addXSLTMethod,
                                                addXSLTMethod),
                               icon = 'www/XSLTMethod.gif' )

        context.registerClass( CacheManager.CacheManager,
                               constructors = ( manage_addXMLMethodCacheManagerForm,
                                                manage_addXMLMethodCacheManager,
                                                addXMLMethodCacheManager),
                               icon = 'www/cache.gif' )

        context.registerHelp()

    except:
        import sys, traceback, string
        type, val, tb = sys.exc_info()
        sys.stderr.write(string.join(traceback.format_exception(type, val, tb), ''))
        del type, val, tb
