'\"
'\" Generated from file '/usr/obj/ports/tcllib-1.4/tcllib-1.4/modules/struct/struct_list.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2003 by Kevin B. Kenny. All rights reserved
'\"
'\" -*- tcl -*- doctools manpage
'\" $Id: struct_list.man,v 1.1 2003/04/15 17:44:51 andreas_kupries Exp $
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2000/03/06 21:34:53 ericm Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "list" n 1.2.2 struct "Tcl Data Structures"
.BS
.SH "NAME"
list \- Procedures for manipulating lists
.SH "SYNOPSIS"
package require \fBTcl  8.0\fR
.sp
package require \fBstruct  ?1.3?\fR
.sp
\fB::struct::list\fR \fBlongestCommonSubsequence\fR \fIsequence1\fR \fIsequence2\fR ?\fImaxOccurs\fR?\fR
.sp
\fB::struct::list\fR \fBlongestCommonSubsequence2\fR \fIsequence1 sequence2\fR ?\fImaxOccurs\fR?\fR
.sp
\fB::struct::list\fR \fBlcsInvert\fR \fIlcsData\fR \fIlen1\fR \fIlen2\fR\fR
.sp
\fB::struct::list\fR \fBlcsInvert2\fR \fIlcs1\fR \fIlcs2\fR \fIlen1\fR \fIlen2\fR\fR
.sp
\fB::struct::list\fR \fBlcsInvertMerge\fR \fIlcsData\fR \fIlen1\fR \fIlen2\fR\fR
.sp
\fB::struct::list\fR \fBlcsInvertMerge2\fR \fIlcs1\fR \fIlcs2\fR \fIlen1\fR \fIlen2\fR\fR
.sp
\fB::struct::list\fR \fBreverse\fR \fIsequence\fR\fR
.sp
\fB::struct::list\fR \fBassign\fR \fIsequence\fR ?\fIvarname\fR?...\fR
.sp
\fB::struct::list\fR \fBflatten\fR ?\fB-full\fR? ?\fB--\fR? \fIsequence\fR\fR
.sp
\fB::struct::list\fR \fBmap\fR \fIsequence\fR \fIcmdprefix\fR\fR
.sp
\fB::struct::list\fR \fBfold\fR \fIsequence\fR \fIinitialvalue\fR \fIcmdprefix\fR\fR
.sp
\fB::struct::list\fR \fBiota\fR \fIn\fR\fR
.sp
\fB::struct::list\fR \fBequal\fR \fIa\fR \fIb\fR\fR
.sp
\fB::struct::list\fR \fBrepeat\fR \fIvalue\fR \fIsize\fR...\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The \fB::struct::list\fR namespace contains several useful commands
for processing Tcl lists. Generally speaking, they implement
algorithms more complex or specialized than the ones provided by Tcl
itself.
.PP
It exports only a single command, \fBstruct::list\fR. All
functionality provided here can be reached through a subcommand of
this command.
.SH "COMMANDS"
.TP
\fB::struct::list\fR \fBlongestCommonSubsequence\fR \fIsequence1\fR \fIsequence2\fR ?\fImaxOccurs\fR?\fR
Returns the longest common subsequence of elements in the two lists
\fIsequence1\fR and \fIsequence2\fR. If the \fImaxOccurs\fR parameter
is provided, the common subsequence is restricted to elements that
occur no more than \fImaxOccurs\fR times in \fIsequence2\fR.
.sp
The return value is a list of two lists of equal length. The first
sublist is of indices into \fIsequence1\fR, and the second sublist is
of indices into \fIsequence2\fR.  Each corresponding pair of indices
corresponds to equal elements in the sequences; the sequence returned
is the longest possible.
.TP
\fB::struct::list\fR \fBlongestCommonSubsequence2\fR \fIsequence1 sequence2\fR ?\fImaxOccurs\fR?\fR
Returns an approximation to the longest common sequence of elements in
the two lists \fIsequence1\fR and \fIsequence2\fR.
If the \fImaxOccurs\fR parameter is omitted, the subsequence computed
is exactly the longest common subsequence; otherwise, the longest
common subsequence is approximated by first determining the longest
common sequence of only those elements that occur no more than
\fImaxOccurs\fR times in \fIsequence2\fR, and then using that result
to align the two lists, determining the longest common subsequences of
the sublists between the two elements.
.sp
As with \fBlongestCommonSubsequence\fR, the return value is a list
of two lists of equal length.  The first sublist is of indices into
\fIsequence1\fR, and the second sublist is of indices into
\fIsequence2\fR.  Each corresponding pair of indices corresponds to
equal elements in the sequences.  The sequence approximates the
longest common subsequence.
.TP
\fB::struct::list\fR \fBlcsInvert\fR \fIlcsData\fR \fIlen1\fR \fIlen2\fR\fR
This command takes a description of a longest common subsequence
(\fIlcsData\fR), inverts it, and returns the result. Inversion means
here that as the input describes which parts of the two sequences are
identical the output describes the differences instead.
.sp
To be fully defined the lengths of the two sequences have to be known
and are specified through \fIlen1\fR and \fIlen2\fR.
.sp
The result is a list where each element describes one chunk of the
differences between the two sequences. This description is a list
containing three elements, a type and two pairs of indices into
\fIsequence1\fR and \fIsequence2\fR respectively, in this order.
The type can be one of three values:
.RS
.TP
\fBadded\fR
Describes an addition. I.e. items which are missing in \fIsequence1\fR
can be found in \fIsequence2\fR.
The pair of indices into \fIsequence1\fR describes where the added
range had been expected to be in \fIsequence1\fR. The first index
refers to the item just before the added range, and the second index
refers to the item just after the added range.
The pair of indices into \fIsequence2\fR describes the range of items
which has been added to it. The first index refers to the first item
in the range, and the second index refers to the last item in the
range.
.TP
\fBdeleted\fR
Describes a deletion. I.e. items which are in \fIsequence1\fR are
missing from \fIsequence2\fR.
The pair of indices into \fIsequence1\fR describes the range of items
which has been deleted. The first index refers to the first item in
the range, and the second index refers to the last item in the range.
The pair of indices into \fIsequence2\fR describes where the deleted
range had been expected to be in \fIsequence2\fR. The first index
refers to the item just before the deleted range, and the second index
refers to the item just after the deleted range.
.TP
\fBchanged\fR
Describes a general change. I.e a range of items in \fIsequence1\fR
has been replaced by a different range of items in \fIsequence2\fR.
The pair of indices into \fIsequence1\fR describes the range of items
which has been replaced. The first index refers to the first item in
the range, and the second index refers to the last item in the range.
The pair of indices into \fIsequence2\fR describes the range of items
replacing the original range. Again the first index refers to the
first item in the range, and the second index refers to the last item
in the range.
.RE
.sp
.nf
    sequence 1 = {a b r a c a d a b r a}
    lcs 1      =   {1 2   4 5     8 9 10}
    lcs 2      =   {0 1   3 4     5 6 7}
    sequence 2 =   {b r i c a     b r a c}

    Inversion  = {{deleted  {0  0} {-1 0}}
                  {changed  {3  3}  {2 2}}
                  {deleted  {6  7}  {4 5}}
                  {added   {10 11}  {8 8}}}
.fi
\fINotes:\fR
.sp
.RS
.IP \(bu
An index of \fB-1\fR in a \fIdeleted\fR chunk refers to just before
the first element of the second sequence.
.IP \(bu
Also an index equal to the length of the first sequence in an
\fIadded\fR chunk refers to just behind the end of the sequence.
.RE
.TP
\fB::struct::list\fR \fBlcsInvert2\fR \fIlcs1\fR \fIlcs2\fR \fIlen1\fR \fIlen2\fR\fR
Similar to \fBlcsInvert\fR. Instead of directly taking the result
of a call to \fBlongestCommonSubsequence\fR this subcommand expects
the indices for the two sequences in two separate lists.
.TP
\fB::struct::list\fR \fBlcsInvertMerge\fR \fIlcsData\fR \fIlen1\fR \fIlen2\fR\fR
Similar to \fBlcsInvert\fR. It returns essentially the same
structure as that command, except that it may contain chunks of type
\fBunchanged\fR too.
.sp
These new chunks describe the parts which are unchanged between the
two sequences. This means that the result of this command describes
both the changed and unchanged parts of the two sequences in one
structure.
.sp
.nf
    sequence 1 = {a b r a c a d a b r a}
    lcs 1      =   {1 2   4 5     8 9 10}
    lcs 2      =   {0 1   3 4     5 6 7}
    sequence 2 =   {b r i c a     b r a c}

    Inversion/Merge  = {{deleted   {0  0} {-1 0}}
                        {unchanged {1  2}  {0 1}}
                        {changed   {3  3}  {2 2}}
                        {unchanged {4  5}  {3 4}}
                        {deleted   {6  7}  {4 5}}
                        {unchanged {8 10}  {5 7}}
                        {added    {10 11}  {8 8}}}
.fi
.TP
\fB::struct::list\fR \fBlcsInvertMerge2\fR \fIlcs1\fR \fIlcs2\fR \fIlen1\fR \fIlen2\fR\fR
Similar to \fBlcsInvertMerge\fR. Instead of directly taking the
result of a call to \fBlongestCommonSubsequence\fR this subcommand
expects the indices for the two sequences in two separate lists.
.TP
\fB::struct::list\fR \fBreverse\fR \fIsequence\fR\fR
The subcommand takes a single \fIsequence\fR as argument and returns a new
sequence containing the elements of the input sequence in reverse
order.
.TP
\fB::struct::list\fR \fBassign\fR \fIsequence\fR ?\fIvarname\fR?...\fR
The subcommand assigns the first \fBn\fR elements of the input
\fIsequence\fR to the zero or more variables whose names were listed
after the sequence, where \fBn\fR is the number of specified
variables.
.sp
If there are more variables specified than there are elements in the
\fIsequence\fR the empty string will be assigned to the superfluous
variables.
.sp
If there are more elements in the \fIsequence\fR than variable names
specified the subcommand returns a list containing the unassigned
elements. Else an empty list is returned.
.nf
    tclsh> ::struct::list assign {a b c d e} foo bar
    c d e
    tclsh> set foo
    a
    tclsh> set bar
    b
.fi
.TP
\fB::struct::list\fR \fBflatten\fR ?\fB-full\fR? ?\fB--\fR? \fIsequence\fR\fR
The subcommand takes a single \fIsequence\fR and returns a new
sequence where one level of nesting was removed from the input
sequence. In other words, the sublists in the input sequence are
replaced by their elements.
.sp
The subcommand will remove any nesting it finds if the option
\fB-full\fR is specified.
.nf
    tclsh> ::struct::list flatten {1 2 3 {4 5} {6 7} {{8 9}} 10}
    1 2 3 4 5 6 7 {8 9} 10
    tclsh> ::struct::list flatten -full {1 2 3 {4 5} {6 7} {{8 9}} 10}
    1 2 3 4 5 6 7 8 9 10
.fi
.TP
\fB::struct::list\fR \fBmap\fR \fIsequence\fR \fIcmdprefix\fR\fR
The subcommand takes a \fIsequence\fR to operate on and a command
prefix (\fIcmdprefix\fR) specifying an operation, applies the command
prefix to each element of the sequence and returns a sequence
consisting of the results of that application.
.sp
The command prefix will be evaluated with a single word appended to
it. The evaluation takes place in the context of the caller of the
subcommand.
.sp
.nf
    tclsh> # squaring all elements in a list

    tclsh> proc sqr {x} {expr {$x*$x}}
    tclsh> ::struct::list map {1 2 3 4 5} sqr
    1 4 9 16 25

    tclsh> # Retrieving the second column from a matrix
    tclsh> # given as list of lists.

    tclsh> proc projection {n list} {::lindex $list $n}
    tclsh> ::struct::list map {{a b c} {1 2 3} {d f g}} {projection 1}
    b 2 f
.fi
.TP
\fB::struct::list\fR \fBfold\fR \fIsequence\fR \fIinitialvalue\fR \fIcmdprefix\fR\fR
The subcommand takes a \fIsequence\fR to operate on, an arbitrary
string \fIinitial value\fR and a command prefix (\fIcmdprefix\fR)
specifying an operation.
.sp
The command prefix will be evaluated with two words appended to
it. The second of these words will always be an element of the
sequence. The evaluation takes place in the context of the caller of
the subcommand.
.sp
It then reduces the sequence into a single value through repeated
application of the command prefix and returns that value. This
reduction is done by
.RS
.TP
\fB1\fR
Application of the command to the initial value and the first element
of the list.
.TP
\fB2\fR
Application of the command to the result of the last call and the
second element of the list.
.TP
\fB...\fR
.TP
\fBi\fR
Application of the command to the result of the last call and the
\fBi\fR'th element of the list.
.TP
\fB...\fR
.TP
\fBend\fR
Application of the command to the result of the last call and the last
element of the list. The result of this call is returned as the result
of the subcommand.
.RE
.sp
.nf
    tclsh> # summing the elements in a list.
    tclsh> proc + {a b} {expr {$a + $b}}
    tclsh> ::listx fold {1 2 3 4 5} 0 +
    15
.fi
.TP
\fB::struct::list\fR \fBiota\fR \fIn\fR\fR
The subcommand returns a list containing the integer numbers
in the range \fB[0,n)\fR. The element at index \fBi\fR
of the list contain the number \fBi\fR.
.sp
For "\fIn\fR == \fB0\fR" an empty list will be returned.
.TP
\fB::struct::list\fR \fBequal\fR \fIa\fR \fIb\fR\fR
The subcommand compares the two lists \fIa\fR and \fIb\fR for
equality. In other words, they have to be of the same length and have
to contain the same elements in the same order. If an element is a
list the same definition of equality applies recursively.
.sp
A boolean vlaue will be returned as the result of the command.
This value will be \fBtrue\fR if the two lists are equal, and
\fBfalse\fR else.
.TP
\fB::struct::list\fR \fBrepeat\fR \fIvalue\fR \fIsize\fR...\fR
The subcommand creates a (nested) list containing the \fIvalue\fR in
all positions. The exact size and degree of nesting is determined by
the \fIsize\fR arguments, all of which have to be integer numbers
greater than or equal to zero.
.sp
A single argument \fIsize\fR which is a list of more than one element
will be treated as if more than argument \fIsize\fR was specified.
.sp
If only one argument \fIsize\fR is present the returned list will not
be nested, of length \fIsize\fR and contain \fIvalue\fR in all
positions.
If more than one \fIsize\fR argument is present the returned
list will be nested, and of the length specified by the last
\fIsize\fR argument given to it. The elements of that list
are defined as the result of \fBRepeat\fR for the same arguments,
but with the last \fIsize\fR value removed.
.sp
An empty list will be returned if no \fIsize\fR arguments are present.
.sp
.nf
    tclsh> lrepeat  0 3 4
    {0 0 0} {0 0 0} {0 0 0} {0 0 0}
    tclsh> lrepeat  0 {3 4}
    {0 0 0} {0 0 0} {0 0 0} {0 0 0}
    tclsh> lrepeat  0 {3 4 5}
    {{0 0 0} {0 0 0} {0 0 0} {0 0 0}} {{0 0 0} {0 0 0} {0 0 0} {0 0 0}} {{0 0 0} {0 0 0} {0 0 0} {0 0 0}} {{0 0 0} {0 0 0} {0 0 0} {0 0 0}} {{0 0 0} {0 0 0} {0 0 0} {0 0 0}}
.fi
.SH "LONGEST COMMON SUBSEQUENCE AND FILE COMPARISON"
.PP
The \fBlongestCommonSubsequence\fR subcommand forms the core of a
flexible system for doing differential comparisons of files, similar
to the capability offered by the Unix command \fBdiff\fR.
While this procedure is quite rapid for many tasks of file comparison,
its performance degrades severely if \fIsequence2\fR contains many
equal elements (as, for instance, when using this procedure to compare
two files, a quarter of whose lines are blank.  This drawback is
intrinsic to the algorithm used (see the Reference for details).
.PP
One approach to dealing with the performance problem that is sometimes
effective in practice is arbitrarily to exclude elements that appear
more than a certain number of times.
This number is provided as the \fImaxOccurs\fR parameter.  If frequent
lines are excluded in this manner, they will not appear in the common
subsequence that is computed; the result will be the longest common
subsequence of infrequent elements.
The procedure \fBlongestCommonSubsequence2\fR implements this
heuristic.
It functions as a wrapper around \fBlongestCommonSubsequence\fR; it
computes the longest common subsequence of infrequent elements, and
then subdivides the subsequences that lie between the matches to
approximate the true longest common subsequence.
.SH "REFERENCES"
J. W. Hunt and M. D. McIlroy, "An algorithm for differential
file comparison," Comp. Sci. Tech. Rep. #41, Bell Telephone
Laboratories (1976). Available on the Web at the second
author's personal site: \fIhttp://www.cs.dartmouth.edu/~doug/\fR
.SH "KEYWORDS"
assign, common, comparison, diff, differential, equal, equality, flatten, folding, list, longest common subsequence, map, reduce, repeating, repetition, reverse, subsequence
.SH "COPYRIGHT"
.nf
Copyright (c) 2003 by Kevin B. Kenny. All rights reserved
.fi