<?php

$block_name = _("Calendar Summary");

/**
 * Horde_Block_Kronolith_summary:: Implementation of the Horde_Block API to
 * display a summary of calendar items.
 *
 * $Horde: kronolith/lib/Block/summary.php,v 1.41.2.3 2005/05/16 23:10:42 jan Exp $
 *
 * @package Horde_Block
 */
class Horde_Block_Kronolith_summary extends Horde_Block {

    var $_app = 'kronolith';

    function _params()
    {
        @define('KRONOLITH_BASE', dirname(__FILE__) . '/../..');
        require_once KRONOLITH_BASE . '/lib/base.php';

        $params = array('calendar' => array('name' => _("Calendar"),
                                            'type' => 'enum',
                                            'default' => '__all'));
        $params['calendar']['values']['__all'] = _("All Visible");
        foreach (Kronolith::listCalendars() as $id => $cal) {
            $params['calendar']['values'][$id] = $cal->get('name');
        }

        return $params;
    }

    /**
     * The title to go in this block.
     *
     * @return string   The title text.
     */
    function _title()
    {
        global $registry;

        return Horde::link(Horde::url($registry->getInitialPage(), true), $registry->get('name')) . $registry->get('name') . '</a> :: ' . Horde::link(Horde::applicationUrl('addevent.php', true), _("New Event")) . Horde::img('new.png', _("New Event"), '', Horde::url($registry->getImageDir(), true, -1)) . ' ' . _("New Event") . '</a>';
    }

    /**
     * The content to go in this block.
     *
     * @return string   The content
     */
    function _content()
    {
        global $registry, $prefs;
        require_once dirname(__FILE__) . '/../base.php';
        require_once KRONOLITH_BASE . '/lib/Day.php';
        require_once 'Horde/Prefs/CategoryManager.php';

        Horde::addScriptFile('tooltip.js', 'horde', true);

        $now = time();
        $today = date('j');
        $cManager = &new Prefs_CategoryManager();
        $colors = $cManager->colors();

        $startDate = &new Horde_Date(array('year' => date('Y'),
                                           'month' => date('n'),
                                           'mday' => date('j')));
        $endDate = &new Horde_Date(array('year' => date('Y'),
                                         'month' => date('n'),
                                         'mday' => date('j') + $prefs->getValue('summary_days')));
        $endDate->correct();

        if (isset($this->_params['calendar']) &&
            $this->_params['calendar'] != '__all') {
            $allevents = Kronolith::listEvents($startDate,
                                               $endDate,
                                               array($this->_params['calendar']));
        } else {
            $allevents = Kronolith::listEvents($startDate,
                                               $endDate,
                                               $GLOBALS['display_calendars']);
        }

        $html = '';
        $iMax = $today + $prefs->getValue('summary_days');
        $firstday = true;
        for ($i = $today; $i < $today + $iMax; $i++) {
            $day = &new Kronolith_Day(date('n'), $i);
            if (empty($allevents[$day->getStamp()])) {
                continue;
            }

            $events = &$allevents[$day->getStamp()];
            $firstevent = true;
            $htmldays = array();

            $today12am = mktime(0, 0, 0,
                                $day->month,
                                $day->mday,
                                $day->year);
            $tomorrow12am = mktime(0, 0, 0,
                                   $day->month,
                                   $day->mday + 1,
                                   $day->year);
            foreach ($events as $event) {
                if (!$event->hasRecurType(KRONOLITH_RECUR_NONE)) {
                    $event->start = &new Horde_Date(
                        array('hour' => $event->start->hour,
                              'min' => $event->start->min,
                              'sec' => $event->start->sec,
                              'month' => $day->month,
                              'mday' => $day->mday,
                              'year' => $day->year));
                    $event->end = &new Horde_Date($event->start->timestamp() +
                                                  ($event->durMin * 60));
                } else {
                    if ($event->start->timestamp() < $today12am) {
                        $event->start = &new Horde_Date($today12am);
                    }
                    if ($event->end->timestamp() >= $tomorrow12am) {
                        $event->end = &new Horde_Date($tomorrow12am);
                    }
                }
                if ($event->end->timestamp() < $now) continue;
                if ($prefs->getValue('summary_alarms') && !$event->alarm) continue;
                if ($firstevent) {
                    if (!$firstday) {
                        $html .= '<tr><td colspan="3" style="font-size:2px;">&nbsp;</td></tr>';
                    }
                    $html .= '<tr><td colspan="3" class="control"><b>';
                    if ($day->isToday()) {
                        $dayname = _("Today");
                    } elseif ($day->isTomorrow()) {
                        $dayname = _("Tomorrow");
                    } elseif ($day->diff() < 7) {
                        $dayname = strftime('%A', $day->getStamp());
                    } else {
                        $dayname = strftime($prefs->getValue('date_format'),
                                            $day->getStamp());
                    }
                    $daylink = Horde::applicationUrl('day.php');
                    $daylink = Util::addParameter($daylink,
                                                  'timestamp',
                                                  $day->getStamp());
                    $html .= Horde::link($daylink, sprintf(_("Goto %s"),
                                                           $dayname));
                    $html .= $dayname . '</a></b></td></tr>';
                    $firstevent = false;
                    $firstday = false;
                }
                $htmlday = '<tr><td class="text" nowrap="nowrap" valign="top">';
                if ($event->start->timestamp() < $now &&
                    $event->end->timestamp() > $now) {
                    $htmlday .= '<b>';
                }

                if ($event->start->hour != 0 ||
                    $event->start->min != 0 ||
                    (($event->end->timestamp() - $event->start->timestamp()) %
                     (24 * 60 * 60)) != 0) {
                    if ($prefs->getValue('twentyFour')) {
                        $time  = date('G:i', $event->start->timestamp()) . '-';
                        $time .= date('G:i', $event->end->timestamp());
                    } else {
                        $time  = date('g:i A', $event->start->timestamp()) . '-';
                        $time .= date('g:i A', $event->end->timestamp());
                    }
                } else {
                    $time = _("All day event");
                }

                $text = $event->getTitle();
                if ($location = $event->getLocation()) {
                    $text .= ' (' . $location . ')';
                }
                $htmlday .= $time;
                if ($event->start->timestamp() < $now &&
                    $event->end->timestamp() > $now) {
                    $htmlday .= '</b>';
                }

                $categoryColor = isset($colors[$event->getCategory()])
                    ? $colors[$event->getCategory()]
                    : $colors['_default_'];
                $htmlday .= '</td><td class="text">&nbsp;&nbsp;&nbsp;</td>' .
                    '<td class="block-eventbox" style="background-color: ' .
                    $categoryColor . '; ' . 'border-color: ' .
                    Kronolith::borderColor($categoryColor) . ';" valign="top">';

                if ($event->start->timestamp() < $now &&
                    $event->end->timestamp() > $now) {
                    $htmlday .= '<b>';
                }
                $htmlday .= $event->getLink(null, true);
                if ($event->start->timestamp() < $now &&
                    $event->end->timestamp() > $now) {
                    $html .= '</b>';
                }
                $htmlday .= '</td></tr>';
                $htmldays[] = $htmlday;
            }

            $html .= implode("\n", $htmldays);
        }

        if (empty($html)) {
            return '<em>' . _("No events to display") . '</em>';
        }

        return '<table cellspacing="0" width="100%">' . $html . '</table>';
    }

}
