/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.mail.internet.MailDateParser;

public class MailDateFormat
extends SimpleDateFormat {
    static boolean debug;
    private static TimeZone tz;
    private static Calendar cal;

    public MailDateFormat() {
        super("EEE, d MMM yyyy HH:mm:ss 'XXXXX' (z)", Locale.US);
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        int n = stringBuffer.length();
        super.format(date, stringBuffer, fieldPosition);
        int n2 = 0;
        n2 = n + 25;
        while (stringBuffer.charAt(n2) != 'X') {
            ++n2;
        }
        this.calendar.clear();
        this.calendar.setTime(date);
        int n3 = this.calendar.get(15) + this.calendar.get(16);
        if (n3 < 0) {
            stringBuffer.setCharAt(n2++, '-');
            n3 = -n3;
        } else {
            stringBuffer.setCharAt(n2++, '+');
        }
        int n4 = n3 / 60 / 1000;
        int n5 = n4 / 60;
        int n6 = n4 % 60;
        stringBuffer.setCharAt(n2++, Character.forDigit(n5 / 10, 10));
        stringBuffer.setCharAt(n2++, Character.forDigit(n5 % 10, 10));
        stringBuffer.setCharAt(n2++, Character.forDigit(n6 / 10, 10));
        stringBuffer.setCharAt(n2++, Character.forDigit(n6 % 10, 10));
        return stringBuffer;
    }

    public Date parse(String string, ParsePosition parsePosition) {
        return MailDateFormat.parseDate(string.toCharArray(), parsePosition, this.isLenient());
    }

    private static Date parseDate(char[] cArray, ParsePosition parsePosition, boolean bl) {
        try {
            MailDateParser mailDateParser;
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            block11: {
                n7 = -1;
                n6 = -1;
                n5 = -1;
                n4 = 0;
                n3 = 0;
                n2 = 0;
                n = 0;
                mailDateParser = new MailDateParser(cArray);
                mailDateParser.skipUntilNumber();
                n7 = mailDateParser.parseNumber();
                if (!mailDateParser.skipIfChar('-')) {
                    mailDateParser.skipWhiteSpace();
                }
                n6 = mailDateParser.parseMonth();
                if (!mailDateParser.skipIfChar('-')) {
                    mailDateParser.skipWhiteSpace();
                }
                if ((n5 = mailDateParser.parseNumber()) < 50) {
                    n5 += 2000;
                } else if (n5 < 100) {
                    n5 += 1900;
                }
                mailDateParser.skipWhiteSpace();
                n4 = mailDateParser.parseNumber();
                mailDateParser.skipChar(':');
                n3 = mailDateParser.parseNumber();
                if (mailDateParser.skipIfChar(':')) {
                    n2 = mailDateParser.parseNumber();
                }
                try {
                    mailDateParser.skipWhiteSpace();
                    n = mailDateParser.parseTimeZone();
                }
                catch (ParseException parseException) {
                    if (!debug) break block11;
                    System.out.println("No timezone? : '" + cArray + "'");
                }
            }
            parsePosition.setIndex(mailDateParser.getIndex());
            Date date = MailDateFormat.ourUTC(n5, n6, n7, n4, n3, n2, n, bl);
            return date;
        }
        catch (Exception exception) {
            if (debug) {
                System.out.println("Bad date: '" + cArray + "'");
                exception.printStackTrace();
            }
            parsePosition.setIndex(1);
            return null;
        }
    }

    private static synchronized Date ourUTC(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        cal.clear();
        cal.setLenient(bl);
        cal.set(1, n);
        cal.set(2, n2);
        cal.set(5, n3);
        cal.set(11, n4);
        cal.set(12, n5 + n7);
        cal.set(13, n6);
        return cal.getTime();
    }

    public void setCalendar(Calendar calendar) {
        throw new RuntimeException("Method setCalendar() shouldn't be called");
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        throw new RuntimeException("Method setNumberFormat() shouldn't be called");
    }

    static {
        tz = TimeZone.getTimeZone("GMT");
        cal = new GregorianCalendar(tz);
    }
}

