/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.text.Bidi;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.text.BidiInfo;
import org.eclipse.draw2d.text.FlowFigure;
import org.eclipse.draw2d.text.FlowUtilities;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.TextLayout;

public final class BidiProcessor {
    private static final boolean isMacOS = SWT.getPlatform().equals("carbon");
    public static final BidiProcessor INSTANCE = new BidiProcessor();
    private StringBuffer bidiText;
    private List list = new ArrayList();
    private int orientation = 0x2000000;

    private BidiProcessor() {
    }

    public void add(FlowFigure fig, String str) {
        this.list.add(new BidiEntry(fig, this.bidiText.length(), str.length()));
        this.bidiText.append(str);
    }

    public void add(FlowFigure fig, char c) {
        this.list.add(new BidiEntry(fig, this.bidiText.length(), 1));
        this.bidiText.append(c);
    }

    public void addControlChar(char c) {
        this.bidiText.append(c);
    }

    private void assignResults(int[] levels) {
        BidiEntry prevEntry = null;
        BidiEntry entry = null;
        BidiInfo prevInfo = null;
        BidiInfo info = null;
        int end = 2;
        int start = 0;
        int i = 0;
        while (i < this.list.size()) {
            int[] levelInfo;
            entry = (BidiEntry)this.list.get(i);
            info = new BidiInfo();
            while (levels[end] < entry.end) {
                end += 2;
            }
            if (end == start) {
                levelInfo = new int[1];
                levelInfo[0] = prevInfo != null ? prevInfo.levelInfo[prevInfo.levelInfo.length - 1] : (this.orientation == 0x2000000 ? 0 : 1);
            } else {
                levelInfo = new int[end - start - 1];
                System.arraycopy(levels, start + 1, levelInfo, 0, levelInfo.length);
            }
            int j = 1;
            while (j < levelInfo.length) {
                int n = j;
                levelInfo[n] = levelInfo[n] - entry.begin;
                j += 2;
            }
            info.levelInfo = levelInfo;
            if (prevEntry != null) {
                if (levels[start] < entry.begin && levels[start + 1] % 2 == 1 && this.isJoiner(entry.begin) && this.isPrecedingJoiner(entry.begin)) {
                    info.leadingJoiner = true;
                    prevInfo.trailingJoiner = true;
                }
                prevEntry.fig.setBidiInfo(prevInfo);
            }
            prevEntry = entry;
            prevInfo = info;
            start = entry.end == levels[end] ? end : end - 2;
            ++i;
        }
        if (entry != null) {
            entry.fig.setBidiInfo(info);
        }
    }

    private boolean isJoiner(int begin) {
        return begin < this.bidiText.length() && this.isJoiningCharacter(this.bidiText.charAt(begin));
    }

    private boolean isJoiningCharacter(char c) {
        return Character.getDirectionality(c) == 2 || c == '\u200d';
    }

    private boolean isPrecedingJoiner(int begin) {
        return begin > 0 && this.isJoiningCharacter(this.bidiText.charAt(begin - 1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process() {
        block14: {
            block13: {
                try {
                    block16: {
                        block15: {
                            if (this.bidiText.length() == 0) break block15;
                            if (!isMacOS) break block16;
                        }
                        Object var9_1 = null;
                        this.bidiText = null;
                        this.list.clear();
                        return;
                    }
                    char[] chars = new char[this.bidiText.length()];
                    this.bidiText.getChars(0, this.bidiText.length(), chars, 0);
                    if (this.orientation != 0x4000000 && !Bidi.requiresBidi(chars, 0, chars.length - 1)) {
                        break block13;
                    }
                    int[] levels = new int[15];
                    TextLayout layout = FlowUtilities.getTextLayout();
                    layout.setOrientation(this.orientation);
                    layout.setText(this.bidiText.toString());
                    int j = 0;
                    int prevLevel = -1;
                    int offset = 0;
                    while (true) {
                        if (offset >= chars.length) {
                            levels[j++] = offset;
                            if (j != levels.length) {
                                int[] newLevels = new int[j];
                                System.arraycopy(levels, 0, newLevels, 0, j);
                                levels = newLevels;
                            }
                            this.assignResults(levels);
                            layout.setOrientation(0x2000000);
                            break block14;
                        }
                        int newLevel = layout.getLevel(offset);
                        if (newLevel != prevLevel) {
                            if (j + 3 > levels.length) {
                                int[] temp = levels;
                                levels = new int[levels.length * 2 + 1];
                                System.arraycopy(temp, 0, levels, 0, temp.length);
                            }
                            levels[j++] = offset;
                            levels[j++] = newLevel;
                            prevLevel = newLevel;
                        }
                        ++offset;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_3 = null;
                    this.bidiText = null;
                    this.list.clear();
                    throw throwable;
                }
            }
            Object var9_2 = null;
            this.bidiText = null;
            this.list.clear();
            return;
        }
        Object var9_4 = null;
        this.bidiText = null;
        this.list.clear();
    }

    public void setOrientation(int newOrientation) {
        this.bidiText = new StringBuffer();
        this.list.clear();
        this.orientation = newOrientation;
    }

    private static class BidiEntry {
        int begin;
        int end;
        FlowFigure fig;

        BidiEntry(FlowFigure fig, int offset, int length) {
            this.fig = fig;
            this.begin = offset;
            this.end = offset + length;
        }
    }
}

