/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.sdo.presentation;

import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.SDOFactory;
import org.eclipse.emf.ecore.sdo.SDOPackage;
import org.eclipse.emf.ecore.sdo.impl.DynamicEDataObjectImpl;
import org.eclipse.emf.ecore.sdo.presentation.SDOEditorPlugin;
import org.eclipse.emf.ecore.sdo.provider.SDOEditPlugin;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class SDOModelWizard
extends Wizard
implements INewWizard {
    protected SDOPackage sdoPackage = SDOPackage.eINSTANCE;
    protected SDOFactory sdoFactory = this.sdoPackage.getSDOFactory();
    protected SDOModelWizardNewFileCreationPage newFileCreationPage;
    protected SDOModelWizardInitialObjectCreationPage initialObjectCreationPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected List initialObjectNames;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(SDOEditorPlugin.INSTANCE.getString("_UI_Wizard_label"));
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(SDOEditorPlugin.INSTANCE.getImage("full/wizban/NewSDO")));
    }

    protected Collection getInitialObjectNames() {
        if (this.initialObjectNames == null) {
            this.initialObjectNames = new ArrayList();
            Iterator classifiers = this.sdoPackage.getEClassifiers().iterator();
            while (classifiers.hasNext()) {
                EClass eClass;
                EClassifier eClassifier = (EClassifier)classifiers.next();
                if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract()) continue;
                this.initialObjectNames.add(eClass.getName());
            }
            Collections.sort(this.initialObjectNames, Collator.getInstance());
        }
        return this.initialObjectNames;
    }

    protected EObject createInitialModel() {
        EClass eClass = (EClass)this.sdoPackage.getEClassifier(this.initialObjectCreationPage.getInitialObjectName());
        EObject rootObject = this.sdoFactory.create(eClass);
        return rootObject;
    }

    public boolean performFinish() {
        try {
            final IFile modelFile = this.getModelFile();
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        try {
                            EDataGraph eDataGraph = SDOModelWizard.this.initialObjectCreationPage.createRootObject();
                            URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString());
                            eDataGraph.getDataGraphResource().setURI(fileURI);
                            HashMap<String, String> options = new HashMap<String, String>();
                            options.put("ENCODING", SDOModelWizard.this.initialObjectCreationPage.getEncoding());
                            eDataGraph.getDataGraphResource().save(options);
                        }
                        catch (Exception exception) {
                            SDOEditorPlugin.INSTANCE.log(exception);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        progressMonitor.done();
                        throw throwable;
                    }
                    {
                        Object var5_8 = null;
                    }
                    progressMonitor.done();
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
            }
            catch (PartInitException exception) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)SDOEditorPlugin.INSTANCE.getString("_UI_OpenEditorError_label"), (String)exception.getMessage());
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            SDOEditorPlugin.INSTANCE.log(exception);
            return false;
        }
    }

    public void addPages() {
        Object selectedElement;
        this.newFileCreationPage = new SDOModelWizardNewFileCreationPage("Whatever", this.selection);
        this.newFileCreationPage.setTitle(SDOEditorPlugin.INSTANCE.getString("_UI_SDOModelWizard_label"));
        this.newFileCreationPage.setDescription(SDOEditorPlugin.INSTANCE.getString("_UI_SDOModelWizard_description"));
        this.newFileCreationPage.setFileName(String.valueOf(SDOEditorPlugin.INSTANCE.getString("_UI_SDOEditorFilenameDefaultBase")) + "." + SDOEditorPlugin.INSTANCE.getString("_UI_SDOEditorFilenameExtension"));
        this.addPage((IWizardPage)this.newFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());
                String defaultModelBaseFilename = SDOEditorPlugin.INSTANCE.getString("_UI_SDOEditorFilenameDefaultBase");
                String defaultModelFilenameExtension = SDOEditorPlugin.INSTANCE.getString("_UI_SDOEditorFilenameExtension");
                String modelFilename = String.valueOf(defaultModelBaseFilename) + "." + defaultModelFilenameExtension;
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = String.valueOf(defaultModelBaseFilename) + i + "." + defaultModelFilenameExtension;
                    ++i;
                }
                this.newFileCreationPage.setFileName(modelFilename);
            }
        }
        this.initialObjectCreationPage = new SDOModelWizardInitialObjectCreationPage("Whatever2");
        this.initialObjectCreationPage.setTitle(SDOEditorPlugin.INSTANCE.getString("_UI_SDOModelWizard_label"));
        this.initialObjectCreationPage.setDescription(SDOEditorPlugin.INSTANCE.getString("_UI_Wizard_initial_object_description"));
        this.addPage((IWizardPage)this.initialObjectCreationPage);
    }

    public IFile getModelFile() {
        return this.newFileCreationPage.getModelFile();
    }

    public class SDOModelWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        protected IFile modelFile;

        public SDOModelWizardNewFileCreationPage(String pageId, IStructuredSelection selection) {
            super(pageId, selection);
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String requiredExt = SDOEditorPlugin.INSTANCE.getString("_UI_SDOEditorFilenameExtension");
                String enteredExt = new Path(this.getFileName()).getFileExtension();
                if (enteredExt == null || !enteredExt.equals(requiredExt)) {
                    this.setErrorMessage(SDOEditorPlugin.INSTANCE.getString("_WARN_FilenameExtension", new Object[]{requiredExt}));
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean performFinish() {
            this.modelFile = this.getModelFile();
            return true;
        }

        public IFile getModelFile() {
            return this.modelFile == null ? ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName())) : this.modelFile;
        }
    }

    public class SDOModelWizardInitialObjectCreationPage
    extends WizardPage {
        protected Combo initialObjectField;
        protected List encodings;
        protected String modelURI;
        protected CCombo modelURIField;
        protected String modelObject;
        protected EDataGraph eDataGraph;
        protected boolean isType;
        protected String encoding;
        protected CCombo encodingField;
        protected ModifyListener validator = new ModifyListener(this){
            final /* synthetic */ SDOModelWizardInitialObjectCreationPage this$1;
            {
                this.this$1 = sDOModelWizardInitialObjectCreationPage;
            }

            public void modifyText(ModifyEvent e) {
                this.this$1.setPageComplete(this.this$1.validatePage());
            }
        };

        public SDOModelWizardInitialObjectCreationPage(String pageId) {
            super(pageId);
        }

        public EDataGraph createRootObject() {
            if (this.isType) {
                this.eDataGraph.createRootObject(this.eDataGraph.getType(this.getModelURI(), this.getModelObject()));
            } else {
                EClass documentRoot = (EClass)this.eDataGraph.getEClassifier(this.getModelURI(), "");
                EObject rootObject = this.eDataGraph.createEObject(documentRoot);
                this.eDataGraph.setERootObject(rootObject);
                EStructuralFeature eStructuralFeature = documentRoot.getEStructuralFeature(this.getModelObject());
                if (!(eStructuralFeature instanceof EAttribute)) {
                    rootObject.eSet(eStructuralFeature, (Object)this.eDataGraph.createEObject((EClass)eStructuralFeature.getEType()));
                }
            }
            return this.eDataGraph;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label modelURILabel = new Label(composite, 16384);
            modelURILabel.setText(SDOEditorPlugin.INSTANCE.getString("_UI_ModelURI"));
            data = new GridData();
            data.horizontalAlignment = 4;
            modelURILabel.setLayoutData((Object)data);
            Composite buttonComposite = new Composite(composite, 0);
            GridData data2 = new GridData();
            data2.horizontalAlignment = 3;
            buttonComposite.setLayoutData((Object)data2);
            RowLayout layout2 = new RowLayout();
            layout2.justify = true;
            layout2.pack = true;
            layout2.spacing = 15;
            buttonComposite.setLayout((Layout)layout2);
            Button modelURIBrowseFileSystemButton = new Button(buttonComposite, 8);
            modelURIBrowseFileSystemButton.setText(SDOEditorPlugin.INSTANCE.getString("_UI_BrowseFileSystem_label"));
            String[] filters = new String[]{"*.xsd;*.wsdl;*.ecore;*.emof", "*.xsd;*.wsdl", "*.xsd", "*.wsdl", "*.ecore;*.emof", "*.ecore", "*.emof"};
            List<String> suffixList = Arrays.asList("xsd", "wsdl", "ecore", "emof");
            modelURIBrowseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(this, filters){
                final /* synthetic */ SDOModelWizardInitialObjectCreationPage this$1;
                private final /* synthetic */ String[] val$filters;
                {
                    this.this$1 = sDOModelWizardInitialObjectCreationPage;
                    this.val$filters = stringArray;
                }

                public void widgetSelected(SelectionEvent event) {
                    FileDialog fileDialog = new FileDialog(this.this$1.getShell());
                    fileDialog.setFilterExtensions(this.val$filters);
                    fileDialog.open();
                    if (fileDialog.getFileName() != null && fileDialog.getFileName().length() > 0) {
                        String filePath = String.valueOf(fileDialog.getFilterPath()) + File.separator + fileDialog.getFileName();
                        this.this$1.modelURIField.setText((String.valueOf(this.this$1.modelURIField.getText()) + "  " + URI.createFileURI((String)filePath).toString()).trim());
                        this.this$1.loadModelURI();
                    }
                }
            });
            Button modelURIBrowseWorkspaceButton = new Button(buttonComposite, 8);
            modelURIBrowseWorkspaceButton.setText(SDOEditorPlugin.INSTANCE.getString("_UI_BrowseWorkspace_label"));
            modelURIBrowseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(this, suffixList){
                final /* synthetic */ SDOModelWizardInitialObjectCreationPage this$1;
                private final /* synthetic */ List val$suffixList;
                {
                    this.this$1 = sDOModelWizardInitialObjectCreationPage;
                    this.val$suffixList = list;
                }

                public void widgetSelected(SelectionEvent event) {
                    ResourceSelectionDialog resourceSelectionDialog = new ResourceSelectionDialog(this.this$1.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), SDOEditorPlugin.INSTANCE.getString("_UI_SelectTheModel_label"));
                    resourceSelectionDialog.open();
                    Object[] result = resourceSelectionDialog.getResult();
                    if (result != null) {
                        StringBuffer text = new StringBuffer();
                        int i = 0;
                        while (i < result.length) {
                            IResource resource = (IResource)result[i];
                            if (resource.getType() == 1 && this.val$suffixList.contains(resource.getFullPath().getFileExtension())) {
                                text.append(URI.createPlatformResourceURI((String)resource.getFullPath().toString()));
                                text.append("  ");
                            }
                            ++i;
                        }
                        this.this$1.modelURIField.setText((String.valueOf(this.this$1.modelURIField.getText()) + "  " + text.toString()).trim());
                        this.this$1.loadModelURI();
                    }
                }
            });
            this.modelURIField = new CCombo(composite, 2048);
            GridData data3 = new GridData();
            data3.horizontalAlignment = 4;
            data3.grabExcessHorizontalSpace = true;
            data3.horizontalSpan = 2;
            this.modelURIField.setLayoutData((Object)data3);
            ArrayList packageURIs = new ArrayList(EPackage.Registry.INSTANCE.keySet());
            Collections.sort(packageURIs, Collator.getInstance());
            Iterator i = packageURIs.iterator();
            while (i.hasNext()) {
                String objectName = (String)i.next();
                this.modelURIField.add(objectName);
            }
            this.modelURIField.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ SDOModelWizardInitialObjectCreationPage this$1;
                {
                    this.this$1 = sDOModelWizardInitialObjectCreationPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.loadModelURI();
                }
            });
            Label initialObjectLabel = new Label(composite, 16384);
            initialObjectLabel.setText(SDOEditorPlugin.INSTANCE.getString("_UI_ModelObject"));
            GridData data4 = new GridData();
            data4.horizontalAlignment = 4;
            initialObjectLabel.setLayoutData((Object)data4);
            Button loadModelButton = new Button(composite, 8);
            loadModelButton.setText(SDOEditorPlugin.INSTANCE.getString("_UI_Load_label"));
            GridData data5 = new GridData();
            data5.horizontalAlignment = 3;
            loadModelButton.setLayoutData((Object)data5);
            loadModelButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ SDOModelWizardInitialObjectCreationPage this$1;
                {
                    this.this$1 = sDOModelWizardInitialObjectCreationPage;
                }

                public void widgetSelected(SelectionEvent event) {
                    this.this$1.loadModelURI();
                }
            });
            this.initialObjectField = new Combo(composite, 2048);
            data5 = new GridData();
            data5.horizontalAlignment = 4;
            data5.grabExcessHorizontalSpace = true;
            data5.horizontalSpan = 2;
            this.initialObjectField.setLayoutData((Object)data5);
            this.initialObjectField.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ SDOModelWizardInitialObjectCreationPage this$1;
                {
                    this.this$1 = sDOModelWizardInitialObjectCreationPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.setPageComplete(this.this$1.isPageComplete());
                }
            });
            Label encodingLabel = new Label(composite, 16384);
            encodingLabel.setText(SDOEditorPlugin.INSTANCE.getString("_UI_XMLEncoding"));
            GridData data6 = new GridData();
            data6.horizontalAlignment = 4;
            data6.horizontalSpan = 2;
            encodingLabel.setLayoutData((Object)data6);
            this.encodingField = new CCombo(composite, 2048);
            data6 = new GridData();
            data6.horizontalAlignment = 4;
            data6.grabExcessHorizontalSpace = true;
            data6.horizontalSpan = 2;
            this.encodingField.setLayoutData((Object)data6);
            StringTokenizer stringTokenizer = new StringTokenizer(SDOEditorPlugin.INSTANCE.getString("_UI_XMLEncodingChoices"));
            while (stringTokenizer.hasMoreTokens()) {
                this.encodingField.add(stringTokenizer.nextToken());
            }
            this.encodingField.select(0);
            this.setControl((Control)composite);
        }

        protected boolean validatePage() {
            return this.getInitialObjectName() != null && this.getEncodings().contains(this.encodingField.getText());
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                if (this.initialObjectField.getItemCount() == 1) {
                    this.initialObjectField.clearSelection();
                    this.encodingField.setFocus();
                } else {
                    this.encodingField.clearSelection();
                    this.initialObjectField.setFocus();
                }
            }
        }

        protected void loadModelURI() {
            this.eDataGraph = SDOFactory.eINSTANCE.createEDataGraph();
            ResourceSet resourceSet = this.eDataGraph.getResourceSet();
            Resource resource = resourceSet.getResource(URI.createURI((String)this.getModelURI()), true);
            ArrayList<String> objectNames = new ArrayList<String>();
            Iterator i = resource.getContents().iterator();
            while (i.hasNext()) {
                Iterator j;
                EClass documentRoot;
                Object object = i.next();
                if (!(object instanceof EPackage)) continue;
                EPackage ePackage = (EPackage)object;
                if (resource.getResourceSet() == resourceSet) {
                    ePackage.setEFactoryInstance((EFactory)new DynamicEDataObjectImpl.FactoryImpl());
                    resourceSet.getPackageRegistry().put((Object)resource.getURI().toString(), (Object)ePackage);
                    resourceSet.getPackageRegistry().put((Object)ePackage.getNsURI(), (Object)ePackage);
                }
                if ((documentRoot = ExtendedMetaData.INSTANCE.getDocumentRoot(ePackage)) != null) {
                    this.isType = false;
                    j = ExtendedMetaData.INSTANCE.getElements(documentRoot).iterator();
                    while (j.hasNext()) {
                        EStructuralFeature eStructuralFeature = (EStructuralFeature)j.next();
                        objectNames.add(eStructuralFeature.getName());
                    }
                } else {
                    this.isType = true;
                    j = ePackage.getEClassifiers().iterator();
                    while (j.hasNext()) {
                        EClassifier eClassifier = (EClassifier)j.next();
                        if (!(eClassifier instanceof EClass)) continue;
                        objectNames.add(eClassifier.getName());
                    }
                }
                break;
            }
            this.initialObjectField.removeAll();
            Collections.sort(objectNames, Collator.getInstance());
            i = objectNames.iterator();
            while (i.hasNext()) {
                String objectName = (String)i.next();
                this.initialObjectField.add(objectName);
            }
            this.setPageComplete(this.isPageComplete());
        }

        public boolean isPageComplete() {
            return this.initialObjectField.getSelectionIndex() != -1;
        }

        public boolean performFinish() {
            this.modelURI = this.getModelURI();
            this.modelObject = this.getModelObject();
            this.encoding = this.getEncoding();
            return true;
        }

        public String getInitialObjectName() {
            String label = this.initialObjectField.getText();
            Iterator i = SDOModelWizard.this.getInitialObjectNames().iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                if (!this.getLabel(name).equals(label)) continue;
                return name;
            }
            return null;
        }

        public String getModelURI() {
            return this.modelURI == null ? this.modelURIField.getText() : this.modelURI;
        }

        public String getModelObject() {
            return this.modelObject == null ? this.initialObjectField.getText() : this.modelObject;
        }

        public String getEncoding() {
            return this.encoding == null ? this.encodingField.getText() : this.encoding;
        }

        protected String getLabel(String typeName) {
            try {
                return SDOEditPlugin.INSTANCE.getString("_UI_" + typeName + "_type");
            }
            catch (MissingResourceException mre) {
                SDOEditorPlugin.INSTANCE.log(mre);
                return typeName;
            }
        }

        protected Collection getEncodings() {
            if (this.encodings == null) {
                this.encodings = new ArrayList();
                StringTokenizer stringTokenizer = new StringTokenizer(SDOEditorPlugin.INSTANCE.getString("_UI_XMLEncodingChoices"));
                while (stringTokenizer.hasMoreTokens()) {
                    this.encodings.add(stringTokenizer.nextToken());
                }
            }
            return this.encodings;
        }
    }
}

