'\"
'\" Generated from file '/usr/obj/i386/tcllib-1.4/tcllib-1.4/modules/dns/tcllib_dns.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2002, Pat Thoyts
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2000/03/06 21:34:53 ericm Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "dns" n 1.0.4 dns "dns"
.BS
.SH "NAME"
dns \- Tcl Domain Name Service Client
.SH "SYNOPSIS"
package require \fBTcl  8.2\fR
.sp
package require \fBdns  ?1.0.4?\fR
.sp
\fB::dns::resolve\fR \fIquery\fR ?\fIoptions\fR?\fR
.sp
\fB::dns::configure\fR ?\fIoptions\fR?\fR
.sp
\fB::dns::name\fR \fItoken\fR\fR
.sp
\fB::dns::address\fR \fItoken\fR\fR
.sp
\fB::dns::cname\fR \fItoken\fR\fR
.sp
\fB::dns::status\fR \fItoken\fR\fR
.sp
\fB::dns::error\fR \fItoken\fR\fR
.sp
\fB::dns::reset\fR \fItoken\fR\fR
.sp
\fB::dns::wait\fR \fItoken\fR\fR
.sp
\fB::dns::cleanup\fR \fItoken\fR\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The dns package provides a Tcl only Domain Name Service client. You
should refer to
RFC 1034 (\fIhttp://www.rfc-editor.org/rfc/rfc1034.txt\fR) and
RFC 1035 (\fIhttp://www.rfc-editor.org/rfc/rfc1035.txt\fR) for
information about the DNS protocol or read resolver(3) to find out how
the C library resolves domain names.
The intention of this package is to insulate Tcl scripts
from problems with using the system library resolver for slow name servers.
It may or may not be of practical use. Internet name resolution is a
complex business and DNS is only one part of the resolver. You may
find you are supposed to be using hosts files, NIS or WINS to name a
few other systems. This package is not a substitute for the C library
resolver - it does however implement name resolution over DNS.
The package also extends the package \fBuri\fR to support DNS URIs
or the form \fIdns:what.host.com\fR or
\fIdns://my.nameserver/what.host.com\fR. The \fBdns::resolve\fR
command can handle DNS URIs or simple domain names as a query.
.PP
\fINote:\fR The package defaults to using DNS over TCP
connections. If you wish to use UDP you will need to get the tcludp
package and get a version that correctly handles binary
data. This should be publicly available shortly.
.SH "COMMANDS"
.TP
\fB::dns::resolve\fR \fIquery\fR ?\fIoptions\fR?\fR
Resolve a domain name using the \fIDNS\fR protocol. \fIquery\fR is
the domain name to be lookup up. This should be either a fully
qualified domain name or a DNS URI.
.RS
.TP
\fB-nameserver\fR \fIhostname\fR or \fB-server\fR \fIhostname\fR
Specify an alternative name server for this request.
.TP
\fB-protocol\fR \fItcp|udp\fR
Specify the network protocol to use for this request. Can be one of
\fItcp\fR or \fIudp\fR.
.TP
\fB-port\fR \fIportnum\fR
Specify an alternative port.
.TP
\fB-search\fR \fIdomainlist\fR
.TP
\fB-timeout\fR \fImilliseconds\fR
Override the default timeout.
.TP
\fB-type\fR \fITYPE\fR
Specify the type of DNS record you are interested in. Valid values are A, NS, MD
MF, CNAME, SOA, MB, MG, MR, NULL, WKS, PTR, HINFO, MINFO, MX, TXT, AXFR, MAILB,
MAILA and *. See RFC1035 for details about the return values.
.TP
\fB-class\fR \fICLASS\fR
Specify the class of domain name. This is usually IN but may be one of IN for
internet domain names, CS, CH, HS or * for any class.
.TP
\fB-recurse\fR \fIboolean\fR
Set to \fIfalse\fR if you do not want the name server to recursively act upon
your request. Normally set to \fItrue\fR.
.TP
\fB-command\fR \fIprocname\fR
Set a procedure to be called upon request completion. The procedure will be
passed the token as its only argument.
.RE
.sp
.TP
\fB::dns::configure\fR ?\fIoptions\fR?\fR
The ::dns::configure command is used to setup the dns package. The server to
query, the protocol and domain search path are all set via this command. If
no arguments are provided then a list of all the current settings is returned.
If only one argument then it must the the name of an option and the value for
that option is returned.
.RS
.TP
\fB-nameserver\fR \fIhostname\fR
Set the default name server to be used by all queries. The default is
localhost.
.TP
\fB-protocol\fR \fItcp|udp\fR
Set the default network protocol to be used. Defaults to tcp.
.TP
\fB-port\fR \fIportnum\fR
Set the default port to use on the name server. The default is 53.
.TP
\fB-search\fR \fIdomainlist\fR
Set the domain search list. This is currently not used.
.TP
\fB-timeout\fR \fImilliseconds\fR
Set the default timeout value for DNS lookups. Defaults to 30 seconds.
.RE
.sp
.TP
\fB::dns::name\fR \fItoken\fR\fR
Returns a list of all domain names returned as an answer to your query.
.sp
.TP
\fB::dns::address\fR \fItoken\fR\fR
Returns a list of the address records that match your query.
.sp
.TP
\fB::dns::cname\fR \fItoken\fR\fR
Returns a list of canonical names (usually just one) matching your query.
.sp
.TP
\fB::dns::status\fR \fItoken\fR\fR
Returns the status flag. For a successfully completed query this will be
\fIok\fR. May be \fIerror\fR or \fItimeout\fR or \fIeof\fR.
See also \fB::dns::error\fR
.sp
.TP
\fB::dns::error\fR \fItoken\fR\fR
Returns the error message provided for requests whose status is \fIerror\fR.
If there is no error message then an empty string is returned.
.sp
.TP
\fB::dns::reset\fR \fItoken\fR\fR
Reset or cancel a DNS query.
.sp
.TP
\fB::dns::wait\fR \fItoken\fR\fR
Wait for a DNS query to complete and return the status upon completion.
.sp
.TP
\fB::dns::cleanup\fR \fItoken\fR\fR
Remove all state variables associated with the request.
.SH "EXAMPLES"
.PP
.nf
% set tok [dns::resolve www.tcl.tk]
::dns::1
% dns::status $tok
ok
% dns::address $tok
199.175.6.239
% dns::name $tok
www.tcl.tk
% dns::cleanup $tok
.fi
.PP
Using DNS URIs as queries:
.nf
% set tok [dns::resolve "dns:tcl.tk;type=MX"]
% set tok [dns::resolve "dns://l.root-servers.net/www.tcl.tk"]
.fi
.SH "AUTHORS"
Pat Thoyts
.SH "SEE ALSO"
resolver(5)
.SH "KEYWORDS"
DNS, domain name service, resolver, rfc 1034, rfc 1035
.SH "COPYRIGHT"
.nf
Copyright (c) 2002, Pat Thoyts
.fi