#!/usr/bin/perl -w
use strict;
use WWW::Curl::Easy;
use WWW::Curl::Multi;

my $url = 'http://files.oook.de';

sub header_callback {
    my $chunk = shift;
    print($chunk);
    return length($chunk);
}

sub body_callback {
    my ( $chunk, $handle ) = @_;
    print($chunk);
    return length($chunk);
}

my $curl = new WWW::Curl::Easy;
$curl->setopt( CURLOPT_URL,            $url );
$curl->setopt( CURLOPT_HEADERFUNCTION, \&header_callback );
$curl->setopt( CURLOPT_WRITEFUNCTION,  \&body_callback );

my $curl2 = new WWW::Curl::Easy;
$curl2->setopt( CURLOPT_URL,            $url );
$curl2->setopt( CURLOPT_HEADERFUNCTION, \&header_callback );
$curl2->setopt( CURLOPT_WRITEFUNCTION,  \&body_callback );

my $curlm = new WWW::Curl::Multi;
$curlm->add_handle($curl);
$curlm->add_handle($curl2);

$curlm->perform;
