# NOTE: Derived from blib/lib/Graphics/ColorNames.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package Graphics::ColorNames;

#line 200 "blib/lib/Graphics/ColorNames.pm (autosplit into blib/lib/auto/Graphics/ColorNames/_load_scheme_from_file.al)"
sub _load_scheme_from_file {
  my $self = shift;
  my $file = shift;

  unless (ref $file) {
    unless (-r $file) {
      croak "Cannot load scheme from file: \'$file\'";
    }
    require IO::File;
  }

  my $fh = ref($file) ? $file : (new IO::File);
  unless (ref $file) {
    open($fh, $file)
      || croak "Cannot open file: \'$file\'";
  }

  while (my $line = <$fh>) {
    unless ($line =~ /^[\!\#]/) {
      chomp($line);
      if ($line) {
	my ($red, $green, $blue, $name, $rgb);

	$name  = lc(substr($line, 12));
	$name =~ s/^\s+//;	# remove leading and trailing spaces
	$name =~ s/\s+$//;

	# TODO? Should we add an option to warn if overlapping names
	# are defined? This seems to be too common to be useful.

	unless (defined $self->{NAMES}->{$name}) {

	  $red   = eval substr($line,  0, 3);
	  $green = eval substr($line,  4, 3);
	  $blue  = eval substr($line,  8, 3);

	  $rgb   = ($red << 16) | ($green << 8) | ($blue);

	  $self->{NAMES}->{$name} = $rgb;
	}
      }
    }
  }
  unless (ref $file) {
    close $fh;
  }
}

# end of Graphics::ColorNames::_load_scheme_from_file
1;
