//@line 37 "/usr/obj/ports/mozilla-firefox-1.5.0.8/mozilla/toolkit/mozapps/extensions/content/about.js"

function EM_NS(aProperty)
{
  return "http://www.mozilla.org/2004/em-rdf#" + aProperty;
}

var gExtensionID = "";
var gExtensionDB = null;

function init()
{
  gExtensionID = window.arguments[0];
  gExtensionDB = window.arguments[1];

  var extensionsStrings = document.getElementById("extensionsStrings");
  
  var rdfs = Components.classes["@mozilla.org/rdf/rdf-service;1"]
                       .getService(Components.interfaces.nsIRDFService);

  var extension = rdfs.GetResource(gExtensionID);                       
                
  // Name       
  var nameArc = rdfs.GetResource(EM_NS("name"));
  var name = gExtensionDB.GetTarget(extension, nameArc, true);
  name = name.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
  // Version
  var versionArc = rdfs.GetResource(EM_NS("version"));
  var version = gExtensionDB.GetTarget(extension, versionArc, true);
  version = version.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
  // Description
  var descriptionArc = rdfs.GetResource(EM_NS("description"));
  var description = gExtensionDB.GetTarget(extension, descriptionArc, true);
  if (description)
    description = description.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
  // Home Page URL
  var homepageArc = rdfs.GetResource(EM_NS("homepageURL"));
  var homepage = gExtensionDB.GetTarget(extension, homepageArc, true);
  if (homepage) {
    homepage = homepage.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
    // only allow http(s) homepages
    var scheme = "";
    var uri = null;
    try {
      uri = makeURI(homepage);
      scheme = uri.scheme;
    } catch (ex) {}
    if (uri && (scheme == "http" || scheme == "https"))
      homepage = uri.spec;
    else
      homepage = null;
  }
    
  // Creator
  var creatorArc = rdfs.GetResource(EM_NS("creator"));
  var creator = gExtensionDB.GetTarget(extension, creatorArc, true);
  if (creator)
    creator = creator.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
  
  document.title = extensionsStrings.getFormattedString("aboutWindowTitle", [name]);
  var extensionName = document.getElementById("extensionName");
  extensionName.setAttribute("value", name);
  var extensionVersion = document.getElementById("extensionVersion");
  extensionVersion.setAttribute("value", extensionsStrings.getFormattedString("aboutWindowVersionString", [version]));
  
  var extensionDescription = document.getElementById("extensionDescription");
  extensionDescription.appendChild(document.createTextNode(description));
  
  var extensionCreator = document.getElementById("extensionCreator");
  extensionCreator.setAttribute("value", creator);
  
  var extensionHomepage = document.getElementById("extensionHomepage");
  if (homepage) {
    extensionHomepage.setAttribute("href", homepage);
    extensionHomepage.setAttribute("tooltiptext", homepage);
  }
  else
    extensionHomepage.hidden = true;
    
  var contributorsBox = document.getElementById("contributorsBox");
  var contributorsArc = rdfs.GetResource(EM_NS("contributor"));
  var contributors = gExtensionDB.GetTargets(extension, contributorsArc, true);
  var count = 0;
  while (contributors.hasMoreElements()) {
    var contributor = contributors.getNext().QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
    var label = document.createElement("label");
    label.setAttribute("value", contributor);
    label.setAttribute("class", "contributor");
    contributorsBox.appendChild(label);
    ++count;
  }
  if (count == 0)
    document.getElementById("extensionContributors").hidden = true;
    
  var acceptButton = document.documentElement.getButton("accept");
  acceptButton.label = extensionsStrings.getString("aboutWindowCloseButton");
}

