/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.metadata.ResolutionGroup;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.CyclicDependencyException;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.resolver.ResolutionNode;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;

public class DefaultArtifactCollector
implements ArtifactCollector {
    public ArtifactResolutionResult collect(Set artifacts, Artifact originatingArtifact, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List listeners) throws ArtifactResolutionException {
        return this.collect(artifacts, originatingArtifact, Collections.EMPTY_MAP, localRepository, remoteRepositories, source, filter, listeners);
    }

    public ArtifactResolutionResult collect(Set artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List listeners) throws ArtifactResolutionException {
        HashMap resolvedArtifacts = new HashMap();
        ResolutionNode root = new ResolutionNode(originatingArtifact, remoteRepositories);
        root.addDependencies(artifacts, remoteRepositories, filter);
        this.recurse(root, resolvedArtifacts, managedVersions, localRepository, remoteRepositories, source, filter, listeners);
        HashSet<ResolutionNode> set = new HashSet<ResolutionNode>();
        Iterator i = resolvedArtifacts.values().iterator();
        while (i.hasNext()) {
            List nodes = (List)i.next();
            Iterator j = nodes.iterator();
            while (j.hasNext()) {
                ResolutionNode node = (ResolutionNode)j.next();
                if (node.equals(root) || !node.isActive()) continue;
                Artifact artifact = node.getArtifact();
                if (!node.filterTrail(filter) || artifact.isOptional()) continue;
                artifact.setDependencyTrail(node.getDependencyTrail());
                set.add(node);
            }
        }
        ArtifactResolutionResult result = new ArtifactResolutionResult();
        result.setArtifactResolutionNodes(set);
        return result;
    }

    private void recurse(ResolutionNode node, Map resolvedArtifacts, Map managedVersions, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List listeners) throws CyclicDependencyException, ArtifactResolutionException, OverConstrainedVersionException {
        Iterator i;
        ArrayList<ResolutionNode> previousNodes;
        this.fireEvent(1, listeners, node);
        Object key = node.getKey();
        if (managedVersions.containsKey(key)) {
            Artifact artifact = (Artifact)managedVersions.get(key);
            this.fireEvent(7, listeners, node, artifact);
            if (artifact.getVersion() != null) {
                node.getArtifact().setVersion(artifact.getVersion());
            }
            if (artifact.getScope() != null) {
                node.getArtifact().setScope(artifact.getScope());
            }
        }
        if ((previousNodes = (ArrayList<ResolutionNode>)resolvedArtifacts.get(key)) != null) {
            i = previousNodes.iterator();
            while (i.hasNext()) {
                ResolutionNode previous = (ResolutionNode)i.next();
                if (!previous.isActive()) continue;
                VersionRange previousRange = previous.getArtifact().getVersionRange();
                VersionRange currentRange = node.getArtifact().getVersionRange();
                if (previousRange == null) {
                    node.getArtifact().setVersion(previous.getArtifact().getVersion());
                } else if (currentRange == null) {
                    previous.getArtifact().setVersion(node.getArtifact().getVersion());
                } else {
                    VersionRange newRange = previousRange.restrict(currentRange);
                    if (newRange.isSelectedVersionKnown(previous.getArtifact())) {
                        this.fireEvent(11, listeners, node, previous.getArtifact(), newRange);
                    }
                    previous.getArtifact().setVersionRange(newRange);
                    node.getArtifact().setVersionRange(currentRange.restrict(previousRange));
                    ResolutionNode[] resetNodes = new ResolutionNode[]{previous, node};
                    for (int j = 0; j < 2; ++j) {
                        Artifact resetArtifact = resetNodes[j].getArtifact();
                        if (resetArtifact.getVersion() != null || resetArtifact.getVersionRange() == null || resetArtifact.getAvailableVersions() == null) continue;
                        resetArtifact.selectVersion(resetArtifact.getVersionRange().matchVersion(resetArtifact.getAvailableVersions()).toString());
                        this.fireEvent(10, listeners, resetNodes[j]);
                    }
                }
                if (previous.getDepth() <= node.getDepth()) {
                    this.checkScopeUpdate(node, previous, listeners);
                } else {
                    this.checkScopeUpdate(previous, node, listeners);
                }
                if (previous.getDepth() <= node.getDepth()) {
                    this.fireEvent(5, listeners, node, previous.getArtifact());
                    node.disable();
                    continue;
                }
                this.fireEvent(5, listeners, previous, node.getArtifact());
                previous.disable();
            }
        } else {
            previousNodes = new ArrayList<ResolutionNode>();
            resolvedArtifacts.put(key, previousNodes);
        }
        previousNodes.add(node);
        this.fireEvent(4, listeners, node);
        if (node.isActive()) {
            this.fireEvent(2, listeners, node);
            i = node.getChildrenIterator();
            while (i.hasNext()) {
                ResolutionNode child = (ResolutionNode)i.next();
                if (child.isResolved() || child.getArtifact().isOptional()) continue;
                Artifact artifact = child.getArtifact();
                try {
                    if (artifact.getVersion() == null) {
                        ArtifactVersion version;
                        if (!artifact.isSelectedVersionKnown()) {
                            VersionRange versionRange;
                            List versions = artifact.getAvailableVersions();
                            if (versions == null) {
                                versions = source.retrieveAvailableVersions(artifact, localRepository, remoteRepositories);
                                artifact.setAvailableVersions(versions);
                            }
                            if ((version = (versionRange = artifact.getVersionRange()).matchVersion(versions)) == null) {
                                if (versions.isEmpty()) {
                                    throw new OverConstrainedVersionException("No versions are present in the repository for the artifact with a range " + versionRange, artifact, remoteRepositories);
                                }
                                throw new OverConstrainedVersionException("Couldn't find a version in " + versions + " to match range " + versionRange, artifact, remoteRepositories);
                            }
                        } else {
                            version = artifact.getSelectedVersion();
                        }
                        artifact.selectVersion(version.toString());
                        this.fireEvent(10, listeners, child);
                    }
                    ResolutionGroup rGroup = source.retrieve(artifact, localRepository, remoteRepositories);
                    child.addDependencies(rGroup.getArtifacts(), rGroup.getResolutionRepositories(), filter);
                }
                catch (CyclicDependencyException e) {
                    this.fireEvent(8, listeners, new ResolutionNode(e.getArtifact(), remoteRepositories, child));
                }
                catch (ArtifactMetadataRetrievalException e) {
                    artifact.setDependencyTrail(node.getDependencyTrail());
                    throw new ArtifactResolutionException("Unable to get dependency information: " + e.getMessage(), artifact, remoteRepositories, e);
                }
                this.recurse(child, resolvedArtifacts, managedVersions, localRepository, remoteRepositories, source, filter, listeners);
            }
            this.fireEvent(3, listeners, node);
        }
    }

    private void checkScopeUpdate(ResolutionNode farthest, ResolutionNode nearest, List listeners) {
        boolean updateScope = false;
        Artifact farthestArtifact = farthest.getArtifact();
        Artifact nearestArtifact = nearest.getArtifact();
        if ("runtime".equals(farthestArtifact.getScope()) && ("test".equals(nearestArtifact.getScope()) || "provided".equals(nearestArtifact.getScope()))) {
            updateScope = true;
        }
        if ("compile".equals(farthestArtifact.getScope()) && !"compile".equals(nearestArtifact.getScope())) {
            updateScope = true;
        }
        if (nearest.getDepth() < 2 && updateScope) {
            updateScope = false;
            this.fireEvent(9, listeners, nearest, farthestArtifact);
        }
        if (updateScope) {
            this.fireEvent(6, listeners, nearest, farthestArtifact);
            nearestArtifact.setScope(farthestArtifact.getScope());
        }
    }

    private void fireEvent(int event, List listeners, ResolutionNode node) {
        this.fireEvent(event, listeners, node, null);
    }

    private void fireEvent(int event, List listeners, ResolutionNode node, Artifact replacement) {
        this.fireEvent(event, listeners, node, replacement, null);
    }

    private void fireEvent(int event, List listeners, ResolutionNode node, Artifact replacement, VersionRange newRange) {
        Iterator i = listeners.iterator();
        block13: while (i.hasNext()) {
            ResolutionListener listener = (ResolutionListener)i.next();
            switch (event) {
                case 1: {
                    listener.testArtifact(node.getArtifact());
                    continue block13;
                }
                case 2: {
                    listener.startProcessChildren(node.getArtifact());
                    continue block13;
                }
                case 3: {
                    listener.endProcessChildren(node.getArtifact());
                    continue block13;
                }
                case 4: {
                    listener.includeArtifact(node.getArtifact());
                    continue block13;
                }
                case 5: {
                    String version = node.getArtifact().getVersion();
                    String replacementVersion = replacement.getVersion();
                    if (!(version != null ? !version.equals(replacementVersion) : replacementVersion != null)) continue block13;
                    listener.omitForNearer(node.getArtifact(), replacement);
                    continue block13;
                }
                case 8: {
                    listener.omitForCycle(node.getArtifact());
                    continue block13;
                }
                case 6: {
                    listener.updateScope(node.getArtifact(), replacement.getScope());
                    continue block13;
                }
                case 9: {
                    listener.updateScopeCurrentPom(node.getArtifact(), replacement.getScope());
                    continue block13;
                }
                case 7: {
                    listener.manageArtifact(node.getArtifact(), replacement);
                    continue block13;
                }
                case 10: {
                    listener.selectVersionFromRange(node.getArtifact());
                    continue block13;
                }
                case 11: {
                    if (!node.getArtifact().getVersionRange().hasRestrictions() && !replacement.getVersionRange().hasRestrictions()) continue block13;
                    listener.restrictRange(node.getArtifact(), replacement, newRange);
                    continue block13;
                }
            }
            throw new IllegalStateException("Unknown event: " + event);
        }
    }
}

