/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Hashtable;

public class ChoiceFormat
extends NumberFormat {
    private double[] limits;
    private String[] strings;
    private String pattern = null;
    private Hashtable patternNames = null;

    public void applyPattern(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (string.charAt(n3) == '|') {
                ++n2;
            }
            ++n3;
        }
        this.limits = new double[n2 + 1];
        this.strings = new String[n2 + 1];
        n3 = 0;
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n5 = 0;
        while (n5 < n) {
            char c = string.charAt(n5);
            if (c == '#') {
                this.limits[n4] = Double.valueOf(string.substring(n3, n5));
                stringBuffer.append(this.limits[n4] + "#");
                n3 = n5 + 1;
            } else if (c == '<') {
                this.limits[n4] = ChoiceFormat.nextDouble(Double.valueOf(string.substring(n3, n5)));
                stringBuffer.append(Double.valueOf(string.substring(n3, n5)) + "<");
                n3 = n5 + 1;
            } else if (c == '|') {
                this.strings[n4] = string.substring(n3, n5);
                stringBuffer.append(this.strings[n4] + "|");
                ++n4;
                n3 = n5 + 1;
            }
            ++n5;
        }
        this.strings[n4] = string.substring(n3, n);
        stringBuffer.append(this.strings[n4]);
        this.pattern = new String(stringBuffer);
    }

    public Object clone() {
        return new ChoiceFormat(this.limits, this.strings);
    }

    public boolean equals(Object object) {
        if (object instanceof ChoiceFormat) {
            ChoiceFormat choiceFormat = (ChoiceFormat)object;
            int n = this.limits.length;
            while (n-- > 0) {
                if (this.limits[n] == choiceFormat.limits[n] && this.strings[n].equals(choiceFormat.strings[n])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format((double)l, stringBuffer, fieldPosition);
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (d < this.limits[0] || Double.isNaN(d)) {
            stringBuffer.append(this.strings[0]);
            return stringBuffer;
        }
        int n = this.limits.length - 1;
        int n2 = 0;
        while (n2 < n) {
            if (this.limits[n2] <= d && d < this.limits[n2 + 1]) {
                stringBuffer.append(this.strings[n2]);
                return stringBuffer;
            }
            ++n2;
        }
        stringBuffer.append(this.strings[n]);
        return stringBuffer;
    }

    public Object[] getFormats() {
        return this.strings;
    }

    public double[] getLimits() {
        return this.limits;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static final double nextDouble(double d) {
        if (Double.isNaN(d)) {
            return d;
        }
        if (Double.POSITIVE_INFINITY == d) {
            return d;
        }
        if (-0.0 == d) {
            return Double.longBitsToDouble(1L);
        }
        long l = Double.doubleToLongBits(d);
        if (d < 0.0) {
            return Double.longBitsToDouble(l - 1L);
        }
        return Double.longBitsToDouble(l + 1L);
    }

    public static final double previousDouble(double d) {
        if (Double.isNaN(d)) {
            return d;
        }
        if (Double.NEGATIVE_INFINITY == d) {
            return d;
        }
        if (0.0 == d) {
            return Double.longBitsToDouble(-9223372036854775807L);
        }
        long l = Double.doubleToLongBits(d);
        if (d > 0.0) {
            return Double.longBitsToDouble(l - 1L);
        }
        return Double.longBitsToDouble(l + 1L);
    }

    public static double nextDouble(double d, boolean bl) {
        if (bl) {
            return ChoiceFormat.nextDouble(d);
        }
        return ChoiceFormat.previousDouble(d);
    }

    public Number parse(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        int n2 = n + 1;
        if (this.patternNames == null) {
            this.patternNames = new Hashtable();
            int n3 = 0;
            while (n3 < this.limits.length) {
                this.patternNames.put(this.strings[n3], new Double(this.limits[n3]));
                ++n3;
            }
        }
        while (n2 <= string.length()) {
            Double d = (Double)this.patternNames.get(string.substring(n, n2));
            if (d == null) {
                ++n2;
                continue;
            }
            parsePosition.setIndex(n2);
            return d;
        }
        return new Double(Double.NaN);
    }

    public void setChoices(double[] dArray, String[] stringArray) {
        this.limits = dArray;
        this.strings = stringArray;
    }

    public String toPattern() {
        if (this.limits.length == 0) {
            return "";
        }
        if (this.pattern == null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.limits.length) {
                stringBuffer.append(this.limits[n] + "#" + this.strings[n]);
                if (n < this.limits.length - 1) {
                    stringBuffer.append("|");
                }
                this.pattern = new String(stringBuffer);
                ++n;
            }
        }
        return this.pattern;
    }

    public ChoiceFormat(String string) {
        this.applyPattern(string);
    }

    public ChoiceFormat(double[] dArray, String[] stringArray) {
        this.setChoices(dArray, stringArray);
    }
}

