/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class LineNumberReader
extends BufferedReader {
    private int lineno;
    private int marklineno;
    private boolean skipnextlf;
    private boolean markskipnextlf;

    public int getLineNumber() {
        return this.lineno;
    }

    public void mark(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            super.mark(n);
            this.marklineno = this.lineno;
            this.markskipnextlf = this.skipnextlf;
        }
    }

    public int read() throws IOException {
        int n;
        Object object = this.lock;
        synchronized (object) {
            n = super.read();
            switch (n) {
                case -1: {
                    break;
                }
                case 10: {
                    if (this.skipnextlf) {
                        this.skipnextlf = false;
                        n = this.read();
                        break;
                    }
                    ++this.lineno;
                    break;
                }
                case 13: {
                    this.skipnextlf = true;
                    n = 10;
                    ++this.lineno;
                    break;
                }
                default: {
                    this.skipnextlf = false;
                }
            }
        }
        return n;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3;
        Object object = this.lock;
        synchronized (object) {
            n3 = super.read(cArray, n, n2);
            int n4 = n + n3;
            int n5 = n;
            while (n5 < n4) {
                switch (cArray[n5]) {
                    case '\n': {
                        if (this.skipnextlf) {
                            this.skipnextlf = false;
                            break;
                        }
                        ++this.lineno;
                        break;
                    }
                    case '\r': {
                        this.skipnextlf = true;
                        ++this.lineno;
                        break;
                    }
                    default: {
                        this.skipnextlf = false;
                    }
                }
                ++n5;
            }
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = this.lock;
        synchronized (object) {
            char[] cArray;
            if (this.skipnextlf && this.read(cArray = new char[1]) > 0) {
                switch (cArray[0]) {
                    case '\n': {
                        break;
                    }
                    case '\r': {
                        return "";
                    }
                    default: {
                        stringBuffer.append(cArray);
                    }
                }
            }
            int n = this.lineno;
            String string = super.readLine();
            if (string == null) {
                if (stringBuffer.length() == 0) {
                    return null;
                }
            } else {
                stringBuffer.append(string);
            }
            this.lineno = n + 1;
            return stringBuffer.toString();
        }
    }

    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            super.reset();
            this.lineno = this.marklineno;
            this.skipnextlf = this.markskipnextlf;
        }
    }

    public void setLineNumber(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.lineno = n;
        }
    }

    public long skip(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("skip() value is negative");
        }
        long l2 = 0L;
        long l3 = 1024L;
        int n = (int)Math.min(l, 1024L);
        char[] cArray = new char[n];
        Object object = this.lock;
        synchronized (object) {
            int n2;
            while ((n2 = this.read(cArray, 0, Math.min(n, (int)(l - l2)))) > 0) {
                if (l > (l2 += (long)n2)) continue;
            }
        }
        return l2;
    }

    public LineNumberReader(Reader reader) {
        super(reader);
    }

    public LineNumberReader(Reader reader, int n) {
        super(reader, n);
    }
}

