/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.util.Enumeration;
import java.util.Vector;

public class MenuBar
extends MenuComponent
implements MenuContainer {
    private static final long serialVersionUID = -4930327919388951260L;
    Vector menus = new Vector();
    Menu helpMenu;

    public Menu add(Menu menu) {
        this.menus.addElement(menu);
        if ((this.flags & 0x400) > 0) {
            menu.parent = this;
            menu.owner = this.owner;
            menu.addNotify();
        }
        this.updateView();
        return menu;
    }

    public void addNotify() {
        if ((this.flags & 0x400) == 0) {
            int n = this.menus.size();
            int n2 = 0;
            while (n2 < n) {
                Menu menu = (Menu)this.menus.elementAt(n2);
                menu.parent = this;
                menu.owner = this.owner;
                menu.addNotify();
                ++n2;
            }
            this.flags |= 0x400;
        }
    }

    public int countMenus() {
        return this.menus.size();
    }

    public void deleteShortcut(MenuShortcut menuShortcut) {
        Enumeration enumeration = this.shortcuts();
        while (enumeration.hasMoreElements()) {
            MenuItem menuItem = (MenuItem)enumeration.nextElement();
            if (!menuShortcut.equals(menuItem.shortcut)) continue;
            menuItem.deleteShortcut();
        }
    }

    public Menu getHelpMenu() {
        return this.helpMenu;
    }

    public Menu getMenu(int n) {
        try {
            return (Menu)this.menus.elementAt(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getMenuCount() {
        return this.countMenus();
    }

    public MenuItem getShortcutMenuItem(MenuShortcut menuShortcut) {
        int n = this.menus.size();
        int n2 = 0;
        while (n2 < n) {
            Menu menu = (Menu)this.menus.elementAt(n2);
            MenuItem menuItem = menu.getShortcutMenuItem(menuShortcut);
            if (menuItem != null) {
                return menuItem;
            }
            ++n2;
        }
        return null;
    }

    protected void propagateOldEvents(boolean bl) {
        super.propagateOldEvents(bl);
        int n = this.menus.size() - 1;
        while (n >= 0) {
            ((Menu)this.menus.elementAt(n)).propagateOldEvents(bl);
            --n;
        }
        if (this.helpMenu != null) {
            this.helpMenu.propagateOldEvents(bl);
        }
    }

    public void remove(MenuComponent menuComponent) {
        if (menuComponent instanceof Menu) {
            if ((this.flags & 0x400) > 0) {
                menuComponent.removeNotify();
            }
            this.menus.removeElement(menuComponent);
            this.updateView();
        }
    }

    public synchronized void remove(int n) {
        try {
            this.remove((MenuComponent)this.menus.elementAt(n));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeNotify() {
        if ((this.flags & 0x400) > 0) {
            int n = this.menus.size();
            int n2 = 0;
            while (n2 < n) {
                Menu menu = (Menu)this.menus.elementAt(n2);
                menu.removeNotify();
                ++n2;
            }
            this.flags &= 0xFFFFFBFF;
        }
    }

    public synchronized void setHelpMenu(Menu menu) {
        this.helpMenu = menu;
        this.updateView();
    }

    public synchronized Enumeration shortcuts() {
        Vector vector = new Vector();
        int n = this.menus.size();
        int n2 = 0;
        while (n2 < n) {
            Menu menu = (Menu)this.menus.elementAt(n2);
            menu.addShortcuts(vector);
            ++n2;
        }
        return vector.elements();
    }

    void updateView() {
    }
}

