/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Deployer;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.startup.ContextRuleSet;
import org.apache.catalina.startup.ExpandWar;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.catalina.util.CatalinaDigester;
import org.apache.catalina.util.StringManager;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StandardHostDeployer
implements Deployer {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$core$StandardHostDeployer == null ? (class$org$apache$catalina$core$StandardHostDeployer = StandardHostDeployer.class$("org.apache.catalina.core.StandardHostDeployer")) : class$org$apache$catalina$core$StandardHostDeployer));
    private ContextRuleSet contextRuleSet = null;
    private Digester digester = null;
    protected StandardHost host = null;
    private NamingRuleSet namingRuleSet = null;
    private String overrideDocBase = null;
    private String overrideConfigFile = null;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.core");
    static /* synthetic */ Class class$org$apache$catalina$core$StandardHostDeployer;

    public StandardHostDeployer() {
    }

    public StandardHostDeployer(StandardHost host) {
        this.host = host;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = (StandardHost)host;
    }

    public String getName() {
        return this.host.getName();
    }

    public synchronized void install(String contextPath, URL war) throws IOException {
        if (contextPath == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathRequired"));
        }
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathFormat", contextPath));
        }
        if (this.findDeployedApp(contextPath) != null) {
            throw new IllegalStateException(sm.getString("standardHost.pathUsed", contextPath));
        }
        if (war == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.warRequired"));
        }
        log.info((Object)sm.getString("standardHost.installing", contextPath, war.toString()));
        String url = war.toString();
        String docBase = null;
        boolean isWAR = false;
        if (url.startsWith("jar:")) {
            if (!(url = url.substring(4, url.length() - 2)).toLowerCase().endsWith(".war")) {
                throw new IllegalArgumentException(sm.getString("standardHost.warURL", url));
            }
            isWAR = true;
        }
        if (url.startsWith("file://")) {
            docBase = url.substring(7);
        } else if (url.startsWith("file:")) {
            docBase = url.substring(5);
        } else {
            throw new IllegalArgumentException(sm.getString("standardHost.warURL", url));
        }
        boolean isAppBase = false;
        File appBase = new File(this.host.getAppBase());
        if (!appBase.isAbsolute()) {
            appBase = new File(System.getProperty("catalina.base"), this.host.getAppBase());
        }
        File contextFile = new File(docBase);
        File baseDir = contextFile.getParentFile();
        if (appBase.getCanonicalPath().equals(baseDir.getCanonicalPath())) {
            isAppBase = true;
        }
        if (!this.host.isDeployXML() && !isAppBase) {
            throw new IllegalArgumentException(sm.getString("standardHost.installBase", url));
        }
        if (isAppBase && this.host.getAutoDeploy()) {
            String filename = contextFile.getName();
            if (isWAR) {
                filename = filename.substring(0, filename.length() - 4);
            }
            if (contextPath.length() == 0) {
                if (!filename.equals("ROOT")) {
                    throw new IllegalArgumentException(sm.getString("standardHost.pathMatch", "/", "ROOT"));
                }
            } else if (!filename.equals(contextPath.substring(1))) {
                throw new IllegalArgumentException(sm.getString("standardHost.pathMatch", contextPath, filename));
            }
        }
        if (isWAR && this.host.isUnpackWARs()) {
            docBase = contextPath.equals("") ? ExpandWar.expand(this.host, war, "/ROOT") : ExpandWar.expand(this.host, war, contextPath);
        }
        try {
            Class<?> clazz = Class.forName(this.host.getContextClass());
            Context context = (Context)clazz.newInstance();
            context.setPath(contextPath);
            context.setDocBase(docBase);
            if (context instanceof Lifecycle) {
                clazz = Class.forName(this.host.getConfigClass());
                LifecycleListener listener = (LifecycleListener)clazz.newInstance();
                ((Lifecycle)((Object)context)).addLifecycleListener(listener);
            }
            this.host.fireContainerEvent("pre-install", context);
            this.host.addChild(context);
            this.host.fireContainerEvent("install", context);
        }
        catch (ClassNotFoundException e) {
            log.info((Object)"", (Throwable)e);
        }
        catch (Exception e) {
            log.info((Object)"Error installing", (Throwable)e);
            throw new IOException(e.toString());
        }
    }

    public synchronized void install(String contextPath, URL war, String configFile) throws IOException {
        if (contextPath == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathRequired"));
        }
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathFormat", contextPath));
        }
        if (this.findDeployedApp(contextPath) != null) {
            throw new IllegalStateException(sm.getString("standardHost.pathUsed", contextPath));
        }
        if (war == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.warRequired"));
        }
        log.info((Object)sm.getString("standardHost.installing", contextPath, war.toString()));
        String url = war.toString();
        String docBase = null;
        boolean isWAR = false;
        if (url.startsWith("jar:")) {
            if (!(url = url.substring(4, url.length() - 2)).toLowerCase().endsWith(".war")) {
                throw new IllegalArgumentException(sm.getString("standardHost.warURL", url));
            }
            isWAR = true;
        }
        if (url.startsWith("file://")) {
            docBase = url.substring(7);
        } else if (url.startsWith("file:")) {
            docBase = url.substring(5);
        } else {
            throw new IllegalArgumentException(sm.getString("standardHost.warURL", url));
        }
        if (isWAR && this.host.isUnpackWARs()) {
            docBase = contextPath.equals("") ? ExpandWar.expand(this.host, war, "/ROOT") : ExpandWar.expand(this.host, war, contextPath);
        }
        try {
            Class<?> clazz = Class.forName(this.host.getContextClass());
            Context context = (Context)clazz.newInstance();
            context.setPath(contextPath);
            context.setDocBase(docBase);
            context.setConfigFile(configFile);
            if (context instanceof Lifecycle) {
                clazz = Class.forName(this.host.getConfigClass());
                LifecycleListener listener = (LifecycleListener)clazz.newInstance();
                ((Lifecycle)((Object)context)).addLifecycleListener(listener);
            }
            this.host.fireContainerEvent("pre-install", context);
            this.host.addChild(context);
            this.host.fireContainerEvent("install", context);
            Engine engine = (Engine)this.host.getParent();
            StandardServer server = (StandardServer)engine.getService().getServer();
        }
        catch (Exception e) {
            log.error((Object)sm.getString("standardHost.installError", contextPath), (Throwable)e);
            throw new IOException(e.toString());
        }
    }

    /*
     * Loose catch block
     */
    public synchronized void install(URL config, URL war) throws IOException {
        block19: {
            if (config == null) {
                throw new IllegalArgumentException(sm.getString("standardHost.configRequired"));
            }
            if (!this.host.isDeployXML()) {
                throw new IllegalArgumentException(sm.getString("standardHost.configNotAllowed"));
            }
            log.info((Object)sm.getString("standardHost.installingXML", config));
            String docBase = null;
            boolean isWAR = false;
            if (war != null) {
                String url = war.toString();
                log.info((Object)sm.getString("standardHost.installingWAR", url));
                if (url.startsWith("jar:")) {
                    url = url.substring(4, url.length() - 2);
                    isWAR = true;
                }
                if (url.startsWith("file://")) {
                    docBase = url.substring(7);
                } else if (url.startsWith("file:")) {
                    docBase = url.substring(5);
                } else {
                    throw new IllegalArgumentException(sm.getString("standardHost.warURL", url));
                }
            }
            if (isWAR && this.host.isUnpackWARs()) {
                docBase = ExpandWar.expand(this.host, war);
            }
            this.overrideDocBase = docBase;
            String configPath = config.toString();
            if (configPath.startsWith("file:")) {
                configPath = configPath.startsWith("file://") ? configPath.substring(7) : configPath.substring(5);
                this.overrideConfigFile = new File(configPath).getAbsolutePath();
            } else {
                configPath = null;
            }
            InputStream stream = null;
            stream = configPath == null ? config.openStream() : new FileInputStream(configPath);
            Digester digester = this.createDigester();
            digester.setClassLoader(this.getClass().getClassLoader());
            digester.clear();
            digester.push((Object)this);
            digester.parse(stream);
            stream.close();
            stream = null;
            Object var9_9 = null;
            if (stream == null) break block19;
            try {
                stream.close();
                break block19;
            }
            catch (Throwable t) {
                // empty catch block
            }
            {
                break block19;
                catch (Exception e) {
                    this.host.log(sm.getString("standardHost.installError", docBase), e);
                    throw new IOException(e.toString());
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                this.overrideDocBase = null;
                this.overrideConfigFile = null;
                throw throwable;
            }
        }
        this.overrideDocBase = null;
        this.overrideConfigFile = null;
    }

    /*
     * Loose catch block
     */
    public synchronized void install(URL war) throws IOException {
        block16: {
            if (war == null) {
                throw new IllegalArgumentException(sm.getString("standardHost.warRequired"));
            }
            if (!this.host.isDeployXML()) {
                throw new IllegalArgumentException(sm.getString("standardHost.configNotAllowed"));
            }
            String docBase = null;
            boolean isWAR = false;
            String url = war.toString();
            log.info((Object)sm.getString("standardHost.installingWAR", url));
            if (url.startsWith("jar:")) {
                url = url.substring("jar:".length(), url.length() - 2);
                isWAR = true;
            }
            if (url.startsWith("file://")) {
                docBase = url.substring("file://".length());
            } else if (url.startsWith("file:")) {
                docBase = url.substring("file:".length());
            } else {
                throw new IllegalArgumentException(sm.getString("standardHost.warURL", url));
            }
            if (isWAR && this.host.isUnpackWARs()) {
                docBase = ExpandWar.expand(this.host, war);
            }
            this.overrideDocBase = docBase;
            InputStream stream = null;
            URL contextXml = new URL(war.toString() + "META-INF/context.xml");
            log.info((Object)sm.getString("standardHost.installingXML", contextXml));
            stream = contextXml.openStream();
            Digester digester = this.createDigester();
            digester.setClassLoader(this.getClass().getClassLoader());
            digester.clear();
            digester.push((Object)this);
            digester.parse(stream);
            stream.close();
            stream = null;
            Object var9_9 = null;
            if (stream == null) break block16;
            try {
                stream.close();
                break block16;
            }
            catch (Throwable t) {
                // empty catch block
            }
            {
                break block16;
                catch (Exception e) {
                    this.host.log(sm.getString("standardHost.installError", docBase), e);
                    throw new IOException(e.toString());
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                this.overrideDocBase = null;
                throw throwable;
            }
        }
        this.overrideDocBase = null;
    }

    public Context findDeployedApp(String contextPath) {
        return (Context)this.host.findChild(contextPath);
    }

    public String[] findDeployedApps() {
        Container[] children = this.host.findChildren();
        String[] results = new String[children.length];
        for (int i = 0; i < children.length; ++i) {
            results[i] = children[i].getName();
        }
        return results;
    }

    public void remove(String contextPath) throws IOException {
        if (contextPath == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathRequired"));
        }
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathFormat", contextPath));
        }
        Context context = this.findDeployedApp(contextPath);
        if (context == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathMissing", contextPath));
        }
        log.info((Object)sm.getString("standardHost.removing", contextPath));
        try {
            this.host.removeChild(context);
            this.host.fireContainerEvent("remove", context);
        }
        catch (Exception e) {
            log.error((Object)sm.getString("standardHost.removeError", contextPath), (Throwable)e);
            throw new IOException(e.toString());
        }
    }

    public void remove(String contextPath, boolean undeploy) throws IOException {
        if (contextPath == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathRequired"));
        }
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathFormat", contextPath));
        }
        Context context = this.findDeployedApp(contextPath);
        if (context == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathMissing", contextPath));
        }
        this.host.log(sm.getString("standardHost.removing", contextPath));
        try {
            File workDir = (File)context.getServletContext().getAttribute("javax.servlet.context.tempdir");
            String configFile = context.getConfigFile();
            this.host.removeChild(context);
            if (undeploy) {
                File contextFile;
                File baseDir;
                boolean isAppBase = false;
                File appBase = new File(this.host.getAppBase());
                if (!appBase.isAbsolute()) {
                    appBase = new File(System.getProperty("catalina.base"), this.host.getAppBase());
                }
                if ((baseDir = (contextFile = new File(context.getDocBase())).getParentFile()) == null || appBase.getCanonicalPath().equals(baseDir.getCanonicalPath())) {
                    isAppBase = true;
                }
                boolean isWAR = false;
                if (contextFile.getName().toLowerCase().endsWith(".war")) {
                    isWAR = true;
                }
                if (isAppBase && this.host.getAutoDeploy()) {
                    String filename = contextFile.getName();
                    if (isWAR) {
                        filename = filename.substring(0, filename.length() - 4);
                    }
                    if (contextPath.length() == 0 && filename.equals("ROOT") || filename.equals(contextPath.substring(1))) {
                        if (!isWAR) {
                            File contextWAR;
                            long contextLastModified = contextFile.lastModified();
                            if (contextFile.isDirectory()) {
                                ExpandWar.deleteDir(contextFile);
                            }
                            if (this.host.isUnpackWARs() && (contextWAR = new File(context.getDocBase() + ".war")).exists() && contextLastModified > contextWAR.lastModified()) {
                                contextWAR.delete();
                            }
                        } else {
                            contextFile.delete();
                        }
                    }
                    if (this.host.isDeployXML() && configFile != null) {
                        File docBaseXml = new File(configFile);
                        docBaseXml.delete();
                    }
                }
                if (workDir == null && context instanceof StandardContext && ((StandardContext)context).getWorkDir() != null) {
                    workDir = new File(((StandardContext)context).getWorkPath());
                }
                if (workDir != null && workDir.exists()) {
                    ExpandWar.deleteDir(workDir);
                }
            }
            this.host.fireContainerEvent("remove", context);
        }
        catch (Exception e) {
            this.host.log(sm.getString("standardHost.removeError", contextPath), e);
            throw new IOException(e.toString());
        }
    }

    public void start(String contextPath) throws IOException {
        if (contextPath == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathRequired"));
        }
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathFormat", contextPath));
        }
        Context context = this.findDeployedApp(contextPath);
        if (context == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathMissing", contextPath));
        }
        log.info((Object)("standardHost.start " + contextPath));
        try {
            ((Lifecycle)((Object)context)).start();
        }
        catch (LifecycleException e) {
            log.info((Object)("standardHost.start " + contextPath + ": "), (Throwable)e);
            throw new IllegalStateException("standardHost.start " + contextPath + ": " + e);
        }
    }

    public void stop(String contextPath) throws IOException {
        if (contextPath == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathRequired"));
        }
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathFormat", contextPath));
        }
        Context context = this.findDeployedApp(contextPath);
        if (context == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathMissing", contextPath));
        }
        log.info((Object)("standardHost.stop " + contextPath));
        try {
            ((Lifecycle)((Object)context)).stop();
        }
        catch (LifecycleException e) {
            log.error((Object)("standardHost.stop " + contextPath + ": "), (Throwable)e);
            throw new IllegalStateException("standardHost.stop " + contextPath + ": " + e);
        }
    }

    public void addChild(Container child) {
        Context context = (Context)child;
        String contextPath = context.getPath();
        if (contextPath == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathRequired"));
        }
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathFormat", contextPath));
        }
        if (this.host.findChild(contextPath) != null) {
            throw new IllegalStateException(sm.getString("standardHost.pathUsed", contextPath));
        }
        if (this.overrideDocBase != null) {
            context.setDocBase(this.overrideDocBase);
        }
        if (this.overrideConfigFile != null) {
            context.setConfigFile(this.overrideConfigFile);
        }
        this.host.fireContainerEvent("pre-install", context);
        this.host.addChild(child);
        this.host.fireContainerEvent("install", context);
    }

    public ClassLoader getParentClassLoader() {
        return this.host.getParentClassLoader();
    }

    public boolean isDeployXML() {
        return this.host.isDeployXML();
    }

    protected Digester createDigester() {
        if (this.digester == null) {
            this.digester = new CatalinaDigester();
            this.digester.setValidating(false);
            this.contextRuleSet = new ContextRuleSet("");
            this.digester.addRuleSet((RuleSet)this.contextRuleSet);
            this.namingRuleSet = new NamingRuleSet("Context/");
            this.digester.addRuleSet((RuleSet)this.namingRuleSet);
        }
        return this.digester;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

