/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.ValveContext;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.FieldInfo;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ExtendedAccessLogValve
extends ValveBase
implements Lifecycle {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$valves$ExtendedAccessLogValve == null ? (class$org$apache$catalina$valves$ExtendedAccessLogValve = ExtendedAccessLogValve.class$("org.apache.catalina.valves.ExtendedAccessLogValve")) : class$org$apache$catalina$valves$ExtendedAccessLogValve));
    protected static final String info = "org.apache.catalina.valves.ExtendedAccessLogValve/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    private StringManager sm = StringManager.getManager((String)"org.apache.catalina.valves");
    private boolean started = false;
    private String dateStamp = "";
    private PrintWriter writer = null;
    private SimpleDateFormat fileDateFormatter = null;
    private SimpleDateFormat dateFormatter = null;
    private SimpleDateFormat timeFormatter = null;
    private DecimalFormat timeTakenFormatter = null;
    private String myIpAddress = null;
    private String myDNSName = null;
    private FieldInfo[] fieldInfos;
    private File currentLogFile = null;
    private Date currentDate = null;
    private long rotationLastChecked = 0L;
    private String directory = "logs";
    private String pattern = null;
    private String prefix = "access_log.";
    private boolean rotatable = true;
    private String suffix = "";
    private String condition = null;
    private boolean checkExists = false;
    private String fileDateFormat = null;
    static /* synthetic */ Class class$org$apache$catalina$valves$ExtendedAccessLogValve;

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getInfo() {
        return info;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        FieldInfo[] f = this.decodePattern(pattern);
        if (f != null) {
            this.pattern = pattern;
            this.fieldInfos = f;
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isRotatable() {
        return this.rotatable;
    }

    public void setRotatable(boolean rotatable) {
        this.rotatable = rotatable;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public boolean isCheckExists() {
        return this.checkExists;
    }

    public void setCheckExists(boolean checkExists) {
        this.checkExists = checkExists;
    }

    public String getFileDateFormat() {
        return this.fileDateFormat;
    }

    public void setFileDateFormat(String fileDateFormat) {
        this.fileDateFormat = fileDateFormat;
    }

    public void invoke(Request request, Response response, ValveContext context) throws IOException, ServletException {
        long startTime = System.currentTimeMillis();
        context.invokeNext(request, response);
        long endTime = System.currentTimeMillis();
        long runTime = endTime - startTime;
        if (this.fieldInfos == null || this.condition != null && null != request.getRequest().getAttribute(this.condition)) {
            return;
        }
        Date date = this.getDate(endTime);
        StringBuffer result = new StringBuffer();
        for (int i = 0; this.fieldInfos != null && i < this.fieldInfos.length; ++i) {
            switch (this.fieldInfos[i].type) {
                case 0: {
                    if (1 == this.fieldInfos[i].location) {
                        result.append(request.getRequest().getRemoteAddr());
                        break;
                    }
                    if (2 == this.fieldInfos[i].location) {
                        result.append(request.getRequest().getRemoteHost());
                        break;
                    }
                    result.append("?WTF?");
                    break;
                }
                case 1: {
                    if (1 == this.fieldInfos[i].location) {
                        result.append(this.myIpAddress);
                        break;
                    }
                    if (2 == this.fieldInfos[i].location) {
                        result.append(this.myDNSName);
                        break;
                    }
                    result.append("?WTF?");
                    break;
                }
                case 2: {
                    result.append('?');
                    break;
                }
                case 3: {
                    result.append(this.getClientToServer(this.fieldInfos[i], request));
                    break;
                }
                case 4: {
                    result.append(this.getServerToClient(this.fieldInfos[i], response));
                    break;
                }
                case 5: {
                    result.append('-');
                    break;
                }
                case 6: {
                    result.append('-');
                    break;
                }
                case 7: {
                    result.append(this.getAppSpecific(this.fieldInfos[i], request));
                    break;
                }
                case 8: {
                    if (1 == this.fieldInfos[i].location) {
                        result.append(this.dateFormatter.format(date));
                        break;
                    }
                    if (2 == this.fieldInfos[i].location) {
                        result.append(this.timeTakenFormatter.format((double)runTime / 1000.0));
                        break;
                    }
                    if (3 == this.fieldInfos[i].location) {
                        result.append(this.timeFormatter.format(date));
                        break;
                    }
                    if (4 == this.fieldInfos[i].location) {
                        int length = response.getContentCount();
                        if (length > 0) {
                            result.append(length);
                            break;
                        }
                        result.append("-");
                        break;
                    }
                    if (5 == this.fieldInfos[i].location) {
                        result.append('-');
                        break;
                    }
                    result.append("?WTF?");
                    break;
                }
                default: {
                    result.append("?WTF?");
                }
            }
            if (this.fieldInfos[i].postWhiteSpace == null) continue;
            result.append(this.fieldInfos[i].postWhiteSpace);
        }
        this.log(result.toString(), date);
    }

    public synchronized boolean rotate(String newFileName) {
        if (this.currentLogFile != null) {
            File holder = this.currentLogFile;
            this.close();
            try {
                holder.renameTo(new File(newFileName));
            }
            catch (Throwable e) {
                log.error((Object)"rotate failed", e);
            }
            this.currentDate = new Date(System.currentTimeMillis());
            this.dateStamp = this.fileDateFormatter.format(this.currentDate);
            this.open();
            return true;
        }
        return false;
    }

    private String getClientToServer(FieldInfo fieldInfo, Request request) {
        ServletRequest sr = request.getRequest();
        HttpServletRequest hsr = null;
        if (sr instanceof HttpServletRequest) {
            hsr = (HttpServletRequest)sr;
        }
        switch (fieldInfo.location) {
            case 5: {
                return hsr.getMethod();
            }
            case 6: {
                if (null == hsr.getQueryString()) {
                    return hsr.getRequestURI();
                }
                return hsr.getRequestURI() + "?" + hsr.getQueryString();
            }
            case 7: {
                return hsr.getRequestURI();
            }
            case 8: {
                if (null == hsr.getQueryString()) {
                    return "-";
                }
                return hsr.getQueryString();
            }
            case 9: {
                return this.wrap(hsr.getHeader(fieldInfo.value));
            }
        }
        return "-";
    }

    private String getServerToClient(FieldInfo fieldInfo, Response response) {
        HttpResponse r = (HttpResponse)response;
        switch (fieldInfo.location) {
            case 3: {
                return "" + r.getStatus();
            }
            case 4: {
                return "?";
            }
            case 9: {
                return this.wrap(r.getHeader(fieldInfo.value));
            }
        }
        return "-";
    }

    private String getAppSpecific(FieldInfo fieldInfo, Request request) {
        ServletRequest sr = request.getRequest();
        HttpServletRequest hsr = null;
        if (sr instanceof HttpServletRequest) {
            hsr = (HttpServletRequest)sr;
        }
        switch (fieldInfo.xType) {
            case 6: {
                return this.wrap(this.urlEncode(sr.getParameter(fieldInfo.value)));
            }
            case 1: {
                return this.wrap(sr.getAttribute(fieldInfo.value));
            }
            case 2: {
                HttpSession session = null;
                if (hsr == null || (session = hsr.getSession(false)) == null) break;
                return this.wrap(session.getAttribute(fieldInfo.value));
            }
            case 3: {
                Cookie[] c = hsr.getCookies();
                for (int i = 0; c != null && i < c.length; ++i) {
                    if (!fieldInfo.value.equals(c[i].getName())) continue;
                    return this.wrap(c[i].getValue());
                }
            }
            case 4: {
                return this.wrap(request.getContext().getServletContext().getAttribute(fieldInfo.value));
            }
            case 5: {
                if (fieldInfo.location == 1) {
                    return this.wrap(hsr.getAuthType());
                }
                if (fieldInfo.location == 2) {
                    return this.wrap(hsr.getRemoteUser());
                }
                if (fieldInfo.location == 3) {
                    return this.wrap(hsr.getRequestedSessionId());
                }
                if (fieldInfo.location == 4) {
                    return this.wrap("" + hsr.isRequestedSessionIdFromCookie());
                }
                if (fieldInfo.location == 5) {
                    return this.wrap("" + hsr.isRequestedSessionIdValid());
                }
                if (fieldInfo.location == 6) {
                    return this.wrap("" + hsr.getContentLength());
                }
                if (fieldInfo.location == 7) {
                    return this.wrap(hsr.getCharacterEncoding());
                }
                if (fieldInfo.location == 8) {
                    return this.wrap(hsr.getLocale());
                }
                if (fieldInfo.location == 9) {
                    return this.wrap(hsr.getProtocol());
                }
                if (fieldInfo.location == 10) {
                    return this.wrap(hsr.getScheme());
                }
                if (fieldInfo.location != 11) break;
                return this.wrap("" + hsr.isSecure());
            }
        }
        return "-";
    }

    private String urlEncode(String value) {
        if (null == value || value.length() == 0) {
            return null;
        }
        return URLEncoder.encode(value);
    }

    private String wrap(Object value) {
        String svalue;
        if (value == null || "-".equals(value)) {
            return "-";
        }
        try {
            svalue = value.toString();
            if ("".equals(svalue)) {
                return "-";
            }
        }
        catch (Throwable e) {
            return "-";
        }
        StringBuffer buffer = new StringBuffer(svalue.length() + 2);
        buffer.append('\"');
        int i = 0;
        while (i < svalue.length()) {
            int j = svalue.indexOf(34, i);
            if (j == -1) {
                buffer.append(svalue.substring(i));
                i = svalue.length();
                continue;
            }
            buffer.append(svalue.substring(i, j + 1));
            buffer.append('\"');
            i = j + 2;
        }
        buffer.append('\"');
        return buffer.toString();
    }

    private synchronized void close() {
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
        this.writer.close();
        this.writer = null;
        this.currentLogFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(String message, Date date) {
        long systime;
        if (this.rotatable && (systime = System.currentTimeMillis()) - this.rotationLastChecked > 1000L) {
            this.currentDate = new Date(systime);
            this.rotationLastChecked = systime;
            String tsDate = this.fileDateFormatter.format(this.currentDate);
            if (!this.dateStamp.equals(tsDate)) {
                ExtendedAccessLogValve extendedAccessLogValve = this;
                synchronized (extendedAccessLogValve) {
                    if (!this.dateStamp.equals(tsDate)) {
                        this.close();
                        this.dateStamp = tsDate;
                        this.open();
                    }
                }
            }
        }
        if (this.checkExists) {
            ExtendedAccessLogValve extendedAccessLogValve = this;
            synchronized (extendedAccessLogValve) {
                if (this.currentLogFile != null && !this.currentLogFile.exists()) {
                    try {
                        this.close();
                    }
                    catch (Throwable e) {
                        log.info((Object)"at least this wasn't swallowed", e);
                    }
                    this.currentDate = new Date(System.currentTimeMillis());
                    this.dateStamp = this.fileDateFormatter.format(this.currentDate);
                    this.open();
                }
            }
        }
        if (this.writer != null) {
            this.writer.println(message);
        }
    }

    private synchronized void open() {
        File dir = new File(this.directory);
        if (!dir.isAbsolute()) {
            dir = new File(System.getProperty("catalina.base"), this.directory);
        }
        dir.mkdirs();
        try {
            String pathname = this.rotatable ? dir.getAbsolutePath() + File.separator + this.prefix + this.dateStamp + this.suffix : dir.getAbsolutePath() + File.separator + this.prefix + this.suffix;
            this.currentLogFile = new File(pathname);
            this.writer = new PrintWriter((Writer)new FileWriter(pathname, true), true);
            if (this.currentLogFile.length() == 0L) {
                this.writer.println("#Fields: " + this.pattern);
                this.writer.println("#Version: 1.0");
                this.writer.println("#Software: " + ServerInfo.getServerInfo());
            }
        }
        catch (IOException e) {
            this.writer = null;
            this.currentLogFile = null;
        }
    }

    private Date getDate(long systime) {
        if (0L == systime) {
            systime = System.currentTimeMillis();
        }
        if (systime - this.currentDate.getTime() > 1000L) {
            this.currentDate.setTime(systime);
        }
        return this.currentDate;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("extendedAccessLogValve.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        TimeZone tz = TimeZone.getTimeZone("GMT");
        this.dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
        this.dateFormatter.setTimeZone(tz);
        this.timeFormatter = new SimpleDateFormat("HH:mm:ss");
        this.timeFormatter.setTimeZone(tz);
        this.currentDate = new Date(System.currentTimeMillis());
        if (this.fileDateFormat == null || this.fileDateFormat.length() == 0) {
            this.fileDateFormat = "yyyy-MM-dd";
        }
        this.fileDateFormatter = new SimpleDateFormat(this.fileDateFormat);
        this.dateStamp = this.fileDateFormatter.format(this.currentDate);
        this.timeTakenFormatter = new DecimalFormat("0.000");
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            this.myIpAddress = inetAddress.getHostAddress();
            this.myDNSName = inetAddress.getHostName();
        }
        catch (Throwable e) {
            this.myIpAddress = "127.0.0.1";
            this.myDNSName = "localhost";
        }
        this.open();
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("extendedAccessLogValve.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.close();
    }

    public FieldInfo[] decodePattern(String fields) {
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)("decodePattern, fields=" + fields));
        }
        LinkedList<FieldInfo> list = new LinkedList<FieldInfo>();
        for (i = 0; i < fields.length() && Character.isWhitespace(fields.charAt(i)); ++i) {
        }
        if (i >= fields.length()) {
            log.info((Object)"fields was just empty or whitespace");
            return null;
        }
        while (i < fields.length()) {
            int j;
            if (log.isDebugEnabled()) {
                log.debug((Object)("fields.substring(i)=" + fields.substring(i)));
            }
            FieldInfo currentFieldInfo = new FieldInfo();
            if (fields.startsWith("date", i)) {
                currentFieldInfo.type = (short)8;
                currentFieldInfo.location = 1;
                i += "date".length();
            } else if (fields.startsWith("time-taken", i)) {
                currentFieldInfo.type = (short)8;
                currentFieldInfo.location = (short)2;
                i += "time-taken".length();
            } else if (fields.startsWith("time", i)) {
                currentFieldInfo.type = (short)8;
                currentFieldInfo.location = (short)3;
                i += "time".length();
            } else if (fields.startsWith("bytes", i)) {
                currentFieldInfo.type = (short)8;
                currentFieldInfo.location = (short)4;
                i += "bytes".length();
            } else if (fields.startsWith("cached", i)) {
                currentFieldInfo.type = (short)8;
                currentFieldInfo.location = (short)5;
                i += "cached".length();
            } else if (fields.startsWith("c-ip", i)) {
                currentFieldInfo.type = 0;
                currentFieldInfo.location = 1;
                i += "c-ip".length();
            } else if (fields.startsWith("c-dns", i)) {
                currentFieldInfo.type = 0;
                currentFieldInfo.location = (short)2;
                i += "c-dns".length();
            } else if (fields.startsWith("s-ip", i)) {
                currentFieldInfo.type = 1;
                currentFieldInfo.location = 1;
                i += "s-ip".length();
            } else if (fields.startsWith("s-dns", i)) {
                currentFieldInfo.type = 1;
                currentFieldInfo.location = (short)2;
                i += "s-dns".length();
            } else if (fields.startsWith("cs", i)) {
                if ((i = this.decode(fields, i + 2, currentFieldInfo, (short)3)) < 0) {
                    return null;
                }
            } else if (fields.startsWith("sc", i)) {
                if ((i = this.decode(fields, i + 2, currentFieldInfo, (short)4)) < 0) {
                    return null;
                }
            } else if (fields.startsWith("sr", i)) {
                if ((i = this.decode(fields, i + 2, currentFieldInfo, (short)5)) < 0) {
                    return null;
                }
            } else if (fields.startsWith("rs", i)) {
                if ((i = this.decode(fields, i + 2, currentFieldInfo, (short)6)) < 0) {
                    return null;
                }
            } else if (fields.startsWith("x", i)) {
                i = this.decodeAppSpecific(fields, i, currentFieldInfo);
            } else {
                log.error((Object)("unable to decode with rest of chars being: " + fields.substring(i)));
                return null;
            }
            for (j = i; j < fields.length() && Character.isWhitespace(fields.charAt(j)); ++j) {
            }
            if (j >= fields.length()) {
                if (j == i) {
                    currentFieldInfo.postWhiteSpace = "";
                } else {
                    currentFieldInfo.postWhiteSpace = fields.substring(i);
                    i = j;
                }
            } else {
                currentFieldInfo.postWhiteSpace = fields.substring(i, j);
                i = j;
            }
            list.add(currentFieldInfo);
        }
        i = 0;
        FieldInfo[] f = new FieldInfo[list.size()];
        Iterator k = list.iterator();
        while (k.hasNext()) {
            f[i++] = (FieldInfo)k.next();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("finished decoding with length of: " + i));
        }
        return f;
    }

    private int decode(String fields, int i, FieldInfo fieldInfo, short type) {
        if (fields.startsWith("-status", i)) {
            fieldInfo.location = (short)3;
            i += "-status".length();
        } else if (fields.startsWith("-comment", i)) {
            fieldInfo.location = (short)4;
            i += "-comment".length();
        } else if (fields.startsWith("-uri-query", i)) {
            fieldInfo.location = (short)8;
            i += "-uri-query".length();
        } else if (fields.startsWith("-uri-stem", i)) {
            fieldInfo.location = (short)7;
            i += "-uri-stem".length();
        } else if (fields.startsWith("-uri", i)) {
            fieldInfo.location = (short)6;
            i += "-uri".length();
        } else if (fields.startsWith("-method", i)) {
            fieldInfo.location = (short)5;
            i += "-method".length();
        } else if (fields.startsWith("(", i)) {
            int j;
            fieldInfo.location = (short)9;
            if ((j = fields.indexOf(41, ++i)) == -1) {
                log.error((Object)"No closing ) found for in decode");
                return -1;
            }
            fieldInfo.value = fields.substring(i, j);
            i = j + 1;
        } else {
            log.error((Object)("The next characters couldn't be decoded: " + fields.substring(i)));
            return -1;
        }
        fieldInfo.type = type;
        return i;
    }

    private int decodeAppSpecific(String fields, int i, FieldInfo fieldInfo) {
        fieldInfo.type = (short)7;
        if ((i += 2) >= fields.length()) {
            log.error((Object)"End of line reached before decoding x- param");
            return -1;
        }
        switch (fields.charAt(i)) {
            case 'A': {
                fieldInfo.xType = (short)4;
                break;
            }
            case 'C': {
                fieldInfo.xType = (short)3;
                break;
            }
            case 'R': {
                fieldInfo.xType = 1;
                break;
            }
            case 'S': {
                fieldInfo.xType = (short)2;
                break;
            }
            case 'H': {
                fieldInfo.xType = (short)5;
                break;
            }
            case 'P': {
                fieldInfo.xType = (short)6;
                break;
            }
            default: {
                return -1;
            }
        }
        if (i + 1 != fields.indexOf(40, i)) {
            log.error((Object)"x param in wrong format. Needs to be 'x-#(...)' read the docs!");
            return -1;
        }
        int j = fields.indexOf(41, i += 2);
        if (j == -1) {
            log.error((Object)"x param in wrong format. No closing ')'!");
            return -1;
        }
        fieldInfo.value = fields.substring(i, j);
        if (fieldInfo.xType == 5) {
            if ("authType".equals(fieldInfo.value)) {
                fieldInfo.location = 1;
            } else if ("remoteUser".equals(fieldInfo.value)) {
                fieldInfo.location = (short)2;
            } else if ("requestedSessionId".equals(fieldInfo.value)) {
                fieldInfo.location = (short)3;
            } else if ("requestedSessionIdFromCookie".equals(fieldInfo.value)) {
                fieldInfo.location = (short)4;
            } else if ("requestedSessionIdValid".equals(fieldInfo.value)) {
                fieldInfo.location = (short)5;
            } else if ("contentLength".equals(fieldInfo.value)) {
                fieldInfo.location = (short)6;
            } else if ("characterEncoding".equals(fieldInfo.value)) {
                fieldInfo.location = (short)7;
            } else if ("locale".equals(fieldInfo.value)) {
                fieldInfo.location = (short)8;
            } else if ("protocol".equals(fieldInfo.value)) {
                fieldInfo.location = (short)9;
            } else if ("scheme".equals(fieldInfo.value)) {
                fieldInfo.location = (short)10;
            } else if ("secure".equals(fieldInfo.value)) {
                fieldInfo.location = (short)11;
            } else {
                log.error((Object)("x param for servlet request, couldn't decode value: " + fieldInfo.location));
                return -1;
            }
        }
        return j + 1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

