/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.io.File;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.MemoryRuleSet;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.util.StringManager;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MemoryRealm
extends RealmBase {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$realm$MemoryRealm == null ? (class$org$apache$catalina$realm$MemoryRealm = MemoryRealm.class$("org.apache.catalina.realm.MemoryRealm")) : class$org$apache$catalina$realm$MemoryRealm));
    private Container container = null;
    private static Digester digester = null;
    protected final String info = "org.apache.catalina.realm.MemoryRealm/1.0";
    protected static final String name = "MemoryRealm";
    private String pathname = "conf/tomcat-users.xml";
    private HashMap principals = new HashMap();
    private static StringManager sm = StringManager.getManager((String)"org.apache.catalina.realm");
    private boolean started = false;
    static /* synthetic */ Class class$org$apache$catalina$realm$MemoryRealm;

    public String getInfo() {
        return "org.apache.catalina.realm.MemoryRealm/1.0";
    }

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String pathname) {
        this.pathname = pathname;
    }

    public Principal authenticate(String username, String credentials) {
        GenericPrincipal principal = (GenericPrincipal)this.principals.get(username);
        boolean validated = false;
        if (principal != null) {
            validated = this.hasMessageDigest() ? this.digest(credentials).equalsIgnoreCase(principal.getPassword()) : this.digest(credentials).equals(principal.getPassword());
        }
        if (validated) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("memoryRealm.authenticateSuccess", (Object)username));
            }
            return principal;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("memoryRealm.authenticateFailure", (Object)username));
        }
        return null;
    }

    void addUser(String username, String password, String roles) {
        int comma;
        ArrayList<String> list = new ArrayList<String>();
        roles = roles + ",";
        while ((comma = roles.indexOf(44)) >= 0) {
            String role = roles.substring(0, comma).trim();
            list.add(role);
            roles = roles.substring(comma + 1);
        }
        GenericPrincipal principal = new GenericPrincipal((Realm)this, username, password, list);
        this.principals.put(username, principal);
    }

    protected synchronized Digester getDigester() {
        if (digester == null) {
            digester = new Digester();
            digester.setValidating(false);
            digester.addRuleSet((RuleSet)new MemoryRuleSet());
        }
        return digester;
    }

    protected String getName() {
        return name;
    }

    protected String getPassword(String username) {
        GenericPrincipal principal = (GenericPrincipal)this.principals.get(username);
        if (principal != null) {
            return principal.getPassword();
        }
        return null;
    }

    protected Principal getPrincipal(String username) {
        return (Principal)this.principals.get(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() throws LifecycleException {
        File file = new File(this.pathname);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.pathname);
        }
        if (!file.exists() || !file.canRead()) {
            throw new LifecycleException(sm.getString("memoryRealm.loadExist", (Object)file.getAbsolutePath()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("memoryRealm.loadPath", (Object)file.getAbsolutePath()));
        }
        Digester digester = this.getDigester();
        try {
            Digester digester2 = digester;
            synchronized (digester2) {
                digester.push((Object)this);
                digester.parse(file);
            }
        }
        catch (Exception e) {
            throw new LifecycleException("memoryRealm.readXml", (Throwable)e);
        }
        super.start();
    }

    public synchronized void stop() throws LifecycleException {
        super.stop();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

