/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Deployer;
import org.apache.catalina.Host;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.warp.WarpConnection;
import org.apache.catalina.connector.warp.WarpConnector;
import org.apache.catalina.connector.warp.WarpHost;
import org.apache.catalina.connector.warp.WarpLogger;
import org.apache.catalina.connector.warp.WarpPacket;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.SecurityCollection;

public class WarpConfigurationHandler {
    private static final String DEFAULT_SERVLET = "org.apache.catalina.servlets.DefaultServlet";

    public boolean handle(WarpConnection warpConnection, WarpPacket warpPacket) throws IOException {
        WarpLogger warpLogger = new WarpLogger(this);
        warpLogger.setContainer(warpConnection.getConnector().getContainer());
        warpPacket.setType(1);
        warpPacket.writeUnsignedShort(0);
        warpPacket.writeUnsignedShort(10);
        warpPacket.writeInteger(warpConnection.getConnector().uniqueId);
        warpConnection.send(warpPacket);
        block8: while (true) {
            warpConnection.recv(warpPacket);
            switch (warpPacket.getType()) {
                case 5: {
                    String string = warpPacket.readString();
                    String string2 = warpPacket.readString();
                    int n = warpPacket.readUnsignedShort();
                    FilterMap[] filterMapArray = warpPacket.readString();
                    Context context = null;
                    warpPacket.reset();
                    try {
                        context = this.deploy(warpConnection, warpLogger, string, string2, (String)filterMapArray);
                    }
                    catch (Exception exception) {
                        warpLogger.log(exception);
                    }
                    if (context == null) {
                        String string3 = "Error deploying web application \"" + string + "\" under <http://" + string2 + ":" + n + (String)filterMapArray + ">";
                        warpLogger.log(string3);
                        warpPacket.setType(0);
                        warpPacket.writeString(string3);
                        warpConnection.send(warpPacket);
                        continue block8;
                    }
                    int n2 = warpConnection.getConnector().applicationId(context);
                    warpPacket.setType(6);
                    warpPacket.writeInteger(n2);
                    warpPacket.writeString(context.getDocBase());
                    warpConnection.send(warpPacket);
                    continue block8;
                }
                case 7: {
                    Object object;
                    Context context;
                    FilterMap[] filterMapArray;
                    int n = warpPacket.readInteger();
                    String string2 = warpConnection.getConnector().applicationContext(n);
                    if (string2 == null) {
                        object = "Invalid application ID for mappings " + n;
                        warpLogger.log((String)object);
                        warpPacket.reset();
                        warpPacket.setType(0);
                        warpPacket.writeString((String)object);
                        warpConnection.send(warpPacket);
                        continue block8;
                    }
                    object = string2.findServletMappings();
                    if (object != null) {
                        for (int i = 0; i < ((String[])object).length; ++i) {
                            String string;
                            context = string2.findChild(string2.findServletMapping(object[i]));
                            warpPacket.reset();
                            warpPacket.setType(9);
                            warpPacket.writeString(object[i]);
                            if (context instanceof Wrapper && DEFAULT_SERVLET.equals(string = ((Wrapper)context).getServletClass())) {
                                warpPacket.setType(8);
                            }
                            warpConnection.send(warpPacket);
                        }
                    }
                    if ((filterMapArray = string2.findFilterMaps()) != null) {
                        warpLogger.log("Filter mappings (" + filterMapArray.length + ")");
                        for (int i = 0; i < filterMapArray.length; ++i) {
                            String string = filterMapArray[i].getURLPattern();
                            if (string == null) continue;
                            warpPacket.reset();
                            warpPacket.setType(9);
                            warpPacket.writeString(string);
                            warpConnection.send(warpPacket);
                        }
                    }
                    if ((context = string2.findConstraints()) != null) {
                        for (int i = 0; i < ((Context)context).length; ++i) {
                            SecurityCollection[] securityCollectionArray = context[i].findCollections();
                            if (securityCollectionArray == null) continue;
                            for (int j = 0; j < securityCollectionArray.length; ++j) {
                                String[] stringArray = securityCollectionArray[j].findPatterns();
                                if (stringArray == null) continue;
                                for (int k = 0; k < stringArray.length; ++k) {
                                    warpPacket.reset();
                                    warpPacket.setType(9);
                                    warpPacket.writeString(stringArray[k]);
                                    warpConnection.send(warpPacket);
                                }
                            }
                        }
                    }
                    warpPacket.reset();
                    warpPacket.setType(10);
                    warpConnection.send(warpPacket);
                    continue block8;
                }
                case 14: {
                    return true;
                }
                case 254: {
                    return false;
                }
            }
            break;
        }
        String string = "Invalid packet with type " + warpPacket.getType();
        warpLogger.log(string);
        warpPacket.reset();
        warpPacket.setType(255);
        warpPacket.writeString(string);
        warpConnection.send(warpPacket);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context deploy(WarpConnection warpConnection, WarpLogger warpLogger, String string, String string2, String string3) throws IOException {
        WarpConnector warpConnector = warpConnection.getConnector();
        synchronized (warpConnector) {
            WarpHost warpHost;
            Container container = warpConnection.getConnector().getContainer();
            Object object = (Host)container.findChild(string2.toLowerCase());
            if (object == null) {
                warpHost = new WarpHost();
                warpHost.setName(string2);
                warpHost.setParent(container);
                warpHost.setAppBase(warpConnection.getConnector().getAppBase());
                warpHost.setDebug(warpConnection.getConnector().getDebug());
                container.addChild((Container)warpHost);
                object = warpHost;
            }
            if (string3.endsWith("/")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            if ((warpHost = (Context)object.findChild(string3)) == null) {
                Deployer deployer = (Deployer)object;
                File file = new File(string);
                if (!file.isAbsolute() && !(file = new File(object.getAppBase() + File.separator + string)).isAbsolute()) {
                    file = new File(System.getProperty("catalina.base"), object.getAppBase() + File.separator + string);
                }
                if (!file.exists()) {
                    warpLogger.log("Cannot find \"" + file.getPath() + "\" for appl. \"" + string + "\" host \"" + object.getName() + "\"");
                    return null;
                }
                String string4 = file.getCanonicalPath();
                URL uRL = new URL("file", null, string4);
                if (string4.toLowerCase().endsWith(".war")) {
                    uRL = new URL("jar:" + uRL.toString() + "!/");
                }
                deployer.install(string3, uRL);
                StandardContext standardContext = null;
                standardContext = (StandardContext)deployer.findDeployedApp(string3);
                standardContext.setDebug(warpConnection.getConnector().getDebug());
                return standardContext;
            }
            return warpHost;
        }
    }
}

