<?php

require_once 'Horde/Auth/imap.php';

/**
 * Kolab implementation of the Horde authentication system. Derives from the
 * Auth_imap IMAP authentication object, and simply provides parameters to it
 * based on the global Kolab configuration.
 *
 * $Horde: framework/Auth/Auth/kolab.php,v 1.1.10.4 2005/06/23 02:08:52 selsky Exp $
 *
 * Copyright 2004-2005 Stuart Binge <s.binge@codefusion.co.za>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Stuart Binge <s.binge@codefusion.co.za>
 * @since   Horde 1.3
 * @package Horde_Auth
 */
class Auth_kolab extends Auth_imap {

    /**
     * Constructs a new Kolab authentication object.
     *
     * @param array $params  A hash containing connection parameters.
     */
    function Auth_kolab($params = array())
    {
        $params['hostspec'] = $GLOBALS['conf']['kolab']['imap']['server'];
        $params['port'] = $GLOBALS['conf']['kolab']['imap']['port'];
        $params['protocol'] = 'imap/notls/novalidate-cert';

        parent::Auth_imap($params);
    }

}
