dnl AM_PATH_GENGAMENG(MIN-VERSION)
dnl
dnl Tests for gengameng, and defines GENGAMENG_PREFIX, GENGAMENG_CFLAGS
dnl and GENGAMENG_LIBS, as well as GENGAMENG_CONFIG, which is the full name
dnl of the gengameng-config script.
dnl All of these variables are submitted to AC_SUBST().
dnl Also tries to link a test program with gengameng.
dnl Calls AC_MSG_ERROR() on failure.
dnl Offers the option --with-gengameng-config=X.  Default is to search $PATH.
dnl
dnl Receives minimal version number to require as the argument.
dnl Example: AM_PATH_GENGAMENG(4.0)
dnl

AC_DEFUN([AM_PATH_GENGAMENG],
[
	MIN_GENGAMENG_VERSION="$1"

	AC_MSG_CHECKING(for gengameng - version >= $MIN_GENGAMENG_VERSION)

	AC_ARG_WITH(gengameng-config,
[  --with-gengameng-config=X    Full pathname of gengameng-config script
                               (Default is to search $PATH)],
	[
		GENGAMENG_CONFIG="$withval"
	],
	[
		GENGAMENG_CONFIG=`which gengameng-config` ||
		{ AC_MSG_ERROR([Could not find gengameng-config in path]); }
			# the semi-colon is necessary
	])


	GENGAMENG_VERSION=`$GENGAMENG_CONFIG --version`
	actual=`echo $GENGAMENG_VERSION | awk -F. '{ printf "%d", ([$]1 * 1000 + [$]2) * 1000 + [$]3;}'`
	minver=`echo "$MIN_GENGAMENG_VERSION" | awk -F. '{ printf "%d", ([$]1 * 1000 + [$]2) * 1000 + [$]3;}'`
	if test "$actual" -ge "$minver"; then
		AC_MSG_RESULT([found $GENGAMENG_VERSION])
	else
		AC_MSG_ERROR([gengameng >= $MIN_GENGAMENG_VERSION is required; found $GENGAMENG_VERSION])
	fi

	unset minver
	unset actual
	unset GENGAMENG_VERSION

	GENGAMENG_PREFIX=`$GENGAMENG_CONFIG --prefix`
	GENGAMENG_CFLAGS=`$GENGAMENG_CONFIG --cflags`
	GENGAMENG_LIBS=`$GENGAMENG_CONFIG --libs`

	AC_SUBST(GENGAMENG_CONFIG)
	AC_SUBST(GENGAMENG_PREFIX)
	AC_SUBST(GENGAMENG_CFLAGS)
	AC_SUBST(GENGAMENG_LIBS)


	# Try to link with gengameng:
	old_CFLAGS="$CXXFLAGS"
	CXXFLAGS="$GENGAMENG_CFLAGS"
	old_LIBS="$LIBS"
	LIBS="$GENGAMENG_LIBS"

	AC_TRY_LINK(
	[
		#include <gengameng/GameEngine.h>
	],
	[
		class TestEngine : GameEngine
		{
		public:
		    TestEngine() throw(string)
		    : GameEngine(Couple(1, 1), "", false) {}

		    virtual void processKey(SDLKey keysym, bool pressed) {}
		    virtual bool tick() { return false; }
		};

		try
		{
		    TestEngine theTestEngine;
		}
		catch (const string &s)
		{
		    fprintf(stderr, "Engine init error: %s\n", s.c_str());
		    return 1;
		}
		catch (int e)
		{
		    fprintf(stderr, "init error # %d\n", e);
		    return 1;
		}
		return 0;
	],
	[
		true
	],
	[
		AC_MSG_ERROR([could not link with gengameng.
You can get it on the BurgerSpace Home Page on the Web.])
	])

	CXXFLAGS="$old_CXXFLAGS"
	unset old_CXXFLAGS
	LIBS="$old_LIBS"
	unset old_LIBS
])
