/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.CategoryEvent;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandEvent;
import org.eclipse.core.commands.CommandManagerEvent;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ICategoryListener;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.core.commands.ICommandManagerListener;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.NotHandledException;

public final class CommandManager
implements ICategoryListener,
ICommandListener {
    private final Map categoriesById = new HashMap();
    private Collection commandManagerListeners = null;
    private final Map commandsById = new HashMap();
    private final Set definedCategoryIds = new HashSet();
    private final Set definedCommandIds = new HashSet();
    private IExecutionListener executionListener = null;
    private Collection executionListeners = null;

    public final void addCommandManagerListener(ICommandManagerListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.commandManagerListeners == null) {
            this.commandManagerListeners = new ArrayList(1);
        } else if (!this.commandManagerListeners.contains(listener)) {
            return;
        }
        this.commandManagerListeners.add(listener);
    }

    public final void addExecutionListener(IExecutionListener listener) {
        if (listener == null) {
            throw new NullPointerException("Cannot add a null execution listener");
        }
        if (this.executionListeners == null) {
            this.executionListeners = new ArrayList(1);
            this.executionListener = new ExecutionListener();
            Iterator commandItr = this.commandsById.values().iterator();
            while (commandItr.hasNext()) {
                Command command = (Command)commandItr.next();
                command.addExecutionListener(this.executionListener);
            }
        } else if (this.executionListeners.contains(listener)) {
            return;
        }
        this.executionListeners.add(listener);
    }

    public final void categoryChanged(CategoryEvent categoryEvent) {
        if (categoryEvent.isDefinedChanged()) {
            Category category = categoryEvent.getCategory();
            String categoryId = category.getId();
            boolean categoryIdAdded = category.isDefined();
            if (categoryIdAdded) {
                this.definedCategoryIds.add(categoryId);
            } else {
                this.definedCategoryIds.remove(categoryId);
            }
            this.fireCommandManagerChanged(new CommandManagerEvent(this, null, false, false, categoryId, categoryIdAdded, true));
        }
    }

    public final void commandChanged(CommandEvent commandEvent) {
        if (commandEvent.isDefinedChanged()) {
            Command command = commandEvent.getCommand();
            String commandId = command.getId();
            boolean commandIdAdded = command.isDefined();
            if (commandIdAdded) {
                this.definedCommandIds.add(commandId);
            } else {
                this.definedCommandIds.remove(commandId);
            }
            this.fireCommandManagerChanged(new CommandManagerEvent(this, commandId, commandIdAdded, true, null, false, false));
        }
    }

    private final void fireCommandManagerChanged(CommandManagerEvent commandManagerEvent) {
        int commandManagerListenersSize;
        if (commandManagerEvent == null) {
            throw new NullPointerException();
        }
        if (this.commandManagerListeners != null && (commandManagerListenersSize = this.commandManagerListeners.size()) > 0) {
            ICommandManagerListener[] listeners = this.commandManagerListeners.toArray(new ICommandManagerListener[commandManagerListenersSize]);
            int i = 0;
            while (i < commandManagerListenersSize) {
                ICommandManagerListener listener = listeners[i];
                listener.commandManagerChanged(commandManagerEvent);
                ++i;
            }
        }
    }

    public final Category getCategory(String categoryId) {
        if (categoryId == null) {
            throw new NullPointerException();
        }
        Category category = (Category)this.categoriesById.get(categoryId);
        if (category == null) {
            category = new Category(categoryId);
            this.categoriesById.put(categoryId, category);
            category.addCategoryListener(this);
        }
        return category;
    }

    public final Command getCommand(String commandId) {
        if (commandId == null) {
            throw new NullPointerException("A command may not have a null identifier");
        }
        if (commandId.length() < 1) {
            throw new IllegalArgumentException("The command must not have a zero-length identifier");
        }
        Command command = (Command)this.commandsById.get(commandId);
        if (command == null) {
            command = new Command(commandId);
            this.commandsById.put(commandId, command);
            command.addCommandListener(this);
            if (this.executionListener != null) {
                command.addExecutionListener(this.executionListener);
            }
        }
        return command;
    }

    public final Set getDefinedCategoryIds() {
        return Collections.unmodifiableSet(this.definedCategoryIds);
    }

    public final Set getDefinedCommandIds() {
        return Collections.unmodifiableSet(this.definedCommandIds);
    }

    public final void removeCommandManagerListener(ICommandManagerListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.commandManagerListeners == null) {
            return;
        }
        this.commandManagerListeners.remove(listener);
        if (this.commandManagerListeners.isEmpty()) {
            this.commandManagerListeners = null;
        }
    }

    public final void removeExecutionListener(IExecutionListener listener) {
        if (listener == null) {
            throw new NullPointerException("Cannot remove a null listener");
        }
        if (this.executionListeners == null) {
            return;
        }
        this.executionListeners.remove(listener);
        if (this.executionListeners.isEmpty()) {
            this.executionListeners = null;
            Iterator commandItr = this.commandsById.values().iterator();
            while (commandItr.hasNext()) {
                Command command = (Command)commandItr.next();
                command.removeExecutionListener(this.executionListener);
            }
            this.executionListener = null;
        }
    }

    public final void setHandlersByCommandId(Map handlersByCommandId) {
        Iterator commandIdItr = handlersByCommandId.keySet().iterator();
        while (commandIdItr.hasNext()) {
            this.getCommand((String)commandIdItr.next());
        }
        Iterator commandItr = this.commandsById.values().iterator();
        while (commandItr.hasNext()) {
            Command command = (Command)commandItr.next();
            String commandId = command.getId();
            Object value = handlersByCommandId.get(commandId);
            if (value instanceof IHandler) {
                command.setHandler((IHandler)value);
                continue;
            }
            command.setHandler(null);
        }
    }

    private final class ExecutionListener
    implements IExecutionListener {
        ExecutionListener() {
        }

        public final void notHandled(String commandId, NotHandledException exception) {
            int executionListenersSize;
            if (CommandManager.this.executionListeners != null && (executionListenersSize = CommandManager.this.executionListeners.size()) > 0) {
                IExecutionListener[] listeners = CommandManager.this.executionListeners.toArray(new IExecutionListener[executionListenersSize]);
                int i = 0;
                while (i < executionListenersSize) {
                    IExecutionListener listener = listeners[i];
                    listener.notHandled(commandId, exception);
                    ++i;
                }
            }
        }

        public final void postExecuteFailure(String commandId, ExecutionException exception) {
            int executionListenersSize;
            if (CommandManager.this.executionListeners != null && (executionListenersSize = CommandManager.this.executionListeners.size()) > 0) {
                IExecutionListener[] listeners = CommandManager.this.executionListeners.toArray(new IExecutionListener[executionListenersSize]);
                int i = 0;
                while (i < executionListenersSize) {
                    IExecutionListener listener = listeners[i];
                    listener.postExecuteFailure(commandId, exception);
                    ++i;
                }
            }
        }

        public final void postExecuteSuccess(String commandId, Object returnValue) {
            int executionListenersSize;
            if (CommandManager.this.executionListeners != null && (executionListenersSize = CommandManager.this.executionListeners.size()) > 0) {
                IExecutionListener[] listeners = CommandManager.this.executionListeners.toArray(new IExecutionListener[executionListenersSize]);
                int i = 0;
                while (i < executionListenersSize) {
                    IExecutionListener listener = listeners[i];
                    listener.postExecuteSuccess(commandId, returnValue);
                    ++i;
                }
            }
        }

        public final void preExecute(String commandId, ExecutionEvent event) {
            int executionListenersSize;
            if (CommandManager.this.executionListeners != null && (executionListenersSize = CommandManager.this.executionListeners.size()) > 0) {
                IExecutionListener[] listeners = CommandManager.this.executionListeners.toArray(new IExecutionListener[executionListenersSize]);
                int i = 0;
                while (i < executionListenersSize) {
                    IExecutionListener listener = listeners[i];
                    listener.preExecute(commandId, event);
                    ++i;
                }
            }
        }
    }
}

