/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.internal.localstore.HistoryStore;
import org.eclipse.core.internal.localstore.HistoryStore2;
import org.eclipse.core.internal.localstore.HistoryStoreConverter;
import org.eclipse.core.internal.localstore.IHistoryStore;
import org.eclipse.core.internal.properties.IPropertyManager;
import org.eclipse.core.internal.properties.PropertyManager;
import org.eclipse.core.internal.properties.PropertyManager2;
import org.eclipse.core.internal.properties.PropertyStoreConverter;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;

public class ResourcesCompatibility {
    public static IHistoryStore createHistoryStore(IPath location, int limit, boolean newImpl, boolean convert, boolean rename) {
        Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        if (!newImpl) {
            return new HistoryStore(workspace, location, limit);
        }
        HistoryStore2 newHistoryStore = new HistoryStore2(workspace, location, limit);
        if (!convert) {
            return newHistoryStore;
        }
        IStatus result = new HistoryStoreConverter().convertHistory(workspace, location, limit, newHistoryStore, rename);
        if (result.getSeverity() != 0) {
            ResourcesPlugin.getPlugin().getLog().log(result);
        }
        return newHistoryStore;
    }

    public static IPropertyManager createPropertyManager(boolean newImpl, boolean convert) {
        Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        if (!newImpl) {
            return new PropertyManager(workspace);
        }
        PropertyManager2 newPropertyManager = new PropertyManager2(workspace);
        if (!convert) {
            return newPropertyManager;
        }
        IStatus result = new PropertyStoreConverter().convertProperties(workspace, newPropertyManager);
        if (result.getSeverity() != 0) {
            ResourcesPlugin.getPlugin().getLog().log(result);
        }
        return newPropertyManager;
    }
}

