/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.syncinfo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.resources.CVSEntryLineTag;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableFolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Assert;

public class FolderSyncInfo {
    public static final String VIRTUAL_DIRECTORY = "CVSROOT/Emptydir";
    protected String repository;
    protected String root;
    private CVSEntryLineTag tag;
    protected boolean isStatic;

    public FolderSyncInfo(String repo, String root, CVSTag tag, boolean isStatic) {
        Assert.isNotNull(repo);
        Assert.isNotNull(root);
        this.repository = repo;
        this.root = root.intern();
        this.ensureRepositoryRelativeToRoot();
        this.isStatic = isStatic;
        this.setTag(tag);
    }

    private void ensureRepositoryRelativeToRoot() {
        String rootDir;
        try {
            rootDir = this.getRootDirectory();
        }
        catch (CVSException cVSException) {
            return;
        }
        if (this.repository.startsWith(rootDir)) {
            this.repository = this.repository.substring(rootDir.length());
        }
        if (this.repository.startsWith("/")) {
            this.repository = this.repository.substring("/".length());
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FolderSyncInfo)) {
            return false;
        }
        FolderSyncInfo syncInfo = (FolderSyncInfo)other;
        if (!this.getRoot().equals(syncInfo.getRoot())) {
            return false;
        }
        if (!this.getRepository().equals(syncInfo.getRepository())) {
            return false;
        }
        if (this.getIsStatic() != syncInfo.getIsStatic()) {
            return false;
        }
        if (this.getTag() == null || syncInfo.getTag() == null) {
            if (this.getTag() == null && syncInfo.getTag() != null && syncInfo.getTag().getType() != 0) {
                return false;
            }
            if (syncInfo.getTag() == null && this.getTag() != null && this.getTag().getType() != 0) {
                return false;
            }
        } else if (!this.getTag().equals(syncInfo.getTag())) {
            return false;
        }
        return true;
    }

    public String getRoot() {
        return this.root;
    }

    private String getRootDirectory() throws CVSException {
        try {
            String root = this.getRoot();
            int index = root.indexOf(64);
            if (index == -1) {
                index = root.indexOf(58);
                if (index == 0) {
                    index = root.indexOf(58, index + 1);
                    index = root.indexOf(58, index + 1);
                }
                if (index == -1 && (index = root.indexOf("/")) != -1) {
                    --index;
                }
            } else {
                index = root.indexOf(58, index + 1);
            }
            char c = root.charAt(++index);
            while (Character.isDigit(c)) {
                c = root.charAt(++index);
            }
            return root.substring(index);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new CVSException(CVSMessages.FolderSyncInfo_Maleformed_root_4);
        }
    }

    public CVSEntryLineTag getTag() {
        return this.tag;
    }

    public String getRepository() {
        return this.repository;
    }

    public boolean getIsStatic() {
        return this.isStatic;
    }

    public String getRemoteLocation() throws CVSException {
        return String.valueOf(this.getRootDirectory()) + "/" + this.getRepository();
    }

    public int hashCode() {
        return this.getRoot().hashCode() | this.getRepository().hashCode();
    }

    protected void setTag(CVSTag tag) {
        this.tag = tag == null || tag.equals(CVSTag.DEFAULT) ? null : new CVSEntryLineTag(tag);
    }

    public String toString() {
        return String.valueOf(this.getRoot()) + "/" + this.getRepository() + "/" + this.getTag();
    }

    public MutableFolderSyncInfo cloneMutable() {
        MutableFolderSyncInfo newSync = new MutableFolderSyncInfo(this);
        return newSync;
    }

    public boolean isSameMapping(FolderSyncInfo other) {
        if (other == null) {
            return false;
        }
        return this.getRoot().equals(other.getRoot()) && this.getRepository().equals(other.getRepository());
    }

    public byte[] getBytes() throws CVSException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(out);
        try {
            dos.writeUTF(this.getRoot());
            dos.writeUTF(this.getRepository());
            CVSEntryLineTag t = this.getTag();
            if (t == null) {
                dos.writeUTF("");
            } else {
                dos.writeUTF(t.toString());
            }
            dos.writeBoolean(this.getIsStatic());
            dos.close();
        }
        catch (IOException e) {
            throw CVSException.wrapException(e);
        }
        return out.toByteArray();
    }

    public static FolderSyncInfo getFolderSyncInfo(byte[] bytes) throws CVSException {
        boolean isStatic;
        CVSEntryLineTag tag;
        String repository;
        String root;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(in);
        try {
            root = dis.readUTF();
            repository = dis.readUTF();
            String tagName = dis.readUTF();
            tag = tagName.length() == 0 ? null : new CVSEntryLineTag(tagName);
            isStatic = dis.readBoolean();
        }
        catch (IOException e) {
            throw CVSException.wrapException(e);
        }
        return new FolderSyncInfo(repository, root, tag, isStatic);
    }

    public boolean isVirtualDirectory() {
        return this.getRepository().equals(VIRTUAL_DIRECTORY);
    }

    public FolderSyncInfo asImmutable() {
        return this;
    }
}

