/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;

public class CVSRevisionNumberCompareCriteria
implements IResourceVariantComparator {
    private boolean isThreeWay;

    public CVSRevisionNumberCompareCriteria(boolean isThreeWay) {
        this.isThreeWay = isThreeWay;
    }

    protected boolean compare(ICVSRemoteResource e1, ICVSRemoteResource e2) {
        if (e1.isContainer()) {
            return e2.isContainer();
        }
        return e1.equals(e2);
    }

    protected boolean compare(IResource e1, ICVSRemoteResource e2) {
        if (e1.getType() != 1) {
            return e2.isContainer();
        }
        ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)e1);
        try {
            byte[] syncBytes1 = cvsFile.getSyncBytes();
            byte[] syncBytes2 = ((ICVSRemoteFile)e2).getSyncBytes();
            if (syncBytes1 != null) {
                if (ResourceSyncInfo.isDeletion(syncBytes1) || ResourceSyncInfo.isMerge(syncBytes1) || cvsFile.isModified(null)) {
                    return false;
                }
                return ResourceSyncInfo.getRevision(syncBytes1).equals(ResourceSyncInfo.getRevision(syncBytes2));
            }
            return false;
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
            return false;
        }
    }

    public boolean compare(IResource local, IResourceVariant remote) {
        return this.compare(local, (ICVSRemoteResource)remote);
    }

    public boolean compare(IResourceVariant base, IResourceVariant remote) {
        return this.compare((ICVSRemoteResource)base, (ICVSRemoteResource)remote);
    }

    public boolean isThreeWay() {
        return this.isThreeWay;
    }
}

