/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare;

import java.text.MessageFormat;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.Splitter;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.NullViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class CompareViewerSwitchingPane
extends CompareViewerPane
implements ISelectionChangedListener,
ISelectionProvider,
IDoubleClickListener {
    private Viewer fViewer;
    private Object fInput;
    private ListenerList fSelectionListeners = new ListenerList();
    private ListenerList fDoubleClickListener = new ListenerList();
    private ListenerList fOpenListener = new ListenerList();
    private boolean fControlVisibility = false;
    private String fTitle;
    private String fTitleArgument;
    private IOpenListener fOpenHandler = new IOpenListener(){

        public void open(OpenEvent event) {
            Object[] listeners = CompareViewerSwitchingPane.this.fOpenListener.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IOpenListener)listeners[i]).open(event);
                ++i;
            }
        }
    };

    public CompareViewerSwitchingPane(Composite parent, int style) {
        this(parent, style, false);
    }

    public CompareViewerSwitchingPane(Composite parent, int style, boolean visibility) {
        super(parent, style);
        this.fControlVisibility = visibility;
        this.setViewer(new NullViewer((Composite)this));
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (CompareViewerSwitchingPane.this.fViewer != null) {
                    CompareViewerSwitchingPane.this.fViewer.removeSelectionChangedListener((ISelectionChangedListener)CompareViewerSwitchingPane.this);
                }
                if (CompareViewerSwitchingPane.this.fViewer instanceof StructuredViewer) {
                    StructuredViewer sv = (StructuredViewer)CompareViewerSwitchingPane.this.fViewer;
                    sv.removeDoubleClickListener((IDoubleClickListener)CompareViewerSwitchingPane.this);
                    sv.removeOpenListener(CompareViewerSwitchingPane.this.fOpenHandler);
                }
                CompareViewerSwitchingPane.this.fViewer = null;
                CompareViewerSwitchingPane.this.fInput = null;
                CompareViewerSwitchingPane.this.fSelectionListeners = null;
            }
        });
    }

    public Viewer getViewer() {
        return this.fViewer;
    }

    private void setViewer(Viewer newViewer) {
        if (newViewer == this.fViewer) {
            return;
        }
        boolean oldEmpty = this.isEmpty();
        if (this.fViewer != null) {
            this.fViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            if (this.fViewer instanceof StructuredViewer) {
                StructuredViewer sv = (StructuredViewer)this.fViewer;
                sv.removeDoubleClickListener((IDoubleClickListener)this);
                sv.removeOpenListener(this.fOpenHandler);
            }
            Control content = this.getContent();
            this.setContent(null);
            this.fViewer.setInput(null);
            if (content != null && !content.isDisposed()) {
                content.dispose();
            }
        } else {
            oldEmpty = false;
        }
        this.setContent(null);
        this.fViewer = newViewer;
        if (this.fViewer != null) {
            Composite parent;
            boolean old = this.getVisible();
            this.setContent(this.fViewer.getControl());
            this.setVisible(old);
            boolean newEmpty = this.isEmpty();
            this.fViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.fViewer instanceof StructuredViewer) {
                StructuredViewer sv = (StructuredViewer)this.fViewer;
                sv.addDoubleClickListener((IDoubleClickListener)this);
                sv.addOpenListener(this.fOpenHandler);
            }
            if (oldEmpty != newEmpty && (parent = this.getParent()) instanceof Splitter) {
                ((Splitter)parent).setVisible((Control)this, this.fControlVisibility ? !newEmpty : true);
            }
            this.layout(true);
        }
    }

    public String getTitleArgument() {
        return this.fTitleArgument;
    }

    public boolean isEmpty() {
        return this.fViewer == null || this.fViewer instanceof NullViewer;
    }

    public void addSelectionChangedListener(ISelectionChangedListener l) {
        this.fSelectionListeners.add((Object)l);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener l) {
        this.fSelectionListeners.remove((Object)l);
    }

    public void addDoubleClickListener(IDoubleClickListener l) {
        this.fDoubleClickListener.add((Object)l);
    }

    public void removeDoubleClickListener(IDoubleClickListener l) {
        this.fDoubleClickListener.remove((Object)l);
    }

    public void addOpenListener(IOpenListener l) {
        this.fOpenListener.add((Object)l);
    }

    public void removeOpenListener(IOpenListener l) {
        this.fOpenListener.remove((Object)l);
    }

    public void doubleClick(DoubleClickEvent event) {
        Object[] listeners = this.fDoubleClickListener.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IDoubleClickListener)listeners[i]).doubleClick(event);
            ++i;
        }
    }

    public ISelection getSelection() {
        if (this.fViewer != null) {
            return this.fViewer.getSelection();
        }
        return null;
    }

    public void setSelection(ISelection s) {
        if (this.fViewer != null) {
            this.fViewer.setSelection(s);
        }
    }

    public void selectionChanged(SelectionChangedEvent ev) {
        Object[] listeners = this.fSelectionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ISelectionChangedListener)listeners[i]).selectionChanged(ev);
            ++i;
        }
    }

    private boolean hasFocus2() {
        Display display = this.getDisplay();
        if (display != null) {
            Control focus = display.getFocusControl();
            while (focus != null) {
                if (focus == this) {
                    return true;
                }
                focus = focus.getParent();
            }
        }
        return false;
    }

    public void setInput(Object input) {
        Control c;
        if (this.fInput == input) {
            return;
        }
        boolean hadFocus = this.hasFocus2();
        this.fInput = input;
        Viewer newViewer = null;
        if (input != null) {
            newViewer = this.getViewer(this.fViewer, input);
        }
        if (newViewer == null) {
            if (this.fViewer instanceof NullViewer) {
                return;
            }
            newViewer = new NullViewer((Composite)this);
        }
        this.setViewer(newViewer);
        this.fViewer.setInput(input);
        Image image = null;
        if (!(this.fViewer instanceof NullViewer) && input instanceof ICompareInput) {
            image = ((ICompareInput)input).getImage();
        }
        this.setImage(image);
        String title = null;
        if (this.fViewer != null && (c = this.fViewer.getControl()) != null) {
            Object data = c.getData("org.eclipse.compare.CompareUI.CompareViewerTitle");
            if (data instanceof String) {
                title = (String)data;
            }
            if (hadFocus) {
                c.setFocus();
            }
        }
        this.fTitle = title;
        this.updateTitle();
    }

    public void setTitleArgument(String argument) {
        this.fTitleArgument = argument;
        this.updateTitle();
    }

    private void updateTitle() {
        if (this.fTitle != null) {
            if (this.fTitleArgument != null) {
                String format = CompareMessages.CompareViewerSwitchingPane_Titleformat;
                String t = MessageFormat.format(format, this.fTitle, this.fTitleArgument);
                this.setText(t);
            } else {
                this.setText(this.fTitle);
            }
        } else {
            this.setText("");
        }
    }

    public Object getInput() {
        return this.fInput;
    }

    protected abstract Viewer getViewer(Viewer var1, Object var2);
}

