/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IContext;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ContextHelpWindow
extends Window
implements IPageChangedListener {
    private ReusableHelpPart helpPart;
    private static final int DOCK_MARGIN = 10;
    private static final int CLIP_ALLOWANCE = 5;
    private FormToolkit toolkit;
    private Listener listener;
    private ControlListener parentListener;
    private Rectangle savedPbounds;
    private Rectangle savedBounds;
    private boolean parentResizeBlocked = false;

    public ContextHelpWindow(Shell parent) {
        super(parent);
        this.setShellStyle(80);
        if (!Platform.getWS().equals("gtk")) {
            this.parentListener = new ControlListener(){

                public void controlMoved(ControlEvent e) {
                    ContextHelpWindow.this.maintainRelativePosition();
                }

                public void controlResized(ControlEvent e) {
                    ContextHelpWindow.this.onParentWindowResize();
                }
            };
            this.listener = new Listener(){

                public void handleEvent(Event e) {
                    switch (e.type) {
                        case 13: 
                        case 15: {
                            ContextHelpWindow.this.update((Control)e.widget);
                            break;
                        }
                        case 10: {
                            if (!ContextHelpWindow.this.onWindowMove()) break;
                            e.doit = false;
                            break;
                        }
                        case 11: {
                            ContextHelpWindow.this.onWindowResize();
                        }
                    }
                }
            };
        }
    }

    public void showSearch() {
        this.helpPart.showPage("fsearch-page", true);
    }

    private void maintainRelativePosition() {
        if (this.savedPbounds == null || this.isDocked()) {
            this.dock(true);
        } else {
            Rectangle pbounds = this.getShell().getParent().getBounds();
            Rectangle bounds = this.getShell().getBounds();
            int deltaX = pbounds.x - this.savedPbounds.x;
            int deltaY = pbounds.y - this.savedPbounds.y;
            int newX = bounds.x + deltaX;
            int newY = bounds.y + deltaY;
            boolean doDock = false;
            Rectangle dbounds = this.getShell().getDisplay().getBounds();
            if (newX > dbounds.width - bounds.width) {
                newX = dbounds.width - bounds.width;
                if (pbounds.x + pbounds.width > newX) {
                    doDock = true;
                }
            } else if (newX < 0) {
                doDock = true;
            }
            if (newY > dbounds.height - bounds.height) {
                newY = dbounds.height - bounds.height;
            } else if (newY < 0) {
                newY = 0;
            }
            if (doDock) {
                this.dock(true);
                return;
            }
            this.getShell().setLocation(newX, newY);
            this.savedPbounds = pbounds;
            this.savedBounds = this.getShell().getBounds();
        }
    }

    protected Control createContents(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.toolkit.getHyperlinkGroup().setHyperlinkUnderlineMode(2);
        this.toolkit.getColors().initializeSectionToolBarColors();
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        container.setLayout((Layout)layout);
        ToolBarManager tbm = new ToolBarManager(0x800000);
        tbm.createControl(container);
        GridData gd = new GridData(128);
        gd.grabExcessHorizontalSpace = true;
        tbm.getControl().setLayoutData((Object)gd);
        Label separator = new Label(container, 258);
        gd = new GridData(256);
        gd.heightHint = 1;
        separator.setLayoutData((Object)gd);
        this.helpPart = new ReusableHelpPart((IRunnableContext)PlatformUI.getWorkbench().getProgressService());
        this.helpPart.init(null, (IToolBarManager)tbm, null, null);
        this.helpPart.setDefaultContextHelpText(Messages.HelpView_defaultText);
        this.helpPart.createControl(container, this.toolkit);
        this.helpPart.getControl().setLayoutData((Object)new GridData(1808));
        if (!Platform.getWS().equals("gtk")) {
            this.hookListeners();
        }
        this.helpPart.showPage("context-help-page");
        container.setLayoutData((Object)new GridData(1808));
        return container;
    }

    private void hookListeners() {
        Shell shell = this.getShell();
        shell.addListener(10, this.listener);
        shell.addListener(11, this.listener);
        this.hookPageChangeListener(shell.getParent(), this.listener);
        shell.getParent().addControlListener(this.parentListener);
    }

    private void unhookListeners() {
        Shell shell = this.getShell();
        shell.getParent().removeControlListener(this.parentListener);
        this.unhookPageChangeListener(shell.getParent(), this.listener);
        shell.removeListener(10, this.listener);
        shell.removeListener(11, this.listener);
    }

    private void hookPageChangeListener(Composite parent, Listener listener) {
        Object data = parent.getData();
        if (data instanceof IPageChangeProvider) {
            ((IPageChangeProvider)data).addPageChangedListener((IPageChangedListener)this);
        }
    }

    private void unhookPageChangeListener(Composite parent, Listener listener) {
        Object data = parent.getData();
        if (data instanceof IPageChangeProvider) {
            ((IPageChangeProvider)data).removePageChangedListener((IPageChangedListener)this);
        }
    }

    public void dock(boolean changeSides) {
        this.getShell().setBounds(this.computeDockedBounds(changeSides));
    }

    public Rectangle computeDockedBounds(boolean changeSides) {
        int x;
        boolean rightOK;
        Display d = this.getShell().getDisplay();
        Rectangle dbounds = d.getBounds();
        Rectangle pbounds = this.getShell().getParent().getBounds();
        int leftMargin = pbounds.x;
        int rightMargin = dbounds.width - pbounds.x - pbounds.width;
        int centeredLeftMargin = dbounds.width / 2 - pbounds.width / 2;
        boolean rightParent = leftMargin > centeredLeftMargin;
        int currentX = this.getShell().getLocation().x;
        int newSize = this.getShell().getSize().x;
        boolean leftOK = newSize <= leftMargin + 5;
        boolean bl = rightOK = newSize <= rightMargin + 5;
        if (!(currentX >= pbounds.x || !leftOK || changeSides && rightParent)) {
            x = pbounds.x - newSize;
        } else if (currentX > pbounds.x && rightOK && (!changeSides || rightParent)) {
            x = pbounds.x + pbounds.width;
        } else if (changeSides) {
            if (rightOK) {
                x = pbounds.x + pbounds.width;
            } else if (leftOK) {
                x = pbounds.x - newSize;
            } else if (leftMargin > rightMargin) {
                newSize = leftMargin;
                x = pbounds.x - newSize;
            } else {
                newSize = rightMargin;
                x = dbounds.width - newSize;
            }
        } else if (currentX < pbounds.x) {
            newSize = leftMargin;
            x = pbounds.x - newSize;
        } else {
            newSize = rightMargin;
            x = dbounds.width - newSize;
        }
        this.savedPbounds = pbounds;
        this.savedBounds = this.getShell().getBounds();
        return new Rectangle(x, pbounds.y, newSize, pbounds.height);
    }

    private boolean onWindowMove() {
        if (this.savedBounds == null) {
            this.savedBounds = this.getShell().getBounds();
            this.savedPbounds = this.getShell().getParent().getBounds();
            return false;
        }
        Rectangle bounds = this.getShell().getBounds();
        Rectangle pbounds = this.getShell().getParent().getBounds();
        if (bounds.y != this.savedBounds.y && bounds.y + bounds.height == this.savedBounds.y + this.savedBounds.height && this.isDocked()) {
            this.savedBounds = bounds;
            this.savedPbounds = pbounds;
            return false;
        }
        boolean doDock = false;
        if (bounds.x < pbounds.x) {
            int distance;
            int deltaX = bounds.x - this.savedBounds.x;
            if ((deltaX > 0 || bounds.x + bounds.width > pbounds.x) && Math.abs(distance = pbounds.x - bounds.x - bounds.width) <= 10) {
                doDock = true;
            }
        } else {
            int distance;
            int deltaX = bounds.x - this.savedBounds.x;
            if ((deltaX < 0 || bounds.x < pbounds.x + pbounds.width) && Math.abs(distance = bounds.x - pbounds.x - pbounds.width) <= 10) {
                doDock = true;
            }
        }
        if (bounds.y + bounds.height < pbounds.y) {
            doDock = false;
        }
        if (pbounds.y + pbounds.height < bounds.y) {
            doDock = false;
        }
        if (doDock) {
            this.dock(false);
        }
        this.savedBounds = this.getShell().getBounds();
        this.savedPbounds = this.getShell().getParent().getBounds();
        return doDock;
    }

    private void onWindowResize() {
        if (this.isDocked()) {
            Shell parent;
            Rectangle bounds = this.getShell().getBounds();
            Rectangle pbounds = this.getShell().getParent().getBounds();
            if (bounds.height != this.savedBounds.height && ((parent = (Shell)this.getShell().getParent()).getStyle() & 0x10) != 0) {
                this.parentResizeBlocked = true;
                parent.setBounds(pbounds.x, bounds.y, pbounds.width, bounds.height);
                this.parentResizeBlocked = false;
            }
        }
        this.savedBounds = this.getShell().getBounds();
    }

    private void onParentWindowResize() {
        if (!this.parentResizeBlocked && this.isDocked()) {
            Rectangle bounds = this.getShell().getBounds();
            Rectangle pbounds = this.getShell().getParent().getBounds();
            if (bounds.x == this.savedPbounds.x + this.savedPbounds.width && this.savedPbounds.x + this.savedPbounds.width != pbounds.x + pbounds.width) {
                this.dock(false);
            }
            this.getShell().setSize(this.getShell().getSize().x, this.getShell().getParent().getSize().y);
        }
        this.savedPbounds = this.getShell().getParent().getBounds();
    }

    public void update(Control c) {
        this.helpPart.update(null, c);
    }

    public void update(IContext context, Control c) {
        this.helpPart.showPage("context-help-page");
        this.helpPart.update(context, null, c);
    }

    public boolean close() {
        if (!Platform.getWS().equals("gtk")) {
            this.unhookListeners();
        }
        if (super.close()) {
            if (this.toolkit != null) {
                this.toolkit.dispose();
                this.toolkit = null;
            }
            if (this.helpPart != null) {
                this.helpPart.dispose();
                this.helpPart = null;
            }
            return true;
        }
        return false;
    }

    private boolean isDocked() {
        if (this.savedPbounds == null) {
            return false;
        }
        return this.isDocked(this.savedBounds, this.savedPbounds);
    }

    private boolean isDocked(Rectangle bounds, Rectangle pbounds) {
        if (pbounds.height != bounds.height) {
            return false;
        }
        if (bounds.y + bounds.height < pbounds.y) {
            return false;
        }
        if (pbounds.y + pbounds.height < bounds.y) {
            return false;
        }
        return bounds.x == pbounds.x + pbounds.width || bounds.x == pbounds.x - bounds.width;
    }

    public void pageChanged(PageChangedEvent event) {
        Object page = event.getSelectedPage();
        Control c = null;
        if (page instanceof IDialogPage) {
            c = ((IDialogPage)page).getControl();
        } else {
            TabFolder folder;
            TabItem[] selection;
            c = this.getShell().getDisplay().getFocusControl();
            if (c instanceof TabFolder && (selection = (folder = (TabFolder)c).getSelection()).length == 1) {
                c = selection[0].getControl();
            }
        }
        this.update(null, c);
    }
}

