/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal;

import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.IContext;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.ui.internal.ContextHelpDialog;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.util.ErrorUtil;
import org.eclipse.help.ui.internal.views.ContextHelpPart;
import org.eclipse.help.ui.internal.views.ContextHelpWindow;
import org.eclipse.help.ui.internal.views.HelpView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.help.AbstractHelpUI;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;

public class DefaultHelpUI
extends AbstractHelpUI {
    private ContextHelpDialog f1Dialog = null;
    private ContextHelpWindow f1Window = null;
    private static DefaultHelpUI instance;
    private static final String HELP_VIEW_ID = "org.eclipse.help.ui.HelpView";

    public DefaultHelpUI() {
        instance = this;
        BaseHelpSystem.getInstance().setBrowserInstance((IBrowser)new ExternalWorkbenchBrowser());
    }

    static DefaultHelpUI getInstance() {
        return instance;
    }

    public void displayHelp() {
        BaseHelpSystem.getHelpDisplay().displayHelp(this.useExternalBrowser(null));
    }

    public void displaySearch() {
        this.search(null);
    }

    public void displayDynamicHelp() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell activeShell = DefaultHelpUI.getActiveShell();
        if (window != null && DefaultHelpUI.isActiveShell(activeShell, window)) {
            IIntroManager introMng = PlatformUI.getWorkbench().getIntroManager();
            IIntroPart intro = introMng.getIntro();
            if (intro != null && !introMng.isIntroStandby(intro)) {
                introMng.setIntroStandby(intro, true);
            }
            IWorkbenchPage page = window.getActivePage();
            Control c = activeShell.getDisplay().getFocusControl();
            if (page != null) {
                IWorkbenchPart activePart = page.getActivePart();
                try {
                    IViewPart part = page.showView(HELP_VIEW_ID, null, 2);
                    if (part != null) {
                        HelpView view = (HelpView)part;
                        view.showDynamicHelp(activePart, c);
                    }
                }
                catch (PartInitException partInitException) {}
            } else {
                Object data;
                if (activeShell != null && (data = activeShell.getData()) instanceof Window) {
                    IContext context = ContextHelpPart.findHelpContext(c);
                    this.displayContextAsHelpPane(activeShell, context);
                    return;
                }
                this.warnNoOpenPerspective(window);
            }
        }
    }

    public void search(String expression) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell activeShell = DefaultHelpUI.getActiveShell();
        if (window != null && DefaultHelpUI.isActiveShell(activeShell, window)) {
            IWorkbenchPage page;
            IIntroManager introMng = PlatformUI.getWorkbench().getIntroManager();
            IIntroPart intro = introMng.getIntro();
            if (intro != null && !introMng.isIntroStandby(intro)) {
                introMng.setIntroStandby(intro, true);
            }
            if ((page = window.getActivePage()) != null) {
                try {
                    IViewPart part = page.showView(HELP_VIEW_ID);
                    if (part != null) {
                        HelpView view = (HelpView)part;
                        view.startSearch(expression);
                    }
                }
                catch (PartInitException partInitException) {}
            } else {
                Object data;
                if (activeShell != null && (data = activeShell.getData()) instanceof Window) {
                    this.displayContextAsHelpPane(activeShell, null);
                    return;
                }
                this.warnNoOpenPerspective(window);
            }
        }
    }

    private void warnNoOpenPerspective(IWorkbenchWindow window) {
        MessageDialog.openInformation((Shell)window.getShell(), (String)Messages.DefaultHelpUI_wtitle, (String)Messages.DefaultHelpUI_noPerspMessage);
    }

    public void displayHelpResource(String href) {
        BaseHelpSystem.getHelpDisplay().displayHelpResource(href, this.useExternalBrowser(href));
    }

    public void displayContext(IContext context, int x, int y) {
        this.displayContext(context, x, y, false);
    }

    void displayContext(IContext context, int x, int y, boolean noInfopop) {
        Object data;
        IWorkbenchPage page;
        if (context == null) {
            return;
        }
        Preferences pref = HelpBasePlugin.getDefault().getPluginPreferences();
        boolean winfopop = pref.getBoolean("window_infopop");
        boolean dinfopop = pref.getBoolean("dialog_infopop");
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell activeShell = DefaultHelpUI.getActiveShell();
        if (window != null && DefaultHelpUI.isActiveShell(activeShell, window) && (page = window.getActivePage()) != null) {
            if (!noInfopop && winfopop) {
                this.displayContextAsInfopop(context, x, y);
                return;
            }
            try {
                IWorkbenchPart activePart = page.getActivePart();
                Control c = window.getShell().getDisplay().getFocusControl();
                IViewPart part = page.showView(HELP_VIEW_ID, null, 2);
                if (part != null) {
                    HelpView view = (HelpView)part;
                    view.displayContext(context, activePart, c);
                }
                return;
            }
            catch (PartInitException partInitException) {}
        }
        if (activeShell != null && (data = activeShell.getData()) instanceof Window && (!dinfopop || noInfopop)) {
            this.displayContextAsHelpPane(activeShell, context);
            return;
        }
        this.displayContextAsInfopop(context, x, y);
    }

    public URL resolve(String href, boolean documentOnly) {
        return BaseHelpSystem.resolve((String)href, (boolean)documentOnly);
    }

    public String unresolve(URL url) {
        return BaseHelpSystem.unresolve((URL)url);
    }

    private static Shell getActiveShell() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        return display.getActiveShell();
    }

    private static boolean isActiveShell(Shell activeShell, IWorkbenchWindow window) {
        return activeShell != null && activeShell.equals(window.getShell());
    }

    private void displayContextAsInfopop(IContext context, int x, int y) {
        if (this.f1Dialog != null) {
            this.f1Dialog.close();
        }
        if (context == null) {
            return;
        }
        this.f1Dialog = new ContextHelpDialog(context, x, y);
        this.f1Dialog.open();
    }

    private void displayContextAsHelpPane(Shell activeShell, IContext context) {
        Control c = activeShell.getDisplay().getFocusControl();
        if (this.f1Window != null) {
            Shell parentShell = activeShell;
            if (activeShell.getData() instanceof ContextHelpWindow) {
                parentShell = (Shell)activeShell.getParent();
            }
            if (this.f1Window.getShell().getParent().equals(parentShell)) {
                this.f1Window.update(context, c);
                return;
            }
        }
        Rectangle pbounds = activeShell.getBounds();
        this.f1Window = new ContextHelpWindow(activeShell);
        this.f1Window.create();
        Shell helpShell = this.f1Window.getShell();
        helpShell.setText(Messages.DefaultHelpUI_wtitle);
        helpShell.setSize(300, pbounds.height);
        if (context != null) {
            this.f1Window.update(context, c);
        } else {
            this.f1Window.showSearch();
        }
        if (!Platform.getWS().equals("gtk")) {
            this.f1Window.dock(true);
        }
        helpShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DefaultHelpUI.this.f1Window = null;
            }
        });
        helpShell.open();
    }

    public boolean isContextHelpDisplayed() {
        if (this.f1Dialog == null) {
            return false;
        }
        return this.f1Dialog.isShowing();
    }

    private boolean useExternalBrowser(String url) {
        Display display = Display.getCurrent();
        if (display != null && this.insideModalParent(display)) {
            return true;
        }
        return url != null && (url.indexOf("?noframes=true") > 0 || url.indexOf("&noframes=true") > 0);
    }

    private boolean insideModalParent(Display display) {
        return DefaultHelpUI.isDisplayModal(display.getActiveShell());
    }

    public static boolean isDisplayModal(Shell activeShell) {
        while (activeShell != null) {
            if ((activeShell.getStyle() & 0x38000) > 0) {
                return true;
            }
            activeShell = (Shell)activeShell.getParent();
        }
        return false;
    }

    class ExternalWorkbenchBrowser
    implements IBrowser {
        private IWebBrowser getExternalBrowser() throws PartInitException {
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            return support.getExternalBrowser();
        }

        public void close() {
        }

        public boolean isCloseSupported() {
            return false;
        }

        public void displayURL(String url) throws Exception {
            try {
                IWebBrowser browser = this.getExternalBrowser();
                if (browser != null) {
                    browser.openURL(new URL(url));
                }
            }
            catch (PartInitException pie) {
                ErrorUtil.displayErrorDialog(pie.getLocalizedMessage());
            }
        }

        public boolean isSetLocationSupported() {
            return false;
        }

        public boolean isSetSizeSupported() {
            return false;
        }

        public void setLocation(int x, int y) {
        }

        public void setSize(int width, int height) {
        }
    }
}

