/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.ui.views.markers.internal.Messages;

public class MnemonicAssigner {
    private Set assigned = new HashSet();
    private String validHotkeys = new String();
    private Set validKeys = new HashSet();

    public MnemonicAssigner() {
        this.addKeys(Messages.getString("MnemonicAssigner.valid_mnemonics"));
    }

    private void addKeys(String keys) {
        this.validHotkeys = String.valueOf(this.validHotkeys) + keys;
        int idx = 0;
        while (idx < this.validHotkeys.length()) {
            this.validKeys.add(new Character(Character.toLowerCase(keys.charAt(idx))));
            ++idx;
        }
    }

    public boolean isReserved(char toCheck) {
        return this.assigned.contains(new Character(Character.toLowerCase(toCheck)));
    }

    private static int getAmpersandIndex(String inputString) {
        int idx = 0;
        while (idx < inputString.length() - 1) {
            char next = inputString.charAt(idx);
            if (next == '&') {
                if (inputString.charAt(idx + 1) == '&') {
                    ++idx;
                } else {
                    return idx;
                }
            }
            ++idx;
        }
        return inputString.length();
    }

    public static char getMnemonic(String inputString) {
        int idx = MnemonicAssigner.getAmpersandIndex(inputString);
        if (idx < inputString.length() - 1) {
            return inputString.charAt(idx + 1);
        }
        return '\u0000';
    }

    public void reserve(char toReserve) {
        this.assigned.add(new Character(Character.toLowerCase(toReserve)));
    }

    public static String withoutMnemonic(String toRemove) {
        String working = toRemove;
        int idx = MnemonicAssigner.getAmpersandIndex(working);
        while (idx < working.length()) {
            working = String.valueOf(working.substring(0, idx)) + working.substring(idx + 1, working.length());
            idx = MnemonicAssigner.getAmpersandIndex(working);
        }
        return working;
    }

    public String assign(String inputString) {
        String result = this.suggest(inputString);
        this.reserve(result);
        return result;
    }

    public void reserve(String inputString) {
        this.reserve(MnemonicAssigner.getMnemonic(inputString));
    }

    public boolean isValidMnemonic(char next) {
        return this.validKeys.contains(new Character(Character.toLowerCase(next)));
    }

    public String suggest(String inputString) {
        char next;
        char mnemonic = MnemonicAssigner.getMnemonic(inputString);
        if (mnemonic != '\u0000' && !this.isReserved(mnemonic)) {
            return inputString;
        }
        String stripped = MnemonicAssigner.withoutMnemonic(inputString);
        int bestMnemonic = -1;
        int mnemonicRank = -1;
        boolean lastWasWhitespace = true;
        int idx = 0;
        while (idx < stripped.length()) {
            next = stripped.charAt(idx);
            if (this.isValidMnemonic(next) && !this.isReserved(next)) {
                int thisRank = 0;
                if (Character.isUpperCase(next)) {
                    ++thisRank;
                }
                if (lastWasWhitespace) {
                    thisRank += 2;
                }
                if (thisRank <= mnemonicRank) break;
                bestMnemonic = idx;
                mnemonicRank = thisRank;
                break;
            }
            lastWasWhitespace = Character.isWhitespace(next);
            ++idx;
        }
        if (bestMnemonic >= 0) {
            return String.valueOf(stripped.substring(0, bestMnemonic)) + '&' + stripped.substring(bestMnemonic, stripped.length());
        }
        idx = 0;
        while (idx < this.validHotkeys.length()) {
            next = this.validHotkeys.charAt(idx);
            if (!this.isReserved(next)) {
                return Messages.format(Messages.getString("MnemonicAssigner.missing_mnemonic_format"), new String[]{stripped, "&" + next});
            }
            ++idx;
        }
        return inputString;
    }
}

