/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.ArchiveFileManipulations;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.TarException;
import org.eclipse.ui.internal.wizards.datatransfer.TarFile;
import org.eclipse.ui.internal.wizards.datatransfer.TarLeveledStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.ZipLeveledStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class WizardProjectsImportPage
extends WizardPage
implements IOverwriteQuery {
    private Text directoryPathField;
    private CheckboxTreeViewer projectsList;
    private ProjectRecord[] selectedProjects = new ProjectRecord[0];
    private static String previouslyBrowsedDirectory = "";
    private static String previouslyBrowsedArchive = "";
    private Button projectFromDirectoryRadio;
    private Button projectFromArchiveRadio;
    private Text archivePathField;
    private Button browseDirectoriesButton;
    private Button browseArchivesButton;
    private static final String[] FILE_IMPORT_MASK = new String[]{"*.jar;*.zip;*.tar;*.tar.gz;*.tgz", "*.*"};
    private String lastPath;

    public WizardProjectsImportPage() {
        this("wizardExternalProjectsPage");
    }

    public WizardProjectsImportPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
        this.setTitle(DataTransferMessages.WizardProjectsImportPage_ImportProjectsTitle);
        this.setDescription(DataTransferMessages.WizardProjectsImportPage_ImportProjectsDescription);
    }

    public WizardProjectsImportPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        this.createProjectsRoot(workArea);
        this.createProjectsList(workArea);
        Dialog.applyDialogFont((Control)workArea);
    }

    private void createProjectsList(Composite workArea) {
        Label title = new Label(workArea, 0);
        title.setText(DataTransferMessages.WizardProjectsImportPage_ProjectsListTitle);
        Composite listComposite = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        listComposite.setLayout((Layout)layout);
        listComposite.setLayoutData((Object)new GridData(1808));
        this.projectsList = new CheckboxTreeViewer(listComposite, 2048);
        GridData listData = new GridData(1808);
        this.projectsList.getControl().setLayoutData((Object)listData);
        this.projectsList.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return WizardProjectsImportPage.this.selectedProjects;
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.projectsList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ProjectRecord)element).getProjectName();
            }
        });
        this.projectsList.setInput((Object)this);
        this.createSelectionButtons(listComposite);
    }

    private void createSelectionButtons(Composite listComposite) {
        Composite buttonsComposite = new Composite(listComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(2));
        Button selectAll = new Button(buttonsComposite, 8);
        selectAll.setText(DataTransferMessages.DataTransfer_selectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportPage.this.projectsList.setCheckedElements((Object[])WizardProjectsImportPage.this.selectedProjects);
            }
        });
        this.setButtonLayoutData(selectAll);
        Button deselectAll = new Button(buttonsComposite, 8);
        deselectAll.setText(DataTransferMessages.DataTransfer_deselectAll);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportPage.this.projectsList.setCheckedElements(new Object[0]);
            }
        });
        this.setButtonLayoutData(deselectAll);
        Button refresh = new Button(buttonsComposite, 8);
        refresh.setText(DataTransferMessages.DataTransfer_refresh);
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WizardProjectsImportPage.this.projectFromDirectoryRadio.getSelection()) {
                    WizardProjectsImportPage.this.updateProjectsList(WizardProjectsImportPage.this.directoryPathField.getText().trim());
                } else {
                    WizardProjectsImportPage.this.updateProjectsList(WizardProjectsImportPage.this.archivePathField.getText().trim());
                }
            }
        });
        this.setButtonLayoutData(refresh);
    }

    private void createProjectsRoot(Composite workArea) {
        Composite projectGroup = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.projectFromDirectoryRadio = new Button(projectGroup, 16);
        this.projectFromDirectoryRadio.setText(DataTransferMessages.WizardProjectsImportPage_RootSelectTitle);
        this.directoryPathField = new Text(projectGroup, 2048);
        this.directoryPathField.setLayoutData((Object)new GridData(768));
        this.browseDirectoriesButton = new Button(projectGroup, 8);
        this.browseDirectoriesButton.setText(DataTransferMessages.DataTransfer_browse);
        this.setButtonLayoutData(this.browseDirectoriesButton);
        this.projectFromArchiveRadio = new Button(projectGroup, 16);
        this.projectFromArchiveRadio.setText(DataTransferMessages.WizardProjectsImportPage_ArchiveSelectTitle);
        this.archivePathField = new Text(projectGroup, 2048);
        this.archivePathField.setLayoutData((Object)new GridData(768));
        this.browseArchivesButton = new Button(projectGroup, 8);
        this.browseArchivesButton.setText(DataTransferMessages.DataTransfer_browse);
        this.setButtonLayoutData(this.browseArchivesButton);
        this.projectFromDirectoryRadio.setSelection(true);
        this.archivePathField.setEnabled(false);
        this.browseArchivesButton.setEnabled(false);
        this.browseDirectoriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportPage.this.handleLocationDirectoryButtonPressed();
            }
        });
        this.browseArchivesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportPage.this.handleLocationArchiveButtonPressed();
            }
        });
        this.directoryPathField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    WizardProjectsImportPage.this.updateProjectsList(WizardProjectsImportPage.this.directoryPathField.getText().trim());
                }
            }
        });
        this.directoryPathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                WizardProjectsImportPage.this.updateProjectsList(WizardProjectsImportPage.this.directoryPathField.getText().trim());
            }
        });
        this.archivePathField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    WizardProjectsImportPage.this.updateProjectsList(WizardProjectsImportPage.this.archivePathField.getText().trim());
                }
            }
        });
        this.archivePathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                WizardProjectsImportPage.this.updateProjectsList(WizardProjectsImportPage.this.archivePathField.getText().trim());
            }
        });
        this.projectFromDirectoryRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WizardProjectsImportPage.this.projectFromDirectoryRadio.getSelection()) {
                    WizardProjectsImportPage.this.directoryPathField.setEnabled(true);
                    WizardProjectsImportPage.this.browseDirectoriesButton.setEnabled(true);
                    WizardProjectsImportPage.this.archivePathField.setEnabled(false);
                    WizardProjectsImportPage.this.browseArchivesButton.setEnabled(false);
                    WizardProjectsImportPage.this.updateProjectsList(WizardProjectsImportPage.this.directoryPathField.getText());
                }
            }
        });
        this.projectFromArchiveRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WizardProjectsImportPage.this.projectFromArchiveRadio.getSelection()) {
                    WizardProjectsImportPage.this.directoryPathField.setEnabled(false);
                    WizardProjectsImportPage.this.browseDirectoriesButton.setEnabled(false);
                    WizardProjectsImportPage.this.archivePathField.setEnabled(true);
                    WizardProjectsImportPage.this.browseArchivesButton.setEnabled(true);
                    WizardProjectsImportPage.this.updateProjectsList(WizardProjectsImportPage.this.archivePathField.getText());
                }
            }
        });
    }

    protected void updateProjectsList(final String path) {
        if (path.equals(this.lastPath)) {
            return;
        }
        this.lastPath = path;
        if (path == null || path.length() == 0) {
            this.selectedProjects = new ProjectRecord[0];
            this.projectsList.refresh(true);
            this.projectsList.setCheckedElements((Object[])this.selectedProjects);
            this.setPageComplete(this.selectedProjects.length > 0);
            return;
        }
        final boolean dirSelected = this.projectFromDirectoryRadio.getSelection();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){
                ZipLeveledStructureProvider zipCurrentProvider;
                TarLeveledStructureProvider tarCurrentProvider;

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(DataTransferMessages.WizardProjectsImportPage_SearchingMessage, 100);
                    File directory = new File(path);
                    WizardProjectsImportPage.this.selectedProjects = new ProjectRecord[0];
                    ArrayList files = new ArrayList();
                    monitor.worked(10);
                    if (!dirSelected && ArchiveFileManipulations.isTarFile(path)) {
                        TarLeveledStructureProvider provider;
                        TarFile sourceTarFile = WizardProjectsImportPage.this.getSpecifiedTarSourceFile(path);
                        if (sourceTarFile == null) {
                            this.zipCurrentProvider = null;
                            this.tarCurrentProvider = null;
                            return;
                        }
                        this.tarCurrentProvider = provider = ArchiveFileManipulations.getTarStructureProvider(sourceTarFile, WizardProjectsImportPage.this.getContainer().getShell());
                        this.zipCurrentProvider = null;
                        Object child = provider.getRoot();
                        if (!WizardProjectsImportPage.this.collectProjectFilesFromProvider(files, provider, child, 0, monitor)) {
                            return;
                        }
                        Iterator filesIterator = files.iterator();
                        WizardProjectsImportPage.this.selectedProjects = new ProjectRecord[files.size()];
                        int index = 0;
                        monitor.worked(50);
                        monitor.subTask(DataTransferMessages.WizardProjectsImportPage_ProcessingMessage);
                        while (filesIterator.hasNext()) {
                            ((WizardProjectsImportPage)WizardProjectsImportPage.this).selectedProjects[index++] = (ProjectRecord)filesIterator.next();
                        }
                    } else if (!dirSelected && ArchiveFileManipulations.isZipFile(path)) {
                        ZipLeveledStructureProvider provider;
                        ZipFile sourceFile = WizardProjectsImportPage.this.getSpecifiedZipSourceFile(path);
                        if (sourceFile == null) {
                            this.zipCurrentProvider = null;
                            this.tarCurrentProvider = null;
                            return;
                        }
                        this.zipCurrentProvider = provider = ArchiveFileManipulations.getZipStructureProvider(sourceFile, WizardProjectsImportPage.this.getContainer().getShell());
                        this.tarCurrentProvider = null;
                        Object child = provider.getRoot();
                        if (!WizardProjectsImportPage.this.collectProjectFilesFromProvider(files, provider, child, 0, monitor)) {
                            return;
                        }
                        Iterator filesIterator = files.iterator();
                        WizardProjectsImportPage.this.selectedProjects = new ProjectRecord[files.size()];
                        int index = 0;
                        monitor.worked(50);
                        monitor.subTask(DataTransferMessages.WizardProjectsImportPage_ProcessingMessage);
                        while (filesIterator.hasNext()) {
                            ((WizardProjectsImportPage)WizardProjectsImportPage.this).selectedProjects[index++] = (ProjectRecord)filesIterator.next();
                        }
                    } else if (dirSelected && directory.isDirectory()) {
                        if (!WizardProjectsImportPage.this.collectProjectFilesFromDirectory(files, directory, monitor)) {
                            return;
                        }
                        Iterator filesIterator = files.iterator();
                        WizardProjectsImportPage.this.selectedProjects = new ProjectRecord[files.size()];
                        int index = 0;
                        monitor.worked(50);
                        monitor.subTask(DataTransferMessages.WizardProjectsImportPage_ProcessingMessage);
                        while (filesIterator.hasNext()) {
                            File file = (File)filesIterator.next();
                            ((WizardProjectsImportPage)WizardProjectsImportPage.this).selectedProjects[index] = new ProjectRecord(file);
                            ++index;
                        }
                    } else {
                        monitor.worked(60);
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            IDEWorkbenchPlugin.log(e.getMessage(), e);
        }
        catch (InterruptedException interruptedException) {}
        this.projectsList.refresh(true);
        this.projectsList.setCheckedElements((Object[])this.selectedProjects);
        this.setPageComplete(this.selectedProjects.length > 0);
    }

    protected ZipFile getSpecifiedZipSourceFile() {
        return this.getSpecifiedZipSourceFile(this.archivePathField.getText());
    }

    private ZipFile getSpecifiedZipSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new ZipFile(fileName);
        }
        catch (ZipException zipException) {
            this.displayErrorDialog(DataTransferMessages.ZipImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorDialog(DataTransferMessages.ZipImport_couldNotRead);
        }
        this.archivePathField.setFocus();
        return null;
    }

    protected TarFile getSpecifiedTarSourceFile() {
        return this.getSpecifiedTarSourceFile(this.archivePathField.getText());
    }

    private TarFile getSpecifiedTarSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new TarFile(fileName);
        }
        catch (TarException tarException) {
            this.displayErrorDialog(DataTransferMessages.TarImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorDialog(DataTransferMessages.ZipImport_couldNotRead);
        }
        this.archivePathField.setFocus();
        return null;
    }

    protected void displayErrorDialog(String message) {
        MessageDialog.openError((Shell)this.getContainer().getShell(), (String)this.getErrorDialogTitle(), (String)message);
    }

    protected String getErrorDialogTitle() {
        return IDEWorkbenchMessages.WizardExportPage_internalErrorTitle;
    }

    private boolean collectProjectFilesFromDirectory(Collection files, File directory, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.subTask(NLS.bind((String)DataTransferMessages.WizardProjectsImportPage_CheckingMessage, (Object)directory.getPath()));
        File[] contents = directory.listFiles();
        int i = 0;
        while (i < contents.length) {
            File file = contents[i];
            if (file.isFile() && file.getName().equals(".project")) {
                files.add(file);
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < contents.length) {
            if (contents[i].isDirectory()) {
                this.collectProjectFilesFromDirectory(files, contents[i], monitor);
            }
            ++i;
        }
        return true;
    }

    private boolean collectProjectFilesFromProvider(Collection files, ILeveledImportStructureProvider provider, Object entry, int level, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.subTask(NLS.bind((String)DataTransferMessages.WizardProjectsImportPage_CheckingMessage, (Object)provider.getLabel(entry)));
        ArrayList children = provider.getChildren(entry);
        if (children == null) {
            children = new ArrayList(1);
        }
        Iterator childrenEnum = children.iterator();
        while (childrenEnum.hasNext()) {
            String elementLabel;
            Object child = childrenEnum.next();
            if (provider.isFolder(child)) {
                this.collectProjectFilesFromProvider(files, provider, child, level + 1, monitor);
            }
            if (!(elementLabel = provider.getLabel(child)).equals(".project")) continue;
            files.add(new ProjectRecord(child, entry, level, provider));
        }
        return true;
    }

    protected void handleLocationDirectoryButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.directoryPathField.getShell());
        dialog.setMessage(DataTransferMessages.WizardProjectsImportPage_SelectDialogTitle);
        String dirName = this.directoryPathField.getText().trim();
        if (dirName.length() == 0) {
            dirName = previouslyBrowsedDirectory;
        }
        if (dirName.length() == 0) {
            dialog.setFilterPath(IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(new Path(dirName).toOSString());
            }
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            previouslyBrowsedDirectory = selectedDirectory;
            this.directoryPathField.setText(previouslyBrowsedDirectory);
            this.updateProjectsList(selectedDirectory);
        }
    }

    protected void handleLocationArchiveButtonPressed() {
        FileDialog dialog = new FileDialog(this.archivePathField.getShell());
        dialog.setFilterExtensions(FILE_IMPORT_MASK);
        dialog.setText(DataTransferMessages.WizardProjectsImportPage_SelectArchiveDialogTitle);
        String fileName = this.archivePathField.getText().trim();
        if (fileName.length() == 0) {
            fileName = previouslyBrowsedArchive;
        }
        if (fileName.length() == 0) {
            dialog.setFilterPath(IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(fileName);
            if (path.exists()) {
                dialog.setFilterPath(new Path(fileName).toOSString());
            }
        }
        String selectedArchive = dialog.open();
        if (selectedArchive != null) {
            previouslyBrowsedArchive = selectedArchive;
            this.archivePathField.setText(previouslyBrowsedArchive);
            this.updateProjectsList(selectedArchive);
        }
    }

    public boolean createProjects() {
        Object[] selected = this.projectsList.getCheckedElements();
        int i = 0;
        while (i < selected.length) {
            ProjectRecord record = (ProjectRecord)selected[i];
            if (!this.createExistingProject(record)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean createExistingProject(final ProjectRecord record) {
        String projectName = record.getProjectName();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject project = workspace.getRoot().getProject(projectName);
        if (record.description == null) {
            record.description = workspace.newProjectDescription(projectName);
            Path locationPath = new Path(record.projectSystemFile.getAbsolutePath());
            if (Platform.getLocation().isPrefixOf((IPath)locationPath)) {
                record.description.setLocation(null);
            } else {
                record.description.setLocation((IPath)locationPath);
            }
        } else {
            record.description.setName(projectName);
        }
        if (record.projectArchiveFile != null) {
            ArrayList fileSystemObjects = new ArrayList();
            this.getFilesForProject(fileSystemObjects, record.provider, record.parent);
            record.provider.setStrip(record.level);
            ImportOperation operation = new ImportOperation(project.getFullPath(), record.provider.getRoot(), record.provider, this, fileSystemObjects);
            operation.setContext(this.getShell());
            return this.executeImportOperation(operation);
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("", 2000);
                project.create(record.description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (((CoreException)t).getStatus().getCode() == 275) {
                MessageDialog.openError((Shell)this.getShell(), (String)DataTransferMessages.WizardExternalProjectImportPage_errorMessage, (String)NLS.bind((String)DataTransferMessages.WizardExternalProjectImportPage_caseVariantExistsError, (Object)record.description.getName()));
            } else {
                ErrorDialog.openError((Shell)this.getShell(), (String)DataTransferMessages.WizardExternalProjectImportPage_errorMessage, (String)((CoreException)t).getLocalizedMessage(), (IStatus)((CoreException)t).getStatus());
            }
            return false;
        }
        return true;
    }

    protected boolean getFilesForProject(Collection files, IImportStructureProvider provider, Object entry) {
        List children = provider.getChildren(entry);
        Iterator childrenEnum = children.iterator();
        while (childrenEnum.hasNext()) {
            Object child = childrenEnum.next();
            files.add(child);
            if (!provider.isFolder(child)) continue;
            this.getFilesForProject(files, provider, child);
        }
        return true;
    }

    protected boolean executeImportOperation(ImportOperation op) {
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)DataTransferMessages.FileImport_importProblems, null, (IStatus)status);
            return false;
        }
        return true;
    }

    public String queryOverwrite(String pathString) {
        Path path = new Path(pathString);
        String messageString = path.getFileExtension() == null || path.segmentCount() < 2 ? NLS.bind((String)IDEWorkbenchMessages.WizardDataTransfer_existsQuestion, (Object)pathString) : NLS.bind((String)IDEWorkbenchMessages.WizardDataTransfer_overwriteNameAndPathQuestion, (Object)path.lastSegment(), (Object)path.removeLastSegments(1).toOSString());
        final MessageDialog dialog = new MessageDialog(this.getContainer().getShell(), IDEWorkbenchMessages.Question, null, messageString, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        String[] response = new String[]{"YES", "ALL", "NO", "NOALL", "CANCEL"};
        this.getControl().getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        return dialog.getReturnCode() < 0 ? "CANCEL" : response[dialog.getReturnCode()];
    }

    private class ProjectRecord {
        File projectSystemFile;
        Object projectArchiveFile;
        String projectName;
        Object parent;
        int level;
        IProjectDescription description;
        ILeveledImportStructureProvider provider;

        ProjectRecord(File file) {
            this.projectSystemFile = file;
            this.setProjectName();
        }

        ProjectRecord(Object file, Object parent, int level, ILeveledImportStructureProvider entryProvider) {
            this.projectArchiveFile = file;
            this.parent = parent;
            this.level = level;
            this.provider = entryProvider;
            this.setProjectName();
        }

        private void setProjectName() {
            IProjectDescription newDescription = null;
            try {
                if (this.projectArchiveFile != null) {
                    InputStream stream = this.provider.getContents(this.projectArchiveFile);
                    newDescription = IDEWorkbenchPlugin.getPluginWorkspace().loadProjectDescription(stream);
                    stream.close();
                } else {
                    Path path = new Path(this.projectSystemFile.getPath());
                    newDescription = IDEWorkbenchPlugin.getPluginWorkspace().loadProjectDescription((IPath)path);
                }
            }
            catch (CoreException coreException) {
            }
            catch (IOException iOException) {}
            if (newDescription == null) {
                this.description = null;
                this.projectName = "";
            } else {
                this.description = newDescription;
                this.projectName = this.description.getName();
            }
        }

        public String getProjectName() {
            return this.projectName;
        }
    }
}

