/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class OpenResourceAction
extends WorkspaceAction
implements IResourceChangeListener {
    public static final String ID = "org.eclipse.ui.OpenResourceAction";

    public OpenResourceAction(Shell shell) {
        super(shell, IDEWorkbenchMessages.OpenResourceAction_text);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.open_resource_action_context");
        this.setToolTipText(IDEWorkbenchMessages.OpenResourceAction_toolTip);
        this.setId(ID);
    }

    protected String getOperationMessage() {
        return IDEWorkbenchMessages.OpenResourceAction_operationMessage;
    }

    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.OpenResourceAction_problemMessage;
    }

    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.OpenResourceAction_dialogTitle;
    }

    protected void invokeOperation(IResource resource, IProgressMonitor monitor) throws CoreException {
        ((IProject)resource).open(monitor);
    }

    protected boolean shouldPerformResourcePruning() {
        return false;
    }

    protected boolean updateSelection(IStructuredSelection s) {
        if (!this.selectionIsOfType(4)) {
            return false;
        }
        Iterator resources = this.getSelectedResources().iterator();
        while (resources.hasNext()) {
            IProject currentResource = (IProject)resources.next();
            if (currentResource.isOpen()) continue;
            return true;
        }
        return false;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta;
        List sel = this.getSelectedResources();
        if (this.selectionIsOfType(4) && (delta = event.getDelta()) != null) {
            IResourceDelta[] projDeltas = delta.getAffectedChildren(4);
            int i = 0;
            while (i < projDeltas.length) {
                IResourceDelta projDelta = projDeltas[i];
                if ((projDelta.getFlags() & 0x4000) != 0 && sel.contains(projDelta.getResource())) {
                    this.selectionChanged(this.getStructuredSelection());
                    return;
                }
                ++i;
            }
        }
    }

    public void run() {
        ISchedulingRule rule = null;
        IResourceRuleFactory factory = ResourcesPlugin.getWorkspace().getRuleFactory();
        Iterator resources = this.getSelectedResources().iterator();
        while (resources.hasNext()) {
            IProject project = (IProject)resources.next();
            rule = MultiRule.combine(rule, (ISchedulingRule)factory.modifyRule((IResource)project));
        }
        this.runInBackground(rule);
    }
}

