/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.builders;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;

public class NativeCodeAttributeValues {
    public static final int LANGUAGE_NAME = 0;
    public static final int LANGUAGE_CODE = 1;
    public static final String[][] LANGUAGES = new String[][]{{"Abkhazian", "ab"}, {"Afan (Oromo)", "om"}, {"Afar", "aa"}, {"Afrikaans", "af"}, {"Albanian", "sq"}, {"Amharic", "am"}, {"Arabic", "ar"}, {"Armenian", "hy"}, {"Assamese", "as"}, {"Aymara", "ay"}, {"Azerbaijani", "az"}, {"Bashkir", "ba"}, {"Basque", "eu"}, {"Bengali;Bangla", "bn"}, {"Bhutani", "dz"}, {"Bihari", "bh"}, {"Bislama", "bi"}, {"Breton", "br"}, {"Bulgarian", "bg"}, {"Burmese", "my"}, {"Byelorussian", "be"}, {"Cambodian", "km"}, {"Catalan", "ca"}, {"Chinese", "zh"}, {"Corsican", "co"}, {"Croatian", "hr"}, {"Czech", "cs"}, {"Danish", "da"}, {"Dutch", "nl"}, {"English", "en"}, {"Esperanto", "eo"}, {"Estonian", "et"}, {"Faroese", "fo"}, {"Fiji", "fj"}, {"Finnish", "fi"}, {"French", "fr"}, {"Frisian", "fy"}, {"Galician", "gl"}, {"Georgian", "ka"}, {"German", "de"}, {"Greek", "el"}, {"Greenlandic", "kl"}, {"Guarani", "gn"}, {"Gujarati", "gu"}, {"Hausa", "ha"}, {"Hebrew", "he"}, {"Hindi", "hi"}, {"Hungarian", "hu"}, {"Icelandic", "is"}, {"Indonesian", "id"}, {"Interlingua", "ia"}, {"Interlingue", "ie"}, {"Inuktitut", "iu"}, {"Inupiak", "ik"}, {"Irish", "ga"}, {"Italian", "it"}, {"Japanese", "ja"}, {"Javanese", "jv"}, {"Kannada", "kn"}, {"Kashmiri", "ks"}, {"Kazakh", "kk"}, {"Kinyarwanda", "rw"}, {"Kirghiz", "ky"}, {"Kurundi", "rn"}, {"Korean", "ko"}, {"Kurdish", "ku"}, {"Laothian", "lo"}, {"Latin", "la"}, {"Latvian;Lettish", "lv"}, {"Lingala", "ln"}, {"Lithuanian", "lt"}, {"Macedonian", "mk"}, {"Malagasy", "mg"}, {"Malay", "ms"}, {"Malayalam", "ml"}, {"Maltese", "mt"}, {"Maori", "mi"}, {"Marathi", "mr"}, {"Moldavian", "mo"}, {"Mongolian", "mn"}, {"Nauru", "na"}, {"Nepali", "ne"}, {"Norwegian", "no"}, {"Occitan", "oc"}, {"Oriya", "or"}, {"Pashto;Pushto", "ps"}, {"Persian (Farsi)", "fa"}, {"Polish", "pl"}, {"Portuguese", "pt"}, {"Punjabi", "pa"}, {"Quechua", "qu"}, {"Rhaeto-Romance", "rm"}, {"Romanian", "ro"}, {"Russian", "ru"}, {"Samoan", "sm"}, {"Sangho", "sg"}, {"Sanskrit", "sa"}, {"Scots Gaelic", "gd"}, {"Serbian", "sr"}, {"Serbo-Croatian", "sh"}, {"Sesotho", "st"}, {"Setswana", "tn"}, {"Shona", "sn"}, {"Sindhi", "sd"}, {"Singhalese", "si"}, {"Siswati", "ss"}, {"Slovak", "sk"}, {"Slovenian", "sl"}, {"Somali", "so"}, {"Spanish", "es"}, {"Sundanese", "su"}, {"Swahili", "sw"}, {"Swedish", "sv"}, {"Tagalog", "tl"}, {"Tajik", "tg"}, {"Tamil", "ta"}, {"Tatar", "tt"}, {"Telugu", "te"}, {"Thai", "th"}, {"Tibetan", "bo"}, {"Tigrinya", "ti"}, {"Tonga", "to"}, {"Tsonga", "ts"}, {"Turkish", "tr"}, {"Turkmen", "tk"}, {"Twi", "tw"}, {"Uigur", "ug"}, {"Ukrainian", "uk"}, {"Urdu", "ur"}, {"Uzbek", "uz"}, {"Vietnamese", "vi"}, {"Volapuk", "vo"}, {"Welsh", "cy"}, {"Wolof", "wo"}, {"Xhosa", "xh"}, {"Yiddish", "yi"}, {"Yoruba", "yo"}, {"Zhuang", "za"}, {"Zulu", "zu"}};
    public static final String[] EXCLUDE_FILES = new String[]{".classpath", ".project", "plugin.xml", "fragment.xml", "build.properties", "META-INF/MANIFEST.MF"};
    private static final String OSNAME_ALIASES_LOCATION = "org/eclipse/osgi/framework/internal/core/osname.aliases";
    private static final String PROCESSOR_ALIASES_LOCATION = "org/eclipse/osgi/framework/internal/core/processor.aliases";
    private static final String SPACE = " ";
    private static final String QUOTE = "\"";
    private static final String COMMENT = "#";
    public static String[] OS_TYPES = new String[0];
    public static String[] ADDITIONAL_OS_ALIASES = new String[0];
    public static String[] PROCESSOR_TYPES = new String[0];
    public static String[] ADDITIONAL_PROCESSOR_ALIASES = new String[0];

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        ZipFile smfJar = null;
        try {
            try {
                String path;
                BundleDescription desc;
                IPluginModelBase model = PDECore.getDefault().getModelManager().findModel("org.eclipse.osgi");
                if (model != null && (desc = model.getBundleDescription()) != null && (smfJar = new ZipFile(String.valueOf(path = desc.getLocation()) + "\\core.jar")) != null) {
                    NativeCodeAttributeValues.initializeOSTypes(smfJar);
                    NativeCodeAttributeValues.initializeProcessorTypes(smfJar);
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (smfJar == null) throw throwable;
                smfJar.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (smfJar == null) return;
        smfJar.close();
    }

    static void initializeOSTypes(ZipFile smfJar) {
        try {
            ZipEntry aliasFile = smfJar.getEntry(OSNAME_ALIASES_LOCATION);
            InputStream is = smfJar.getInputStream(aliasFile);
            Properties properties = new Properties();
            properties.load(is);
            TreeSet<Object> osTypes = new TreeSet<Object>();
            ArrayList additionalOSAliases = new ArrayList();
            Iterator<Map.Entry<Object, Object>> it = properties.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                osTypes.add(entry.getKey());
                NativeCodeAttributeValues.parseAliases((String)entry.getValue(), additionalOSAliases);
            }
            OS_TYPES = new String[osTypes.size()];
            osTypes.toArray(OS_TYPES);
            ADDITIONAL_OS_ALIASES = new String[additionalOSAliases.size()];
            additionalOSAliases.toArray(ADDITIONAL_OS_ALIASES);
        }
        catch (IOException ex) {
            PDECore.logException((Throwable)ex);
        }
    }

    static void initializeProcessorTypes(ZipFile smfJar) {
        try {
            ZipEntry aliasFile = smfJar.getEntry(PROCESSOR_ALIASES_LOCATION);
            InputStream is = smfJar.getInputStream(aliasFile);
            Properties properties = new Properties();
            properties.load(is);
            TreeSet<Object> processorTypes = new TreeSet<Object>();
            ArrayList additionalProcessorAliases = new ArrayList();
            Iterator<Map.Entry<Object, Object>> it = properties.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                processorTypes.add(entry.getKey());
                NativeCodeAttributeValues.parseAliases((String)entry.getValue(), additionalProcessorAliases);
            }
            PROCESSOR_TYPES = new String[processorTypes.size()];
            processorTypes.toArray(PROCESSOR_TYPES);
            ADDITIONAL_PROCESSOR_ALIASES = new String[additionalProcessorAliases.size()];
            additionalProcessorAliases.toArray(ADDITIONAL_PROCESSOR_ALIASES);
        }
        catch (IOException ex) {
            PDECore.logException((Throwable)ex);
        }
    }

    static void parseAliases(String line, List aliases) {
        boolean inQuote = false;
        StringTokenizer outer = new StringTokenizer(line, QUOTE, true);
        while (outer.hasMoreTokens()) {
            String token = outer.nextToken();
            if (token.equals(QUOTE)) {
                inQuote = !inQuote;
                continue;
            }
            if (inQuote) {
                aliases.add(token);
                continue;
            }
            StringTokenizer inner = new StringTokenizer(token, SPACE, false);
            while (inner.hasMoreTokens()) {
                String next = inner.nextToken();
                if (next.startsWith(COMMENT)) {
                    return;
                }
                aliases.add(next);
            }
        }
    }
}

