/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.builders;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.PDE;
import org.eclipse.pde.internal.PDEMessages;
import org.eclipse.pde.internal.builders.CompilerFlags;
import org.eclipse.pde.internal.builders.IHeader;
import org.eclipse.pde.internal.builders.IMarkerFactory;
import org.eclipse.pde.internal.builders.JarManifestHeader;
import org.eclipse.pde.internal.builders.SchemaMarkerFactory;
import org.eclipse.pde.internal.core.PDECore;

public class JarManifestErrorReporter {
    protected static final String[] BOOLEAN_VALUES = new String[]{"true", "false"};
    private int fErrorCount = 0;
    protected IFile fFile;
    protected Map fHeaders;
    private IMarkerFactory fMarkerFactory;
    protected IProject fProject = null;
    protected IDocument fTextDocument;

    public JarManifestErrorReporter(IFile file) {
        this.fFile = file;
        if (file != null) {
            this.fProject = file.getProject();
        }
        this.fTextDocument = this.createDocument(file);
    }

    private void addMarker(String message, int lineNumber, int severity) {
        try {
            IMarker marker = this.getMarkerFactory().createMarker(this.fFile);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            if (lineNumber == -1) {
                lineNumber = 1;
            }
            marker.setAttribute("lineNumber", lineNumber);
            if (severity == 2) {
                ++this.fErrorCount;
            }
        }
        catch (CoreException e) {
            PDECore.logException((Throwable)e);
        }
    }

    protected IDocument createDocument(IFile file) {
        if (!file.exists()) {
            return null;
        }
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        if (manager == null) {
            return null;
        }
        try {
            manager.connect(file.getFullPath(), null);
            ITextFileBuffer textBuf = manager.getTextFileBuffer(file.getFullPath());
            IDocument document = textBuf.getDocument();
            manager.disconnect(file.getFullPath(), null);
            return document;
        }
        catch (CoreException e) {
            PDE.log(e);
            return null;
        }
    }

    public int getErrorCount() {
        return this.fErrorCount;
    }

    private String getHeaderName(String line) {
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            if (c == ':') {
                return line.substring(0, i);
            }
            if (!(c >= 'A' && 'Z' >= c || c >= 'a' && 'z' >= c || c >= '0' && '9' >= c)) {
                if (i == 0) {
                    return null;
                }
                if (c != '-' && c != '_') {
                    return null;
                }
            }
            ++i;
        }
        return null;
    }

    protected int getLine(IHeader header, String valueSubstring) {
        int l = header.getLineNumber();
        while (l < header.getLineNumber() + header.getLinesSpan()) {
            try {
                IRegion lineRegion = this.fTextDocument.getLineInformation(l);
                String lineStr = this.fTextDocument.get(lineRegion.getOffset(), lineRegion.getLength());
                if (lineStr.indexOf(valueSubstring) >= 0) {
                    return l + 1;
                }
            }
            catch (BadLocationException ble) {
                PDECore.logException((Throwable)ble);
            }
            ++l;
        }
        try {
            IRegion lineRegion = this.fTextDocument.getLineInformation(header.getLineNumber());
            String lineStr = this.fTextDocument.get(lineRegion.getOffset(), lineRegion.getLength());
            int l2 = header.getLineNumber() + 1;
            while (l2 < header.getLineNumber() + header.getLinesSpan()) {
                lineRegion = this.fTextDocument.getLineInformation(l2);
                if ((lineStr = String.valueOf(lineStr) + this.fTextDocument.get(lineRegion.getOffset() + 1, lineRegion.getLength())).indexOf(valueSubstring) >= 0) {
                    return l2;
                }
                ++l2;
            }
        }
        catch (BadLocationException ble) {
            PDECore.logException((Throwable)ble);
        }
        return header.getLineNumber() + 1;
    }

    private IMarkerFactory getMarkerFactory() {
        if (this.fMarkerFactory == null) {
            this.fMarkerFactory = new SchemaMarkerFactory();
        }
        return this.fMarkerFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parseManifest(IDocument document, IProgressMonitor monitor) {
        try {
            String line;
            IRegion lineInfo;
            this.fHeaders = new HashMap();
            JarManifestHeader header = null;
            int l = 0;
            while (l < document.getNumberOfLines()) {
                ByteBuffer byteBuf;
                if (l % 100 == 0) {
                    this.checkCanceled(monitor);
                }
                lineInfo = document.getLineInformation(l);
                line = document.get(lineInfo.getOffset(), lineInfo.getLength());
                Charset charset = Charset.forName("UTF-8");
                String lineDelimiter = document.getLineDelimiter(l);
                if (lineDelimiter == null) {
                    lineDelimiter = "";
                }
                if ((byteBuf = charset.encode(line)).limit() + lineDelimiter.length() > 512) {
                    this.report(PDEMessages.BundleErrorReporter_lineTooLong, l + 1, 0);
                    return;
                }
                if (line.length() == 0) {
                    if (l == 0) {
                        this.report(PDEMessages.BundleErrorReporter_noMainSection, 1, 0);
                        return;
                    }
                    if (header == null) break;
                    this.fHeaders.put(header.getName(), header);
                    header = null;
                    break;
                }
                if (line.charAt(0) == ' ') {
                    if (l == 0) {
                        this.report(PDEMessages.BundleErrorReporter_noMainSection, 1, 0);
                        return;
                    }
                    if (header != null) {
                        header.append(line.substring(1));
                    }
                } else {
                    int colon;
                    if (header != null) {
                        this.fHeaders.put(header.getName(), header);
                        header = null;
                    }
                    if ((colon = line.indexOf(58)) == -1) {
                        this.report(PDEMessages.BundleErrorReporter_noColon, l + 1, 0);
                        return;
                    }
                    String headerName = this.getHeaderName(line);
                    if (headerName == null) {
                        this.report(PDEMessages.BundleErrorReporter_invalidHeaderName, l + 1, 0);
                        return;
                    }
                    if (line.length() < colon + 2 || line.charAt(colon + 1) != ' ') {
                        this.report(PDEMessages.BundleErrorReporter_noSpaceValue, l + 1, 0);
                        return;
                    }
                    if ("Name".equals(headerName)) {
                        this.report(PDEMessages.BundleErrorReporter_nameHeaderInMain, l + 1, 0);
                        return;
                    }
                    header = new JarManifestHeader(headerName, line.substring(colon + 2), l, this);
                    if (this.fHeaders.containsKey(header.getName())) {
                        this.report(PDEMessages.BundleErrorReporter_duplicateHeader, l + 1, 1);
                    }
                }
                ++l;
            }
            if (header != null) {
                this.report(PDEMessages.BundleErrorReporter_noLineTermination, l, 0);
                return;
            }
            while (true) {
                if (l >= document.getNumberOfLines()) {
                    return;
                }
                lineInfo = document.getLineInformation(l);
                line = document.get(lineInfo.getOffset(), lineInfo.getLength());
                if (line.length() != 0 && !line.startsWith("Name:")) {
                    this.report(PDEMessages.BundleErrorReporter_noNameHeader, l, 0);
                    return;
                }
                ++l;
            }
        }
        catch (BadLocationException ble) {
            PDECore.logException((Throwable)ble);
            return;
        }
    }

    private void removeFileMarkers() {
        try {
            this.fFile.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
            this.fFile.deleteMarkers("org.eclipse.pde.validation-marker", false, 0);
        }
        catch (CoreException e) {
            PDECore.logException((Throwable)e);
        }
    }

    public void report(String message, int line, int severity) {
        if (severity == 0) {
            this.addMarker(message, line, 2);
        } else if (severity == 1) {
            this.addMarker(message, line, 1);
        }
    }

    protected void report(String message, int line, String compilerFlag) {
        int severity = CompilerFlags.getFlag(this.fProject, compilerFlag);
        if (severity != 2) {
            this.report(message, line, severity);
        }
    }

    protected void reportIllegalAttributeValue(IHeader header, String key, String value) {
        String msg = NLS.bind((String)PDEMessages.BundleErrorReporter_att_value, (Object[])new String[]{value, key});
        this.report(msg, this.getLine(header, String.valueOf(key) + "="), 0);
    }

    protected void reportIllegalValue(IHeader header) {
        String msg = NLS.bind((String)PDEMessages.BundleErrorReporter_illegal_value, (Object)header.getValue());
        this.report(msg, this.getLine(header, header.getValue()), 0);
    }

    protected void reportIllegalDirectiveValue(IHeader header, String key, String value) {
        String msg = NLS.bind((String)PDEMessages.BundleErrorReporter_dir_value, (Object[])new String[]{value, key});
        this.report(msg, this.getLine(header, String.valueOf(key) + ":="), 0);
    }

    protected void validateAttributeValue(IHeader header, ManifestElement element, String key, String[] allowedValues) {
        String value = element.getAttribute(key);
        if (value == null) {
            return;
        }
        int i = 0;
        while (i < allowedValues.length) {
            if (allowedValues[i].equals(value)) {
                return;
            }
            ++i;
        }
        this.reportIllegalAttributeValue(header, key, value);
    }

    protected void validateBooleanAttributeValue(IHeader header, ManifestElement element, String key) {
        this.validateAttributeValue(header, element, key, BOOLEAN_VALUES);
    }

    protected void validateBooleanDirectiveValue(IHeader header, ManifestElement element, String key) {
        this.validateDirectiveValue(header, element, key, BOOLEAN_VALUES);
    }

    protected void validateBooleanValue(IHeader header) {
        this.validateHeaderValue(header, BOOLEAN_VALUES);
    }

    public void validateContent(IProgressMonitor monitor) {
        this.removeFileMarkers();
        if (this.fTextDocument == null) {
            return;
        }
        this.parseManifest(this.fTextDocument, monitor);
    }

    protected void validateDirectiveValue(IHeader header, ManifestElement element, String key, String[] allowedValues) {
        String value = element.getDirective(key);
        if (value == null) {
            return;
        }
        int i = 0;
        while (i < allowedValues.length) {
            if (allowedValues[i].equals(value)) {
                return;
            }
            ++i;
        }
        this.reportIllegalDirectiveValue(header, key, value);
    }

    protected void validateHeaderValue(IHeader header, String[] allowedValues) {
        if (header.getValue() == null) {
            return;
        }
        int i = 0;
        while (i < allowedValues.length) {
            if (allowedValues[i].equals(header.getValue())) {
                return;
            }
            ++i;
        }
        this.reportIllegalValue(header);
    }

    protected void checkCanceled(IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

