/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.packager;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.AssembleConfigScriptGenerator;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.FileSet;
import org.eclipse.pde.internal.build.builder.FeatureBuildScriptGenerator;
import org.eclipse.pde.internal.build.builder.ModelBuildScriptGenerator;

public class PackageConfigScriptGenerator
extends AssembleConfigScriptGenerator {
    protected void generateGatherBinPartsCalls() {
        String excludedFiles = "build.properties, .project, .classpath";
        int i = 0;
        while (i < this.plugins.length) {
            Path pluginLocation = new Path(this.plugins[i].getLocation());
            boolean isFolder = this.isFolder(pluginLocation);
            if (isFolder) {
                this.script.printCopyTask(null, String.valueOf(Utils.getPropertyFormat("assemblyTempDir")) + '/' + Utils.getPropertyFormat("pluginArchivePrefix") + '/' + ModelBuildScriptGenerator.getNormalizedName(this.plugins[i]), new FileSet[]{new FileSet(pluginLocation.toOSString(), null, null, null, excludedFiles, null, null)}, false, false);
            } else {
                this.script.printCopyFileTask(pluginLocation.toOSString(), String.valueOf(Utils.getPropertyFormat("assemblyTempDir")) + '/' + Utils.getPropertyFormat("pluginArchivePrefix") + '/' + pluginLocation.lastSegment(), false);
            }
            ++i;
        }
        i = 0;
        while (i < this.features.length) {
            Path featureLocation = new Path(this.features[i].getURL().getPath());
            featureLocation = featureLocation.removeLastSegments(1);
            this.script.printCopyTask(null, String.valueOf(Utils.getPropertyFormat("assemblyTempDir")) + '/' + Utils.getPropertyFormat("featureArchivePrefix") + '/' + FeatureBuildScriptGenerator.getNormalizedName(this.features[i]), new FileSet[]{new FileSet(featureLocation.toOSString(), null, null, null, null, null, null)}, false, false);
            ++i;
        }
        if (this.rootFileProviders.size() != 0) {
            FileSet rootFiles = new FileSet(String.valueOf(Utils.getPropertyFormat("tempDirectory")) + '/' + this.configInfo.toStringReplacingAny(".", "ANY") + "/eclipse", null, "**/**", null, null, null, null);
            String target = String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + this.configInfo.toStringReplacingAny(".", "ANY") + '/' + Utils.getPropertyFormat("collectingFolder");
            this.script.printCopyTask(null, target, new FileSet[]{rootFiles}, false, false);
        }
    }

    public String getTargetName() {
        return "package" + (this.featureId.equals("") ? "" : String.valueOf('.') + this.featureId) + (this.configInfo.equals(Config.genericConfig()) ? "" : String.valueOf('.') + this.configInfo.toStringReplacingAny(".", "ANY"));
    }

    private boolean isFolder(Path pluginLocation) {
        return pluginLocation.toFile().isDirectory();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPackagingPropertiesLocation(String packagingPropertiesLocation) throws CoreException {
        Properties packagingProperties = new Properties();
        if (packagingPropertiesLocation == null || packagingPropertiesLocation.equals("")) {
            return;
        }
        BufferedInputStream propertyStream = null;
        try {
            propertyStream = new BufferedInputStream(new FileInputStream(packagingPropertiesLocation));
            try {
                packagingProperties.load(new BufferedInputStream(propertyStream));
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                ((InputStream)propertyStream).close();
                throw throwable;
            }
            {
                Object var4_8 = null;
                ((InputStream)propertyStream).close();
            }
        }
        catch (FileNotFoundException e) {
            String message = NLS.bind((String)Messages.exception_readingFile, (Object)packagingPropertiesLocation);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e));
        }
        catch (IOException e) {
            String message = NLS.bind((String)Messages.exception_readingFile, (Object)packagingPropertiesLocation);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e));
        }
        if (packagingProperties.size() != 0) {
            this.rootFileProviders = new ArrayList(1);
            this.rootFileProviders.add("elt");
        }
    }

    protected void generateGatherSourceCalls() {
    }

    protected FileSet[] generatePermissions(boolean zip) {
        return new FileSet[0];
    }
}

