/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.internal.runtime.FindSupport;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class BundleHelper {
    private Bundle bundle;
    private BundleContext context;
    private static BundleHelper defaultInstance;
    private boolean debug = false;

    public static BundleHelper getDefault() {
        return defaultInstance;
    }

    static void close() {
        if (defaultInstance != null) {
            BundleHelper.defaultInstance.context = null;
            BundleHelper.defaultInstance.bundle = null;
            defaultInstance = null;
        }
    }

    BundleHelper(BundleContext context) throws RuntimeException {
        if (defaultInstance != null) {
            throw new RuntimeException("Can not instantiate bundle helper");
        }
        this.context = context;
        defaultInstance = this;
        this.bundle = context.getBundle();
        this.debug = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.pde.build/debug"));
    }

    public final URL find(IPath path) {
        return FindSupport.find((Bundle)this.bundle, (IPath)path, null);
    }

    public final URL find(IPath path, Map override) {
        return FindSupport.find((Bundle)this.bundle, (IPath)path, (Map)override);
    }

    public final ILog getLog() {
        return Platform.getLog((Bundle)this.bundle);
    }

    public final IPath getStateLocation() throws IllegalStateException {
        return Platform.getStateLocation((Bundle)BundleHelper.getDefault().bundle);
    }

    public final InputStream openStream(IPath file) throws IOException {
        return FindSupport.openStream((Bundle)this.bundle, (IPath)file, (boolean)false);
    }

    public final InputStream openStream(IPath file, boolean localized) throws IOException {
        return FindSupport.openStream((Bundle)this.bundle, (IPath)file, (boolean)localized);
    }

    public String toString() {
        return this.bundle.getSymbolicName();
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public Object acquireService(String serviceName) {
        ServiceReference reference = this.context.getServiceReference(serviceName);
        if (reference == null) {
            return null;
        }
        return this.context.getService(reference);
    }

    public boolean isDebugging() {
        return this.debug;
    }

    public Filter createFilter(String filter) {
        try {
            return this.context.createFilter(filter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
    }
}

